/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.ITablePrecisionProvider;
import java.util.HashMap;
import java.util.Map;

public class DefaultLocalCurrencyPrecProvider
implements ITablePrecisionProvider {
    private String companyColName;
    private Map map;

    public DefaultLocalCurrencyPrecProvider(String companyColName) {
        this.companyColName = companyColName;
        this.map = new HashMap();
    }

    @Override
    public int getPrecision(IRow row) throws EASBizException, BOSException {
        if (this.companyColName == null) {
            return 2;
        }
        if (row.getCell(this.companyColName) == null || row.getCell(this.companyColName).getValue() == null) {
            return 2;
        }
        String companyId = row.getCell(this.companyColName).getValue().toString();
        String currencyId = null;
        if (this.map.containsKey(companyId)) {
            currencyId = (String)this.map.get(companyId);
        } else {
            currencyId = this.getCurrencyId(companyId);
            this.map.put(companyId, currencyId);
        }
        if (currencyId == null) {
            return 2;
        }
        return FMClientHelper.getPrecOfCurrency(BOSUuid.read((String)currencyId));
    }

    private String getCurrencyId(String companyId) throws EASBizException, BOSException {
        ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getRemoteInstance();
        CompanyOrgUnitInfo company = iCompany.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        return company.getBaseCurrency().getId().toString();
    }
}

