/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.client;

import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.export.ExporterParameter;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.printout.PrintableBook;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.util.SimpleFileFilter;
import com.kingdee.eas.fm.common.client.ExcelFileFilter;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.io.File;
import java.util.Locale;
import javax.swing.filechooser.FileFilter;

public class ExportHelper {
    public static final String RES = "com.kingdee.eas.fm.common.client.FMCommonClientResource";

    public static void export(Component ui, KDTable table) throws Exception {
        ExportHelper.export(ui, table, false);
    }

    public static void export(Component ui, KDTable table, boolean flag) throws Exception {
        String filePath = null;
        ExcelFileFilter excleFilter = new ExcelFileFilter();
        SimpleFileFilter txtFilter = new SimpleFileFilter("txt");
        SimpleFileFilter csvFilter = new SimpleFileFilter("csv");
        KDFileChooser fileChooser = new KDFileChooser();
        fileChooser.setAcceptAllFileFilterUsed(true);
        fileChooser.setFileFilter((FileFilter)txtFilter);
        fileChooser.setFileFilter((FileFilter)csvFilter);
        fileChooser.setFileFilter((FileFilter)excleFilter);
        String fileName = null;
        File fileDir = null;
        String totalFileName = null;
        if (fileChooser.showSaveDialog(ui) == 0) {
            filePath = fileChooser.getSelectedFile().getPath();
            fileDir = new File(filePath.substring(0, filePath.lastIndexOf("\\")));
            totalFileName = fileName = fileChooser.getSelectedFile().getName();
            if (fileName.lastIndexOf(".") != -1) {
                fileName = fileName.substring(0, fileName.lastIndexOf("."));
            }
            totalFileName = fileChooser.getFileFilter() == excleFilter ? fileName + ".xls" : (fileChooser.getFileFilter() == txtFilter ? fileName + ".txt" : (fileChooser.getFileFilter() == csvFilter ? fileName + ".csv" : fileName + ".xls"));
            filePath = fileChooser.getFileFilter() == excleFilter ? filePath + ".xls" : (fileChooser.getFileFilter() == txtFilter ? filePath + ".txt" : (fileChooser.getFileFilter() == csvFilter ? filePath + ".csv" : filePath + ".xls"));
        } else {
            return;
        }
        if (filePath == null) {
            return;
        }
        if (fileName.lastIndexOf(".") != -1) {
            fileName = fileName.substring(0, fileName.lastIndexOf("."));
        }
        File[] files = null;
        int status = -1;
        if (fileDir != null && fileDir.isDirectory()) {
            files = fileDir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].isFile() || !files[i].getName().equals(totalFileName) || (status = MsgBox.showConfirm2((Component)ui, (String)EASResource.getString((String)RES, (String)"FileExisted"))) != 2) continue;
                return;
            }
        }
        KDSBook kdsBook = new KDSBook(fileName);
        String sheetName = fileName;
        KDSSheet kdsSheet = flag ? table.getIOManager().saveToKDSSheet(kdsBook, true, false, sheetName) : table.getIOManager().saveToKDSSheet(kdsBook, true, false, false, sheetName);
        kdsBook.addSheet(null, kdsSheet);
        ExportManager export = new ExportManager();
        try {
            if (totalFileName.toLowerCase(Locale.ENGLISH).endsWith(".xls")) {
                export.exportToExcel(kdsBook, filePath);
            } else {
                export.setExporterParmeter(ExporterParameter.CHARACTER_ENCODING, (Object)"GBK");
                export.exportToCsv(new PrintableBook(kdsBook), filePath);
            }
            MsgBox.showInfo((Component)ui, (String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"12_ExportHelper"));
        }
        catch (RuntimeException e1) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)RES, (String)"fileIsOpen"));
        }
    }
}

