/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankPropertyEnum;
import com.kingdee.eas.basedata.assistant.AccountPropertyCollection;
import com.kingdee.eas.basedata.assistant.AccountPropertyFactory;
import com.kingdee.eas.basedata.assistant.AccountPropertyInfo;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.ProjectStatus;
import com.kingdee.eas.basedata.assistant.client.BankF7Selector;
import com.kingdee.eas.basedata.assistant.client.F7ProjectUI;
import com.kingdee.eas.basedata.framework.client.GeneralKDPromptSelectorAdaptor;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewAdminF7;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.basedata.person.client.PersonPromptBox;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.fs.InnerAccountFactory;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Component;
import java.util.HashMap;
import java.util.HashSet;

public class F7SelectorFactory {
    public static NewCompanyF7 getSelectCompany(IUIObject coreui, IUIObject targetUI, ItemAction action, boolean isMultiSelect) {
        NewCompanyF7 f7 = new NewCompanyF7(coreui);
        f7.setMultiSelect(isMultiSelect);
        if (action == null) {
            f7.setUsePerm(false);
            f7.setRootUnitID("00000000-0000-0000-0000-000000000000CCE7AED4");
            f7.setShowSub(true);
        } else {
            f7.setUIAction(targetUI, action);
        }
        return f7;
    }

    public static void initPerson(IUIObject coreui, KDBizPromptBox box) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("All_Admins", "YES");
        PersonPromptBox select = new PersonPromptBox(coreui, map);
        box.setSelector((KDPromptSelector)select);
        select.setHasCUDefaultFilter(false);
        box.setHasCUDefaultFilter(false);
        box.setQueryInfo("com.kingdee.eas.basedata.person.app.PersonQuery");
    }

    public static void initAdminOrgUnit(IUIObject coreui, KDBizPromptBox prmtDepartment) {
        prmtDepartment.setQueryInfo("com.kingdee.eas.basedata.org.app.AdminOrgUnitQuery");
        prmtDepartment.setVisible(true);
        prmtDepartment.setEditable(true);
        prmtDepartment.setDisplayFormat("$name$");
        prmtDepartment.setEditFormat("$number$");
        prmtDepartment.setCommitFormat("$number$");
        prmtDepartment.setRequired(true);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("isFreeze", (Object)new Integer(0)));
        fic.add(new FilterItemInfo("isSealUp", (Object)new Integer(0)));
        fic.add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
        prmtDepartment.setEntityViewInfo(view);
        NewAdminF7 f7 = new NewAdminF7(coreui);
        f7.setNeedAddOrgRange(false);
        prmtDepartment.setSelector((KDPromptSelector)f7);
    }

    public static void initAdminOrgUnitWithRoot(IUIObject coreui, KDBizPromptBox prmtDepartment, CompanyOrgUnitInfo company) {
        prmtDepartment.setQueryInfo("com.kingdee.eas.basedata.org.app.AdminOrgUnitQuery");
        prmtDepartment.setVisible(true);
        prmtDepartment.setEditable(true);
        prmtDepartment.setDisplayFormat("$name$");
        prmtDepartment.setEditFormat("$number$");
        prmtDepartment.setCommitFormat("$number$");
        if (company.getId() != null && company.getCU() == null) {
            try {
                company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId().toString()));
            }
            catch (EASBizException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("isFreeze", (Object)new Integer(0)));
        fic.add(new FilterItemInfo("isSealUp", (Object)new Integer(0)));
        fic.add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
        prmtDepartment.setEntityViewInfo(view);
        NewAdminF7 f7 = new NewAdminF7(coreui);
        f7.setRootUnitID(company.getId().toString());
        f7.setNeedAddOrgRange(false);
        prmtDepartment.setSelector((KDPromptSelector)f7);
    }

    public static void initAdminOrgUnit(IUIObject coreui, KDBizPromptBox prmtDepartment, boolean requestValue) {
        prmtDepartment.setQueryInfo("com.kingdee.eas.basedata.org.app.AdminOrgUnitQuery");
        prmtDepartment.setVisible(true);
        prmtDepartment.setEditable(true);
        prmtDepartment.setDisplayFormat("$name$");
        prmtDepartment.setEditFormat("$number$");
        prmtDepartment.setCommitFormat("$number$");
        prmtDepartment.setRequired(requestValue);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("isFreeze", (Object)new Integer(0)));
        fic.add(new FilterItemInfo("isSealUp", (Object)new Integer(0)));
        fic.add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
        prmtDepartment.setEntityViewInfo(view);
        NewAdminF7 f7 = new NewAdminF7();
        f7.setNeedAddOrgRange(false);
        prmtDepartment.setSelector((KDPromptSelector)f7);
    }

    public static void initAccountBank(IUIObject coreui, KDBizPromptBox prmtBankAcct) {
        F7SelectorFactory.initAccountBank(coreui, prmtBankAcct, ContextHelperFactory.getRemoteInstance().getCurrentCompany());
    }

    public static void initAccountBank(IUIObject coreui, KDBizPromptBox prmtBankAcct, CompanyOrgUnitInfo company) {
        EntityViewInfo entryViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (company != null) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)company.getId().toString()));
        }
        entryViewInfo.setFilter(filter);
        prmtBankAcct.setEntityViewInfo(entryViewInfo);
        prmtBankAcct.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7AccountBankQuery");
        prmtBankAcct.setDisplayFormat("$name$ $bankAccountNumber$");
        prmtBankAcct.setEditFormat("$number$");
        prmtBankAcct.setCommitFormat("$number$;$name$");
    }

    public static void initAccountBank(KDBizPromptBox prmtBankAcct, BankInfo bankInfo, AccountBankPropertyEnum property) {
        F7SelectorFactory.initAccountBank(prmtBankAcct, ContextHelperFactory.getRemoteInstance().getCurrentCompany(), bankInfo, property);
    }

    public static void initAccountBank(KDBizPromptBox prmtBankAcct, CompanyOrgUnitInfo companyInfo, BankInfo bankInfo, AccountBankPropertyEnum property) {
        EntityViewInfo entryViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (companyInfo != null) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyInfo.getId().toString()));
        }
        if (bankInfo != null) {
            filter.getFilterItems().add(new FilterItemInfo("bank.id", (Object)bankInfo.getId().toString()));
        }
        if (property != null) {
            filter.getFilterItems().add(new FilterItemInfo("property.property", (Object)property.getValue()));
        }
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)false));
        entryViewInfo.setFilter(filter);
        prmtBankAcct.setEntityViewInfo(entryViewInfo);
        prmtBankAcct.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7AccountBankQuery");
        prmtBankAcct.setDisplayFormat("$name$ $bankAccountNumber$");
        prmtBankAcct.setEditFormat("$number$");
        prmtBankAcct.setCommitFormat("$number$;$name$");
    }

    public static void initPayerAccount(IUIObject coreui, KDBizPromptBox prmtDepartment, CompanyOrgUnitInfo company) {
        EntityViewInfo entryViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (company != null) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)company.getId().toString()));
        }
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Boolean.FALSE));
        entryViewInfo.setFilter(filter);
        prmtDepartment.setEntityViewInfo(entryViewInfo);
        prmtDepartment.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7AccountBankQuery");
        prmtDepartment.setDisplayFormat("$name$ $bankAccountNumber$");
        prmtDepartment.setEditFormat("$number$");
        prmtDepartment.setCommitFormat("$number$;$name$");
    }

    public static void initPayeeAccount(IUIObject coreui, KDBizPromptBox prmtDepartment, CompanyOrgUnitInfo company, KDBizPromptBox prmtSaveingOrg) throws Exception {
        BankInfo bankInfo;
        EntityViewInfo entryViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (company != null) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)company.getId().toString()));
        }
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Boolean.FALSE));
        entryViewInfo.setFilter(filter);
        AccountBankCollection acctBankColl = AccountBankFactory.getRemoteInstance().getAccountBankCollection(entryViewInfo);
        HashSet<String> companyIDs = new HashSet<String>();
        if (company != null) {
            companyIDs.add(company.getId().toString());
        }
        if ((bankInfo = (BankInfo)prmtSaveingOrg.getValue()) == null) {
            int size = acctBankColl.size();
            for (int i = 0; i < size; ++i) {
                BankInfo cleHouseInfo;
                InnerAccountInfo innerAcctInfo;
                if (acctBankColl.get(i) == null || acctBankColl.get(i).getInnerAcct() == null) continue;
                String innerAcctID = acctBankColl.get(i).getInnerAcct().getId().toString();
                if (!InnerAccountFactory.getRemoteInstance().exists((IObjectPK)new ObjectUuidPK(innerAcctID)) || (innerAcctInfo = InnerAccountFactory.getRemoteInstance().getInnerAccountInfo((IObjectPK)new ObjectUuidPK(innerAcctID))).getClearingHouse() == null) continue;
                String cleHouseID = innerAcctInfo.getClearingHouse().getId().toString();
                if (!BankFactory.getRemoteInstance().exists((IObjectPK)new ObjectUuidPK(cleHouseID)) || (cleHouseInfo = BankFactory.getRemoteInstance().getBankInfo((IObjectPK)new ObjectUuidPK(cleHouseID))).getRelatedCompany() == null) continue;
                companyIDs.add(cleHouseInfo.getRelatedCompany().getId().toString());
            }
        } else if (bankInfo.getRelatedCompany() != null) {
            companyIDs.add(bankInfo.getRelatedCompany().getId().toString());
        }
        entryViewInfo = new EntityViewInfo();
        filter = new FilterInfo();
        if (bankInfo != null) {
            if (bankInfo.isInGroup()) {
                filter.getFilterItems().add(new FilterItemInfo("company.id", companyIDs, CompareType.INCLUDE));
                filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Boolean.FALSE));
                filter.setMaskString("(#0 and #1)");
            } else {
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)company.getId().toString(), CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Boolean.FALSE));
                filter.getFilterItems().add(new FilterItemInfo("property.property", (Object)new Integer(AccountBankPropertyEnum.Fixed.getValue()), CompareType.EQUALS));
                filter.setMaskString("(#0 and #1 and #2)");
            }
        } else if (companyIDs != null && companyIDs.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", companyIDs, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Boolean.FALSE));
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)company.getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Boolean.FALSE));
            HashSet<Integer> set = new HashSet<Integer>();
            set.add(new Integer(AccountBankPropertyEnum.Fixed.getValue()));
            filter.getFilterItems().add(new FilterItemInfo("property.property", (Object)new Integer(AccountBankPropertyEnum.Fixed.getValue()), CompareType.EQUALS));
            filter.setMaskString("((#0 and #1) or (#2 and #3 and #4))");
        } else {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)company.getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Boolean.FALSE));
            filter.getFilterItems().add(new FilterItemInfo("property.property", (Object)new Integer(AccountBankPropertyEnum.Fixed.getValue()), CompareType.EQUALS));
            filter.setMaskString("(#0 and #1 and #2)");
        }
        entryViewInfo.setFilter(filter);
        prmtDepartment.setEntityViewInfo(entryViewInfo);
        prmtDepartment.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7AccountBankQuery");
        prmtDepartment.setDisplayFormat("$name$ $bankAccountNumber$");
        prmtDepartment.setEditFormat("$number$");
        prmtDepartment.setCommitFormat("$number$;$name$");
        prmtDepartment.getQueryAgent().resetRuntimeEntityView();
    }

    public static void initInnerAccount(IUIObject coreui, KDBizPromptBox prmtDepartment, CompanyOrgUnitInfo company, KDBizPromptBox prmtSaveingOrg, boolean isCurrent) throws BOSException {
        EntityViewInfo proEntryViewInfo = new EntityViewInfo();
        FilterInfo proFilter = new FilterInfo();
        if (isCurrent) {
            proFilter.getFilterItems().add(new FilterItemInfo("property", (Object)new Integer(1)));
        } else {
            proFilter.getFilterItems().add(new FilterItemInfo("property", (Object)new Integer(2)));
        }
        proEntryViewInfo.setFilter(proFilter);
        AccountPropertyCollection proColl = AccountPropertyFactory.getRemoteInstance().getAccountPropertyCollection(proEntryViewInfo);
        AccountPropertyInfo acctProInfo = new AccountPropertyInfo();
        HashSet<String> proIDs = new HashSet<String>();
        int size = proColl.size();
        for (int i = 0; i < size; ++i) {
            acctProInfo = proColl.get(i);
            if (acctProInfo == null) continue;
            proIDs.add(acctProInfo.getId().toString());
        }
        BankInfo bankInfo = (BankInfo)prmtSaveingOrg.getValue();
        FilterInfo filter = new FilterInfo();
        EntityViewInfo entryViewInfo = new EntityViewInfo();
        if (company != null) {
            filter.getFilterItems().add(new FilterItemInfo("applyUnit.id", (Object)company.getId().toString()));
        }
        if (proIDs.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("type.id", proIDs, CompareType.INCLUDE));
        }
        if (bankInfo != null) {
            filter.getFilterItems().add(new FilterItemInfo("clearingHouse.id", (Object)bankInfo.getId().toString()));
        }
        filter.getFilterItems().add(new FilterItemInfo("closed", (Object)Boolean.FALSE, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isUsed", (Object)Boolean.TRUE, CompareType.EQUALS));
        entryViewInfo.setFilter(filter);
        prmtDepartment.setEntityViewInfo(entryViewInfo);
        prmtDepartment.setQueryInfo("com.kingdee.eas.fm.fs.F7InnerAccountQuery");
        prmtDepartment.setDisplayFormat("$name$ $bankAccountNumber$");
        prmtDepartment.setEditFormat("$number$");
        prmtDepartment.setCommitFormat("$number$;$name$");
        prmtDepartment.getQueryAgent().resetRuntimeEntityView();
    }

    public static void initFeeType(IUIObject coreui, KDBizPromptBox prmtDepartment) {
        EntityViewInfo entryViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        entryViewInfo.setFilter(filter);
        prmtDepartment.setEntityViewInfo(entryViewInfo);
        prmtDepartment.setQueryInfo("com.kingdee.eas.fi.cas.F7FeeTypeQuery");
        prmtDepartment.setDisplayFormat("$number$ $name$");
        prmtDepartment.setEditFormat("$number$");
        prmtDepartment.setCommitFormat("$number$;$name$");
    }

    public static KDPromptSelector getAccountF7(IUIObject ui, String companyId) {
        CompanyOrgUnitInfo companyInfo = new CompanyOrgUnitInfo();
        companyInfo.setId(BOSUuid.read((String)companyId));
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("isGFreeze", (Object)new Integer(0)));
        fic.add(new FilterItemInfo("isCFreeze", (Object)new Integer(0)));
        return new AccountPromptBox(ui, companyInfo, filter, false, true);
    }

    public static void initBank(IUIObject filterUI, KDBizPromptBox bank) {
        bank.setDisplayFormat("$number$ $name$");
        bank.setCommitFormat("$number$;$name$");
        bank.setEditable(true);
        bank.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7BankQuery");
    }

    public static void initBankTree(IUIObject filterUI, KDBizPromptBox bank) throws Exception {
        F7SelectorFactory.initBankTree(filterUI, bank, false);
    }

    public static void initBankTree(IUIObject filterUI, KDBizPromptBox bank, boolean isOnlyIncludeUsed) throws Exception {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)Boolean.TRUE));
        if (isOnlyIncludeUsed) {
            filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)new Integer(1)));
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        bank.setEntityViewInfo(evi);
        bank.setDisplayFormat("$number$ $name$");
        bank.setCommitFormat("$number$;$name$");
        bank.setEditFormat("$number$");
        bank.setEditable(true);
        bank.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7BankQuery");
        BankF7Selector arg0 = new BankF7Selector(filterUI, bank);
        bank.setSelector((KDPromptSelector)arg0);
    }

    public static void initNewCompanyF7(IUIObject ui, KDBizPromptBox box, boolean isMultiSelect) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("isBizUnit", (Object)Boolean.TRUE);
        view.setFilter(filter);
        box.setEntityViewInfo(view);
        box.setQueryInfo("com.kingdee.eas.basedata.org.app.CompanyOrgUnitQuery");
        box.setDisplayFormat("$name$");
        box.setEditFormat("$number$");
        box.setCommitFormat("$number$");
        NewCompanyF7 f7 = new NewCompanyF7(ui);
        f7.setNeedAddOrgRange(false);
        f7.setMultiSelect(isMultiSelect);
        box.setSelector((KDPromptSelector)f7);
    }

    public static void initProject(IUIObject ui, KDBizPromptBox bizPromptBox) {
        try {
            FilterInfo fInfo = new FilterInfo();
            fInfo.getFilterItems().add(new FilterItemInfo("status", (Object)ProjectStatus.CLOSE.getValue(), CompareType.NOTEQUALS));
            GeneralKDPromptSelectorAdaptor adaptor = new GeneralKDPromptSelectorAdaptor((KDPromptBox)bizPromptBox, (Component)new F7ProjectUI(), (Object)ui, "com.kingdee.eas.basedata.assistant.app.F7ProjectQuery");
            bizPromptBox.setSelector((KDPromptSelector)adaptor);
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(fInfo);
            bizPromptBox.setCommitFormat("$number$;$name$");
            bizPromptBox.setDisplayFormat("$number$ $name$");
            bizPromptBox.setEditFormat("$number$");
            bizPromptBox.setEntityViewInfo(evi);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public static void initProject(IUIObject ui, KDBizPromptBox bizPromptBox, boolean filtCompany, String filtCompanyID) {
        try {
            FilterInfo fInfo = new FilterInfo();
            if (filtCompany) {
                fInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)filtCompanyID, CompareType.EQUALS));
            }
            GeneralKDPromptSelectorAdaptor adaptor = new GeneralKDPromptSelectorAdaptor((KDPromptBox)bizPromptBox, (Component)new F7ProjectUI(), (Object)ui, "com.kingdee.eas.basedata.assistant.app.F7ProjectQuery");
            bizPromptBox.setSelector((KDPromptSelector)adaptor);
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(fInfo);
            bizPromptBox.setCommitFormat("$number$;$name$");
            bizPromptBox.setDisplayFormat("$number$ $name$");
            bizPromptBox.setEditFormat("$number$");
            bizPromptBox.setEntityViewInfo(evi);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }
}

