/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDMultiLangBox;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDSplitPane;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fi.gl.GLUtil;
import com.kingdee.eas.base.core.fm.ClientVerifyHelper;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.BOTPUtil;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.NumberValueVerifyRule;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.Container;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;

public final class FMClientVerifyHelper {
    public static final String path = "com.kingdee.eas.fm.common.FMResource";
    private static final BigDecimal MAX_VALUE = new BigDecimal("9999999999999.99");

    public static void verifyInput(CoreUIObject ui, String resourcePath, KDTable kdtEntries, IRow row, int i, String msg) {
        if (EmptyUtil.isEmpty((Object)row.getCell(i).getValue())) {
            kdtEntries.getEditManager().editCellAt(row.getRowIndex(), i);
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)msg));
            SysUtil.abort();
        }
    }

    public static void verifyInput(CoreUIObject ui, KDTable kdtEntries, String key) {
        IRow row = null;
        for (int j = 0; j < kdtEntries.getRowCount(); ++j) {
            row = kdtEntries.getRow(j);
            FMClientVerifyHelper.verifyInput(ui, kdtEntries, row, key);
        }
    }

    public static void verifyInput(CoreUIObject ui, KDTable kdtEntries, String key, boolean ifEntries) {
        IRow row = null;
        for (int j = 0; j < kdtEntries.getRowCount(); ++j) {
            row = kdtEntries.getRow(j);
            if (ifEntries) {
                FMClientVerifyHelper.verifyInput(ui, kdtEntries, row, key, true);
                continue;
            }
            FMClientVerifyHelper.verifyInput(ui, kdtEntries, row, key);
        }
    }

    public static void verifyInput(CoreUIObject ui, KDTable kdtEntries, IRow row, String key) {
        int colIndex = kdtEntries.getColumnIndex(key);
        if (EmptyUtil.isEmpty((Object)row.getCell(key).getValue())) {
            kdtEntries.getEditManager().editCellAt(row.getRowIndex(), colIndex);
            String headValue = (String)kdtEntries.getHeadRow(0).getCell(key).getValue();
            String msgStr = MessageFormat.format(EASResource.getString((String)path, (String)"canNotBeNullValue"), headValue);
            msgStr = msgStr.replaceAll("#", " " + headValue + " ");
            MsgBox.showWarning((Component)ui, (String)msgStr);
            SysUtil.abort();
        }
    }

    public static void verifyInput(CoreUIObject ui, KDTable kdtEntries, IRow row, String key, boolean ifEntries) {
        int colIndex = kdtEntries.getColumnIndex(key);
        if (EmptyUtil.isEmpty((Object)row.getCell(key).getValue())) {
            kdtEntries.getEditManager().editCellAt(row.getRowIndex(), colIndex);
            String headValue = (String)kdtEntries.getHeadRow(0).getCell(key).getValue();
            String entries = EASResource.getString((String)path, (String)"entries");
            String msgStr = MessageFormat.format(EASResource.getString((String)path, (String)"canNotBeNullValue"), entries + headValue);
            msgStr = msgStr.replaceAll("#", " " + headValue + " ");
            MsgBox.showWarning((Component)ui, (String)msgStr);
            SysUtil.abort();
        }
    }

    public static void verifyInputIsZero(CoreUIObject ui, KDTable kdtEntries, IRow row, String key) {
        int colIndex = kdtEntries.getColumnIndex(key);
        Object obj = row.getCell(key).getValue();
        if (!EmptyUtil.isEmpty((Object)obj) && obj instanceof BigDecimal && BOTPUtil.isZERO((BigDecimal)((BigDecimal)obj))) {
            kdtEntries.getEditManager().editCellAt(row.getRowIndex(), colIndex);
            String headValue = (String)kdtEntries.getHeadRow(0).getCell(key).getValue();
            String msgStr = MessageFormat.format(EASResource.getString((String)path, (String)"canNotBeZeroValue"), headValue);
            msgStr = msgStr.replaceAll("#", " " + headValue + " ");
            MsgBox.showWarning((Component)ui, (String)msgStr);
            SysUtil.abort();
        }
    }

    public static void verifyInputIsMaxValue(CoreUIObject ui, KDTable kdtEntries, IRow row, String key) {
        int colIndex = kdtEntries.getColumnIndex(key);
        Object obj = row.getCell(key).getValue();
        if (!EmptyUtil.isEmpty((Object)obj) && obj instanceof BigDecimal && ((BigDecimal)obj).compareTo(MAX_VALUE) == 1) {
            kdtEntries.getEditManager().editCellAt(row.getRowIndex(), colIndex);
            String headValue = (String)kdtEntries.getHeadRow(0).getCell(key).getValue();
            String msgStr = MessageFormat.format(EASResource.getString((String)path, (String)"canNotBeZeroValue"), headValue);
            msgStr = msgStr.replaceAll("#", " " + headValue + " ");
            MsgBox.showWarning((Component)ui, (String)msgStr);
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, KDTable kdtEntries) {
        ClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (KDTable)kdtEntries);
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, KDTextField txtNumber, String msg) {
        ClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (String)resourcePath, (KDTextField)txtNumber, (String)msg);
    }

    public static void verifyEmpty(CoreUIObject ui, KDTextField txtNumber) {
        ClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (KDTextField)txtNumber);
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, JFormattedTextField txtField, String msg) {
        ClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (String)resourcePath, (JFormattedTextField)txtField, (String)msg);
    }

    public static void verifyEmpty(CoreUIObject ui, JFormattedTextField txtNumber) {
        ClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (JFormattedTextField)txtNumber);
    }

    public static String getMessage(Component component) {
        String text = FMClientVerifyHelper.getCompLabelText(component);
        String msgStr = MessageFormat.format(EASResource.getString((String)path, (String)"canNotBeNullValue"), text);
        return msgStr;
    }

    public static String getCompLabelText(Component component) {
        Container cont2;
        Container cont;
        String text = "";
        if (component.getParent() instanceof KDLabelContainer) {
            text = ((KDLabelContainer)component.getParent()).getBoundLabelText();
        } else if (component instanceof KDTextArea && (cont = component.getParent()) != null && (cont2 = cont.getParent()) instanceof KDScrollPane && cont2.getParent() instanceof KDLabelContainer) {
            text = ((KDLabelContainer)cont2.getParent()).getBoundLabelText();
        }
        return text;
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, KDBizPromptBox bizBox, String msg) {
        ClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (String)resourcePath, (KDBizPromptBox)bizBox, (String)msg);
    }

    public static void verifyEmpty(CoreUIObject ui, KDBizPromptBox bizBox) {
        ClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (KDBizPromptBox)bizBox);
    }

    public static void verifyEmpty(CoreUIObject ui, KDComboBox comboBox) {
        ClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (KDComboBox)comboBox);
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, KDMultiLangBox multLangBox, String msg) {
        ClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (String)resourcePath, (KDMultiLangBox)multLangBox, (String)msg);
    }

    public static void verifyEmpty(CoreUIObject ui, KDMultiLangBox multLangBox) {
        ClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (KDMultiLangBox)multLangBox);
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, KDComboBox comboBox, String msg) {
        ClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (String)resourcePath, (KDComboBox)comboBox, (String)msg);
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, KDDatePicker datePicker, String msg) {
        ClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (String)resourcePath, (KDDatePicker)datePicker, (String)msg);
    }

    public static void verifyEmpty(CoreUIObject ui, KDDatePicker datePicker) {
        ClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (KDDatePicker)datePicker);
    }

    public static void verifyDateFromTo(CoreUIObject ui, String resourcePath, Date dateFrom, Date dateTo, String msg) {
        if ((dateFrom = DateTimeUtils.truncateDate((Date)dateFrom)).compareTo(dateTo = DateTimeUtils.truncateDate((Date)dateTo)) == 0) {
            dateTo = DateUtil.getNextDay((Date)dateTo);
        }
        if (dateFrom.compareTo(dateTo) > 0) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)msg));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, KDFormattedTextField txtNumber, String msg) {
        ClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (String)resourcePath, (KDFormattedTextField)txtNumber, (String)msg);
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, KDTextArea txtArea, String msg) {
        ClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (String)resourcePath, (KDTextArea)txtArea, (String)msg);
    }

    public static void verifyEmpty(CoreUIObject ui, KDTextArea txtArea, String name) {
        ClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (KDTextArea)txtArea, (String)name);
    }

    public static void verifyEmpty(CoreUIObject ui, KDTextArea txtArea) {
        ClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (KDTextArea)txtArea);
    }

    public static void verifyEmpty(CoreUIObject ui, KDFormattedTextField txtNumber) {
        ClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (KDFormattedTextField)txtNumber);
    }

    public static void checkStringLength(Component ui, String resourcePath, IRow row, String colName, int length) {
        String name = (String)row.getCell(colName).getValue();
        if (name != null && name.length() > length) {
            MsgBox.showWarning((Component)ui, (String)(EASResource.getString((String)resourcePath, (String)"StringLengthGreaterthan") + length + ":\n\n" + name));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, Object value, String msg) {
        ClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (String)resourcePath, (Object)value, (String)msg);
    }

    public static void verifyNotNegtive(CoreUIObject ui, String resourcePath, BigDecimal value, String msg) {
        if (EmptyUtil.isEmpty((Object)value) || value.signum() < 0) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)msg));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, Object value, String msg, String ctrlName) {
        ClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (String)resourcePath, (Object)value, (String)msg, (String)ctrlName);
    }

    public static void setComponentFocus(JComponent ui, String componentName) {
        Component[] comps = ui.getComponents();
        if (comps != null && comps.length > 0) {
            for (int i = 0; i < comps.length; ++i) {
                if (comps[i] instanceof KDPanel || comps[i] instanceof KDScrollPane || comps[i] instanceof KDSplitPane || comps[i] instanceof KDTabbedPane || comps[i] instanceof KDLabelContainer || comps[i] instanceof KDContainer || comps[i] instanceof KDPanel || comps[i] instanceof JPanel) {
                    FMClientVerifyHelper.setComponentFocus((JComponent)comps[i], componentName);
                    continue;
                }
                if (comps[i] == null || comps[i].getName() == null || !comps[i].getName().equals(componentName)) continue;
                comps[i].requestFocus();
            }
        }
    }

    public static void verifyEmptyAndNoZero(CoreUIObject ui, String resourcePath, Object value, String msg) {
        ClientVerifyHelper.verifyEmptyAndNoZero((CoreUIObject)ui, (String)resourcePath, (Object)value, (String)msg);
    }

    public static void verifyEmptyAndNoZero(CoreUIObject ui, KDFormattedTextField txt) {
        ClientVerifyHelper.verifyEmptyAndNoZero((CoreUIObject)ui, (KDFormattedTextField)txt);
    }

    public static void verifyBeginEndDateRel(CoreUIObject ui, Date beginDate, Date endDate) {
        ClientVerifyHelper.verifyBeginEndDateRel((CoreUIObject)ui, (Date)beginDate, (Date)endDate);
    }

    public static void verifyBeginEndDateRel(CoreUIObject ui, KDDatePicker pkBeginDate, KDDatePicker pkEndDate) {
        ClientVerifyHelper.verifyBeginEndDateRel((CoreUIObject)ui, (KDDatePicker)pkBeginDate, (KDDatePicker)pkEndDate);
    }

    public static void verifyAGreaterThanB(CoreUIObject ui, KDFormattedTextField txtA, KDFormattedTextField txtB) {
        ClientVerifyHelper.verifyAGreaterThanB((CoreUIObject)ui, (KDFormattedTextField)txtA, (KDFormattedTextField)txtB);
    }

    public static void verifyAGreaterThanEqualsB(CoreUIObject ui, KDFormattedTextField txtA, KDFormattedTextField txtB) {
        ClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (KDFormattedTextField)txtA);
        ClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (KDFormattedTextField)txtB);
        BigDecimal a = txtA.getBigDecimalValue();
        BigDecimal b = txtB.getBigDecimalValue();
        if (a.compareTo(b) == -1) {
            txtA.requestFocus(true);
            String aText = FMClientVerifyHelper.getCompLabelText((Component)txtA);
            String bText = FMClientVerifyHelper.getCompLabelText((Component)txtB);
            String msg = MessageFormat.format(EASResource.getString((String)path, (String)"greaterThanEquals"), aText, bText);
            MsgBox.showWarning((Component)ui, (String)msg);
            SysUtil.abort();
        }
    }

    public static void verifyALesserThanEqualsB(CoreUIObject ui, KDFormattedTextField txtA, KDFormattedTextField txtB) {
        ClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (KDFormattedTextField)txtA);
        ClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (KDFormattedTextField)txtB);
        BigDecimal a = txtA.getBigDecimalValue();
        BigDecimal b = txtB.getBigDecimalValue();
        if (b.compareTo(a) == -1) {
            txtA.requestFocus(true);
            String aText = FMClientVerifyHelper.getCompLabelText((Component)txtA);
            String bText = FMClientVerifyHelper.getCompLabelText((Component)txtB);
            FMClientVerifyHelper.showMsg(ui, "lesserThanEquals", new Object[]{aText, bText});
        }
    }

    public static void verifyAEqualsB(CoreUIObject ui, KDBizPromptBox box1, KDBizPromptBox box2) {
        Object value1 = box1.getValue();
        Object value2 = box2.getValue();
        boolean isEquals = false;
        if (!EmptyUtil.isEmpty((Object)value1) && !EmptyUtil.isEmpty((Object)value2)) {
            if (value1 instanceof CoreBaseInfo && value2 instanceof CoreBaseInfo) {
                CoreBaseInfo info1 = (CoreBaseInfo)value1;
                CoreBaseInfo info2 = (CoreBaseInfo)value2;
                if (info1.getId().equals((Object)info2.getId())) {
                    isEquals = true;
                }
            }
            if (value1 instanceof String && value2 instanceof String && value1.equals(value2)) {
                isEquals = true;
            }
        }
        if (isEquals) {
            String txt1 = FMClientVerifyHelper.getCompLabelText((Component)box1);
            String txt2 = FMClientVerifyHelper.getCompLabelText((Component)box2);
            String msg = MessageFormat.format(EASResource.getString((String)path, (String)"cannotsame"), txt1, txt2);
            if (box1.isEnabled()) {
                box1.requestFocus();
            } else {
                box2.requestFocus();
            }
            MsgBox.showWarning((Component)ui, (String)msg);
            SysUtil.abort();
        }
    }

    private static void showMsg(CoreUIObject ui, String resName, Object[] text) {
        String msg = MessageFormat.format(EASResource.getString((String)path, (String)resName), text);
        MsgBox.showWarning((Component)ui, (String)msg);
        SysUtil.abort();
    }

    public static void verifyGreaterThan(CoreUIObject ui, KDFormattedTextField txt, BigDecimal num) {
        ClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (KDFormattedTextField)txt);
        BigDecimal value = txt.getBigDecimalValue();
        if (value.compareTo(num) < 1) {
            txt.requestFocus(true);
            String Text2 = FMClientVerifyHelper.getCompLabelText((Component)txt);
            String msg = MessageFormat.format(EASResource.getString((String)path, (String)"greaterThan"), Text2, num.toString());
            MsgBox.showWarning((Component)ui, (String)msg);
            SysUtil.abort();
        }
    }

    public static void verifyGreaterThanEqual(CoreUIObject ui, KDFormattedTextField txt, BigDecimal num) {
        ClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (KDFormattedTextField)txt);
        BigDecimal value = txt.getBigDecimalValue();
        if (value.compareTo(num) == -1) {
            txt.requestFocus(true);
            String Text2 = FMClientVerifyHelper.getCompLabelText((Component)txt);
            String msg = MessageFormat.format(EASResource.getString((String)path, (String)"greaterThanEquals"), Text2, num.toString());
            MsgBox.showWarning((Component)ui, (String)msg);
            SysUtil.abort();
        }
    }

    public static void verifyLessThanEqual(CoreUIObject ui, KDFormattedTextField txt, BigDecimal num) {
        ClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (KDFormattedTextField)txt);
        BigDecimal value = txt.getBigDecimalValue();
        if (value.compareTo(num) == 1) {
            txt.requestFocus(true);
            String Text2 = FMClientVerifyHelper.getCompLabelText((Component)txt);
            String msg = MessageFormat.format(EASResource.getString((String)path, (String)"lessThanEquals"), Text2, num.toString());
            MsgBox.showWarning((Component)ui, (String)msg);
            SysUtil.abort();
        }
    }

    public static void verifyFilterCompanyIdSet(FMFilterBaseUI filterui) {
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (!GLUtil.isCompanyUnion((CompanyOrgUnitInfo)currentCompany) && filterui.getCompanyIdSet().size() <= 0) {
            MsgBox.showWarning((Component)((Object)filterui), (String)EASResource.getString((String)path, (String)"noCompany"));
            SysUtil.abort();
        }
    }

    public static void verifyRequire(CoreUIObject ui) {
        ClientVerifyHelper.verifyRequire((CoreUIObject)ui);
    }

    public static void verifyRequire(CoreUIObject ui, KDPanel panel) {
        ClientVerifyHelper.verifyRequire((CoreUIObject)ui, (KDPanel)panel);
    }

    public static void verifyTableMaxMinValue(CoreUIObject ui, KDTable table, NumberValueVerifyRule rule) {
        int rowCount = table.getRowCount();
        int colCount = table.getColumnCount();
        IRow headRow = table.getHeadRow(0);
        String resPath = "com.kingdee.eas.fm.common.client.FMCommonClientResource";
        String resNameMax = "exceedMaxValue";
        String resNameMin = "lessMinValue";
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < colCount; ++j) {
                String message;
                Object obj;
                if (table.getColumn(j).getStyleAttributes().isHided() || (obj = table.getCell(i, j).getValue()) == null || !(obj instanceof BigDecimal)) continue;
                BigDecimal numValue = (BigDecimal)obj;
                String colCapital = (String)headRow.getCell(j).getValue();
                if (numValue.compareTo(rule.getMaxValue()) > 0) {
                    message = FMClientHelper.formatMessage("com.kingdee.eas.fm.common.client.FMCommonClientResource", "exceedMaxValue", new Object[]{String.valueOf(i + 1), colCapital, rule.getMaxValue()});
                    MsgBox.showWarning((Component)ui, (String)message);
                    SysUtil.abort();
                }
                if (numValue.compareTo(rule.getMinValue()) >= 0) continue;
                message = FMClientHelper.formatMessage("com.kingdee.eas.fm.common.client.FMCommonClientResource", "lessMinValue", new Object[]{String.valueOf(i + 1), colCapital, rule.getMinValue()});
                MsgBox.showWarning((Component)ui, (String)message);
                SysUtil.abort();
            }
        }
    }

    public static Set getAllComponents(Container container) {
        Component[] components = container.getComponents();
        HashSet<Component> compSet = new HashSet<Component>();
        for (Component comp : components) {
            compSet.add(comp);
            if (!(comp instanceof KDPanel) && !(comp instanceof KDScrollPane) && !(comp instanceof KDSplitPane) && !(comp instanceof KDTabbedPane) && !(comp instanceof KDLabelContainer) && !(comp instanceof KDContainer) && !(comp instanceof JPanel)) continue;
            compSet.addAll(FMClientVerifyHelper.getAllComponents((Container)comp));
        }
        return compSet;
    }

    public static void verifyUIControlEmpty(CoreUI ui) {
        ClientVerifyHelper.verifyUIControlEmpty((CoreUI)ui);
    }

    public static boolean verifyEmptyXOR(Object a, Object b) {
        return !FMClientVerifyHelper.verifyEmptyOR(a, b);
    }

    public static boolean verifyEmptyXOR(Object a, Object b, Object c) {
        return !FMClientVerifyHelper.verifyEmptyOR(a, b, c);
    }

    public static boolean verifyEmptyOR(Object a, Object b) {
        return a == null && b == null || a != null && b != null;
    }

    public static boolean verifyEmptyOR(Object a, Object b, Object c) {
        return a == null && b == null && c == null || a != null && b != null && c != null;
    }

    public static void verifyRelateAccountBankAsCurrency(CoreUIObject ui, AccountBankInfo acctInfo, CurrencyInfo currency) throws EASBizException, BOSException {
        CurrencyInfo acctCurrency;
        String msgStr;
        if (acctInfo == null) {
            msgStr = MessageFormat.format(EASResource.getString((String)path, (String)"bankAccountCanNotBeNullValue"), EASResource.getString((String)path, (String)"bankAccount"));
            MsgBox.showWarning((Component)ui, (String)msgStr);
            SysUtil.abort();
        }
        if (currency == null) {
            msgStr = MessageFormat.format(EASResource.getString((String)path, (String)"currencyCanNotBeNullValue"), EASResource.getString((String)path, (String)"currency"));
            MsgBox.showWarning((Component)ui, (String)msgStr);
            SysUtil.abort();
        }
        if ((acctCurrency = acctInfo.getCurrency()) == null || acctCurrency.getId() == null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("currency.id"));
            sic.add(new SelectorItemInfo("currency.name"));
            sic.add(new SelectorItemInfo("currency.number"));
            acctInfo = AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(acctInfo.getId()), sic);
            acctCurrency = acctInfo.getCurrency();
        }
        if (acctCurrency == null) {
            return;
        }
        if (!acctCurrency.getId().toString().equals(currency.getId().toString())) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)path, (String)"acctCurrencyNotBillCurrency"));
            SysUtil.abort();
        }
    }

    public static void verifyInputMax(CoreUIObject ui, KDFormattedTextField txtFiled) {
        BigDecimal val = txtFiled.getBigDecimalValue();
        if (val != null || MAX_VALUE.compareTo(val) < 0) {
            txtFiled.requestFocus(true);
            String msg = MessageFormat.format(EASResource.getString((String)path, (String)"lesserThanEquals"), txtFiled.getLabelContainer().getBoundLabelText(), MAX_VALUE);
            MsgBox.showWarning((Component)ui, (String)msg);
            SysUtil.abort();
        }
    }

    public static void verifyComboCurrency(CoreUIObject ui, KDComboBox comboCurrency) {
        if (comboCurrency == null || comboCurrency.getSelectedItem() == null || !(comboCurrency.getSelectedItem() instanceof CurrencyInfo)) {
            return;
        }
        CurrencyInfo currency = (CurrencyInfo)comboCurrency.getSelectedItem();
        if (DeletedStatusEnum.DELETED.equals((Object)currency.getDeletedStatus())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"17_FMClientHelper"));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, KDBizPromptBox bizBox, boolean isInputF7) {
        ClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (KDBizPromptBox)bizBox, (boolean)isInputF7);
    }
}

