/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.client.FMRptBaseUI;
import com.kingdee.eas.fm.common.client.IFMDetailRptHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;

public abstract class FMDetailRptBaseHandler
implements IFMDetailRptHandler {
    protected FilterInfo filterInfo;
    protected SorterItemCollection sorter;
    protected KDTable kdt = null;
    protected FMRptBaseUI fmRptUI;

    public FMDetailRptBaseHandler(FilterInfo filterInfo, SorterItemCollection sorter, KDTable kdt) {
        this.filterInfo = filterInfo;
        this.sorter = sorter;
        this.kdt = kdt;
    }

    public FMDetailRptBaseHandler(FilterInfo filterInfo, KDTable kdt) {
        this(filterInfo, new SorterItemCollection(), kdt);
    }

    public FMDetailRptBaseHandler(FilterInfo filterInfo, FMRptBaseUI fmRptUI) {
        this(filterInfo, new SorterItemCollection(), fmRptUI.getMainTable());
        this.fmRptUI = fmRptUI;
    }

    @Override
    public void initHeader() {
        this.kdt.removeRows();
        this.kdt.removeHeadRows();
        this.kdt.removeColumns();
        this.kdt.getGroupManager().removeGroup();
        this.kdt.setEditable(false);
        this.kdt.getGroupManager().setGroup(true);
        this.kdt.getGroupManager().setOrientation(1);
    }

    protected abstract String getQueryPath();

    @Override
    public void filldata(IRowSet rs) throws SQLException, EASBizException, BOSException {
        this.kdt.setRefresh(false);
    }

    @Override
    public void endDataFill() {
        this.kdt.setRefresh(true);
        this.kdt.repaint();
        this.kdt.getGroupManager().group();
        this.kdt.getGroupManager().setGroup(false);
    }

    @Override
    public IRowSet getRowSet() throws BOSException {
        IMetaDataPK pk = MetaDataPKFactory.getMetaDataPK((String)this.getQueryPath());
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)pk);
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(this.filterInfo);
        ev.getSorter().clear();
        ev.getSorter().addObjectCollection((IObjectCollection)this.sorter);
        exec.setObjectView(ev);
        return exec.executeQuery();
    }

    public void execute() throws BOSException {
        this.initHeader();
        this.setTableStateRow();
        IRowSet rs = this.getRowSet();
        try {
            if (rs != null) {
                this.filldata(rs);
            }
        }
        catch (EASBizException e) {
            this.fmRptUI.handUIExceptionAndAbort((Exception)((Object)e));
        }
        catch (BOSException e) {
            this.fmRptUI.handUIExceptionAndAbort((Exception)((Object)e));
        }
        catch (SQLException e) {
            this.fmRptUI.handUIExceptionAndAbort(e);
        }
        this.endDataFill();
    }
}

