/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.util.enums.EnumUtils;
import java.util.List;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class FMKDTableHelper {
    private static final Logger logger = CoreUIObject.getLogger(FMKDTableHelper.class);
    public static final int H_MERGG = 0;
    public static final int V_MERGG = 1;

    public static KDTable mergeTable(KDTable table, KDTable table1, KDTable table2, int mergeType) {
        if (table == null) {
            return null;
        }
        if (mergeType == 0) {
            table = FMKDTableHelper.HMergeTable(table, table1, table2);
        } else if (mergeType == 1) {
            table = FMKDTableHelper.VMergeTable(table, table1, table2);
        }
        return table;
    }

    public static KDTable HMergeTable(KDTable table, KDTable table1, KDTable table2) {
        if (table == null) {
            return null;
        }
        FMClientHelper.clearTable(table);
        for (int i = 0; i < table1.getColumnCount(); ++i) {
            table.addColumn(i, (IColumn)table1.getColumn(i).clone());
        }
        for (int j = table1.getColumnCount(); j < table2.getColumnCount() + table1.getColumnCount(); ++j) {
            table.addColumn(j, (IColumn)table2.getColumn(j - table1.getColumnCount()).clone());
        }
        int headRowCount = table1.getHeadRowCount();
        if (table2.getHeadRowCount() > headRowCount) {
            headRowCount = table2.getHeadRowCount();
        }
        for (int i = 0; i < headRowCount; ++i) {
            int j;
            IRow headRow = table.addHeadRow();
            IRow headRow1 = table1.getHeadRow(i);
            IRow headRow2 = table2.getHeadRow(i);
            if (headRow1 != null) {
                for (j = 0; j < table1.getColumnCount(); ++j) {
                    headRow.getCell(j).setValue(headRow1.getCell(j).getValue());
                }
            }
            if (headRow2 == null) continue;
            for (j = table1.getColumnCount(); j < table1.getColumnCount() + table2.getColumnCount(); ++j) {
                headRow.getCell(j).setValue(headRow2.getCell(j - table1.getColumnCount()).getValue());
            }
        }
        List mergeBlockList1 = table1.getHeadMergeManager().getMergeBlockList();
        for (int i = 0; i < mergeBlockList1.size(); ++i) {
            KDTMergeBlock block = (KDTMergeBlock)((KDTMergeBlock)mergeBlockList1.get(i)).clone();
            table.getHeadMergeManager().getMergeBlockList().add(block);
        }
        List mergeBlockList2 = table2.getHeadMergeManager().getMergeBlockList();
        for (int i = 0; i < mergeBlockList2.size(); ++i) {
            KDTMergeBlock block = (KDTMergeBlock)((KDTMergeBlock)mergeBlockList2.get(i)).clone();
            block.setLeft(block.getLeft() + table1.getColumnCount());
            block.setRight(block.getRight() + table1.getColumnCount());
            table.getHeadMergeManager().getMergeBlockList().add(block);
        }
        int rowCount = table1.getRowCount();
        if (table2.getRowCount() > rowCount) {
            rowCount = table2.getRowCount();
        }
        for (int i = 0; i < rowCount; ++i) {
            int j;
            IRow row = table.addRow();
            IRow row1 = table1.getRow(i);
            IRow row2 = table2.getRow(i);
            if (row1 != null) {
                for (j = 0; j < table1.getColumnCount(); ++j) {
                    row.setCell(j, (ICell)row1.getCell(j).clone());
                }
            }
            if (row2 == null) continue;
            for (j = table1.getColumnCount(); j < table1.getColumnCount() + table2.getColumnCount(); ++j) {
                row.setCell(j, (ICell)row2.getCell(j - table1.getColumnCount()).clone());
            }
        }
        return table;
    }

    public static KDTable VMergeTable(KDTable table, KDTable table1, KDTable table2) {
        int i;
        int j;
        int i2;
        int i3;
        if (table == null) {
            return null;
        }
        FMClientHelper.clearTable(table);
        KDTable maxTable = table1;
        if (table2.getColumnCount() > table1.getColumnCount()) {
            maxTable = table2;
        }
        for (i3 = 0; i3 < maxTable.getColumnCount(); ++i3) {
            table.addColumn(i3, (IColumn)maxTable.getColumn(i3).clone());
        }
        for (i3 = 0; i3 < table1.getHeadRowCount(); ++i3) {
            IRow headRow1 = table1.getHeadRow(i3);
            if (headRow1 == null) continue;
            IRow headRow = table.addHeadRow();
            for (int j2 = 0; j2 < table1.getColumnCount(); ++j2) {
                headRow.setCell(j2, (ICell)headRow1.getCell(j2).clone());
            }
        }
        List mergeBlockList1 = table1.getHeadMergeManager().getMergeBlockList();
        for (i2 = 0; i2 < mergeBlockList1.size(); ++i2) {
            KDTMergeBlock block = (KDTMergeBlock)((KDTMergeBlock)mergeBlockList1.get(i2)).clone();
            table.getHeadMergeManager().getMergeBlockList().add(block);
        }
        for (i2 = 0; i2 < table1.getRowCount(); ++i2) {
            IRow row1 = table1.getRow(i2);
            if (row1 == null) continue;
            IRow row = table.addRow();
            for (j = 0; j < table1.getColumnCount(); ++j) {
                row.setCell(j, (ICell)row1.getCell(j).clone());
            }
        }
        for (i2 = 0; i2 < table2.getHeadRowCount(); ++i2) {
            IRow headRow2 = table2.getHeadRow(i2);
            if (headRow2 == null) continue;
            IRow headRow = table.addRow();
            for (j = 0; j < table2.getColumnCount(); ++j) {
                headRow.setCell(j, (ICell)headRow2.getCell(j).clone());
            }
        }
        List mergeBlockList2 = table2.getHeadMergeManager().getMergeBlockList();
        for (i = 0; i < mergeBlockList2.size(); ++i) {
            KDTMergeBlock block = (KDTMergeBlock)((KDTMergeBlock)mergeBlockList2.get(i)).clone();
            block.setTop(block.getTop() + table1.getRowCount() + table1.getHeadRowCount());
            block.setBottom(block.getBottom() + table1.getRowCount() + table1.getHeadRowCount());
            table.getHeadMergeManager().getMergeBlockList().add(block);
        }
        for (i = 0; i < table2.getRowCount(); ++i) {
            IRow row2 = table2.getRow(i);
            if (row2 == null) continue;
            IRow row = table.addRow();
            for (int j3 = 0; j3 < table2.getColumnCount(); ++j3) {
                row.setCell(j3, (ICell)row2.getCell(j3).clone());
            }
        }
        return table;
    }

    public static KDTable makeTable1() {
        KDTable table = new KDTable();
        table.addColumn();
        table.addColumn();
        IRow row = table.addRow();
        row.getCell(0).setValue((Object)"1");
        row.getCell(1).setValue((Object)"2");
        row = table.addRow();
        row.getCell(0).setValue((Object)"3");
        row.getCell(1).setValue((Object)"4");
        row = table.addRow();
        row.getCell(0).setValue((Object)"4");
        row.getCell(1).setValue((Object)"5");
        return table;
    }

    public static KDTable makeTable2() {
        KDTable table = new KDTable();
        table.addColumn();
        table.addColumn();
        IRow row = table.addRow();
        row.getCell(0).setValue((Object)"6");
        row.getCell(1).setValue((Object)"7");
        row = table.addRow();
        row.getCell(0).setValue((Object)"8");
        row.getCell(1).setValue((Object)"9");
        return table;
    }

    public static void showTable(KDTable table) {
        for (int i = 0; i < table.getRowCount(); ++i) {
            IRow row = table.getRow(i);
            for (int j = 0; j < table.getColumnCount(); ++j) {
                logger.info(row.getCell(j).getValue());
                logger.info((Object)"  ");
            }
            logger.info((Object)"\n");
        }
    }

    public static void main(String[] args) {
        KDTable table1 = FMKDTableHelper.makeTable1();
        KDTable table2 = FMKDTableHelper.makeTable2();
        KDTable table = FMKDTableHelper.mergeTable(null, table1, table2, 1);
        FMKDTableHelper.showTable(table);
    }

    public static void initDecimalCell(ICell cell, int pre) {
        cell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        cell.getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm(pre));
    }

    public static void initDecimalColumn(IColumn column, int pre) {
        column.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        column.getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm(pre));
    }

    public static void setTableCellEditorByF7(KDTable tblMain, String f7, FilterInfo fi, String property) throws Exception {
        KDBizPromptBox promptBox = new KDBizPromptBox();
        promptBox.setDisplayFormat("$name$");
        promptBox.setEditFormat("$number$");
        promptBox.setCommitFormat("$number$");
        promptBox.setQueryInfo(f7);
        if (fi != null) {
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(fi);
            promptBox.setEntityViewInfo(evi);
        }
        tblMain.getColumn(property).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)promptBox));
    }

    public static void setTableCellEditorByCombox(KDTable tblMain, Class enumClass, String property) throws Exception {
        KDComboBox kdc = new KDComboBox();
        kdc.addItems(EnumUtils.getEnumList((String)enumClass.getName()).toArray());
        tblMain.getColumn(property).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)kdc));
    }
}

