/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.expr.Variant;
import com.kingdee.bos.ctrl.kdf.printprovider.headerfooter.ExtVarProvider;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.common.client.CommonUtil;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CommonQueryProcessor;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.multiapprove.client.MultiApproveUtil;
import com.kingdee.eas.base.uiframe.client.UIModelDialogFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.fm.common.client.AbstractFMListBaseUI;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMDefaultQueryProcessor;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.common.client.IFMListBaseUI;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.IIDList;
import com.kingdee.eas.util.AbortException;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class FMListBaseUI
extends AbstractFMListBaseUI
implements IFMListBaseUI {
    private static final Logger logger = CoreUIObject.getLogger(FMListBaseUI.class);
    private CommonQueryDialog queryDlg;
    private FilterParam defaultQueryParam;
    private EntityViewInfo defaultEntityView;
    protected QuerySolutionInfo dsPrepare = null;
    private FilterParam param;
    private boolean shouldReloadPrintVar = true;

    public void showMessage(String msg) {
        this.setMessageText(msg);
        this.showMessage();
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        CommonQueryDialog dialog = this.getQueryDlg();
        if (!dialog.show()) {
            SysUtil.abort();
        }
        this.doQuery(dialog);
        FilterParam param = (FilterParam)this.getFilterUI().getParam();
        this.executeQuery(param);
    }

    @Override
    public void executeQuery(FilterParam param) throws BOSException {
        this.setFilterParam(param);
        if (this.queryDlg != null) {
            this.mainQuery = (EntityViewInfo)this.queryDlg.getEntityViewInfoResult().clone();
        } else if (this.defaultEntityView != null) {
            this.mainQuery = this.defaultEntityView;
            if (this.mainQuery.getFilter() == null) {
                this.mainQuery.setFilter(new FilterInfo());
            }
        } else {
            this.mainQuery = new EntityViewInfo();
            this.mainQuery.setFilter(new FilterInfo());
        }
        if (this.mainQuery.getFilter().getFilterItems().size() == 0) {
            this.mainQuery.setFilter(param.getFilter());
        } else {
            this.mainQuery.getFilter().mergeFilter(param.getFilter(), "AND");
        }
        this.mainQuery.getSorter().addObjectCollection((IObjectCollection)param.getSorterItems());
        this.execQuery();
    }

    protected boolean isAutoSetTitle() {
        return true;
    }

    protected String getTitle() throws Exception {
        return "";
    }

    public void onLoad() throws Exception {
        if (this.isAutoSetTitle()) {
            this.getMainStatusBar().setPerTitle(FMClientHelper.getSysStatusBarTitle((CoreUI)this));
        } else {
            this.getMainStatusBar().setPerTitle(this.getTitle());
        }
        this.setIsNeedDefaultFilter(false);
        this.initTableFormat();
        super.onLoad();
        this.tblMain.checkParsed();
        Object[] ids = null;
        Object idsObject = this.getUIContext().get("IDList");
        ids = idsObject instanceof IIDList ? FMClientHelper.IDListToArray((IIDList)idsObject) : (String[])idsObject;
        if (FMHelper.isEmpty(ids) && !this.isTraceDown()) {
            FilterParam obj = null;
            this.initDefaultQuery(this.mainQueryPK.getFullName());
            if (this.defaultQueryParam != null) {
                obj = this.defaultQueryParam;
            }
            if (obj == null) {
                CommonQueryDialog qDlg = this.getQueryDlg();
                if (!qDlg.show()) {
                    SysUtil.abort();
                }
                this.doQuery(qDlg);
                obj = (FilterParam)this.getFilterUI().getParam();
            }
            this.executeQuery(obj);
            this.applyPreference();
        }
        FMClientHelper.addSqlMenu((CoreUIObject)this, this.menuEdit);
        FMClientHelper.clearSeparatorOnToolBar(this.toolBar);
    }

    private boolean isTraceDown() {
        return this.getBOTPViewStatus() == 1;
    }

    private void initTableFormat() {
        this.getMainTable().addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                try {
                    FMListBaseUI.this.doAfterDataFill(e);
                }
                catch (EASBizException e1) {
                    FMListBaseUI.this.handUIException(e1);
                }
                catch (BOSException e1) {
                    FMListBaseUI.this.handUIException(e1);
                }
            }
        });
    }

    protected String getQueryUiName() {
        return this.getMetaDataPK().getFullName();
    }

    @Override
    public void initDefaultQuery(String queryName) throws Exception {
        if (this.defaultQueryParam != null) {
            return;
        }
        QuerySolutionInfo ds = null;
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        ds = this.dsPrepare != null ? this.dsPrepare : iQuery.getDefaultSolution(this.getQueryUiName(), queryName);
        if (ds != null) {
            if (!FMHelper.isEmpty(ds.getEntityViewInfo())) {
                this.defaultEntityView = new EntityViewInfo(ds.getEntityViewInfo());
            } else {
                this.defaultEntityView = new EntityViewInfo();
                this.defaultEntityView.setFilter(new FilterInfo());
            }
            this.doDefaultSolution(iQuery, queryName);
            QueryPanelCollection queryPanelInfo = ds.getQueryPanelInfo();
            if (queryPanelInfo.size() > 0) {
                for (int i = 0; i < queryPanelInfo.size(); ++i) {
                    Object tempObject;
                    String filterUICName = this.getFilterUI().getMetaDataPK().getFullName();
                    if (!filterUICName.equals(queryPanelInfo.get(i).getPanelClassName())) continue;
                    queryPanelInfo.get(i).getCustomerParams();
                    CustomerParams cp = CustomerParams.getCustomerParams2((String)queryPanelInfo.get(i).getCustomerParams());
                    if (cp == null) {
                        return;
                    }
                    String paramValue = cp.getCustomerParam("fmcustomer");
                    if (FMHelper.isEmpty(paramValue)) {
                        return;
                    }
                    byte[] bytes = FMHelper.decode(paramValue.getBytes());
                    byte[] param = bytes;
                    if (param == null || param.length <= 0 || !((tempObject = CommonUtil.getObject((byte[])param)) instanceof FilterParam)) continue;
                    this.defaultQueryParam = (FilterParam)tempObject;
                }
            }
            if (this.defaultQueryParam == null) {
                this.defaultQueryParam = this.getDefalutQueryParam();
            }
        }
    }

    @Override
    public FilterParam getDefalutQueryParam() {
        try {
            FMFilterBaseUI f = this.getFilterUI();
            f.onLoad();
            return (FilterParam)f.getParam();
        }
        catch (AbortException e) {
            throw e;
        }
        catch (Exception exp) {
            logger.error((Object)exp.getMessage(), (Throwable)exp);
            return null;
        }
    }

    protected void formatRow(IRow row) {
    }

    protected CommonQueryDialog getQueryDlg() throws Exception {
        if (this.queryDlg != null) {
            return this.queryDlg;
        }
        FMFilterBaseUI filterUI = this.getFilterUI();
        filterUI.setListUI((IUIObject)this);
        filterUI.setActionListOnLoad((ItemAction)this.actionOnLoad);
        this.queryDlg = this.initCommonQueryDialog();
        EntityViewInfo view = new EntityViewInfo();
        this.queryDlg.setEntityViewInfo(view);
        this.queryDlg.setOwner((Component)this.getUIContext().get("Owner"));
        this.queryDlg.setParentUIClassName(this.getMetaDataPK().getFullName());
        this.queryDlg.setQueryObjectPK(this.mainQueryPK);
        this.queryDlg.setHeight(300);
        this.queryDlg.setWidth(400);
        this.queryDlg.setTitle(filterUI.getUITitle());
        this.queryDlg.addUserPanel((KDPanel)filterUI);
        this.queryDlg.setProcessor((IProcessor)this.getQueryProcessor());
        return this.queryDlg;
    }

    protected CommonQueryProcessor getQueryProcessor() {
        return new FMDefaultQueryProcessor();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        ResourceBundleHelper rsHelper = new ResourceBundleHelper(AbstractFMListBaseUI.class.getName());
        this.menuItemQuery.setText(rsHelper.getString("menuItemQuery.text"));
        this.menuItemQuery.setMnemonic(81);
    }

    public IRow getSelectedRow() {
        this.checkSelected();
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock == null || selectBlock.getTop() == -1) {
            SysUtil.abort();
        }
        IRow row = this.tblMain.getRow(selectBlock.getTop());
        return row;
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        IRow row;
        Object companyId;
        KDTSelectBlock selectBlock;
        if (action != null && action.equals(this.actionAddNew)) {
            return super.getOrgPK(action);
        }
        int colIndex = this.tblMain.getColumnIndex("companyId");
        if (colIndex > -1 && (selectBlock = this.tblMain.getSelectManager().get()) != null && selectBlock.getTop() > -1 && (companyId = (row = this.tblMain.getRow(selectBlock.getTop())).getCell(colIndex).getValue()) != null && companyId.toString().trim().length() > 0) {
            ObjectUuidPK orgPk = new ObjectUuidPK(companyId.toString());
            if (action != null) {
                action.putValue("ORG.PK", (Object)orgPk);
            }
            return orgPk;
        }
        return super.getOrgPK(action);
    }

    @Override
    public void actionAuditResult_actionPerformed(ActionEvent e) throws Exception {
        super.actionAuditResult_actionPerformed(e);
        String id = this.getSelectedKeyValue();
        if (id == null || id.trim().length() < 1) {
            return;
        }
        MultiApproveUtil.showApproveHis((BOSUuid)BOSUuid.read((String)id), (String)UIModelDialogFactory.class.getName(), (Object)this);
    }

    @Override
    public abstract FMFilterBaseUI getFilterUI() throws Exception;

    public FilterParam getFilterParam() {
        return this.param;
    }

    public void setFilterParam(FilterParam param) {
        this.param = param;
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = super.getQueryExecutor(queryPK, viewInfo);
        exec.option().isAutoIgnoreZero = false;
        return exec;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    protected String getEditUIModal() {
        return FMClientHelper.getEditUIMode((CoreUIObject)this);
    }

    protected Map preparePrintVariantMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Company", SysContext.getSysContext().getCurrentFIUnit().getName());
        map.put("CurrencyUser", ContextHelperFactory.getRemoteInstance().getCurrentUser().getName());
        return map;
    }

    protected ExtVarProvider getPrintExtVarProvider() {
        class MyExtVarProvider
        implements ExtVarProvider {
            Map varMap = null;

            MyExtVarProvider() {
                this.initVarMap();
            }

            private void initVarMap() {
                this.varMap = FMListBaseUI.this.preparePrintVariantMap();
            }

            public Variant requestVarData(String varName) {
                if (FMListBaseUI.this.shouldReloadPrintVar) {
                    this.initVarMap();
                }
                if (this.varMap == null) {
                    return null;
                }
                Object obj = this.varMap.get(varName);
                if (!(obj instanceof Variant)) {
                    Variant v = new Variant();
                    v.setObject(obj);
                    return v;
                }
                return (Variant)obj;
            }
        }
        return new MyExtVarProvider();
    }

    protected void doAfterDataFill(KDTDataRequestEvent e) throws EASBizException, BOSException {
        int firstRowIndex = e.getFirstRow();
        int lastRowIndex = e.getLastRow();
        for (int i = firstRowIndex; i <= lastRowIndex; ++i) {
            IRow row = this.getMainTable().getRow(i);
            this.formatRow(row);
        }
    }

    protected SystemEnum getSystemEnumForOA() {
        return FMClientHelper.getSystemEnum((CoreUI)this);
    }
}

