/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IOtherParam;
import com.kingdee.eas.base.param.ISetOrgType;
import com.kingdee.eas.base.param.client.ICustomParamUI;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.CtrlNodeEnum;
import com.kingdee.eas.fm.common.FMBizBillCollection;
import com.kingdee.eas.fm.common.FMBizBillFactory;
import com.kingdee.eas.fm.common.FMBizBillInfo;
import com.kingdee.eas.fm.common.FMBizParamInfo;
import com.kingdee.eas.fm.common.client.AbstractFMParamUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.apache.log4j.Logger;

public class FMParamUI
extends AbstractFMParamUI
implements IOtherParam,
ICustomParamUI,
ISetOrgType {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(FMParamUI.class);
    private static final String COL_ID = "id";
    private static final String COL_NAME = "paramName";
    private static final String COL_VALUE = "paramValue";
    private static final String COL_NODE = "ctrlNode";
    private static final String COL_DESC = "description";
    private static final String COL_PARAMID = "paramId";
    private static final String UPBILLID = "EaGGv6r4UP7gUwEAAH8mpusVfIU=";
    private static final String DOWNBILLID = "EaGGv6r5UP7gUwEAAH8mpusVfIU=";
    private static final String RESPATH = "com.kingdee.eas.fm.common.client.FMCommonClientResource";
    private String CAS = "com.kingdee.eas.fi.cas";
    private CompanyOrgUnitInfo companyInfo = null;
    private FMBizBillCollection coll = null;
    private FMBizBillCollection cacheColl = new FMBizBillCollection();

    public void onLoad() throws Exception {
        this.initTable();
        this.initTree();
        super.onLoad();
    }

    protected void initTree() throws BOSException {
        MyTreeSelectModel selectModel = new MyTreeSelectModel();
        selectModel.setSelectionMode(1);
        this.treeBizSystem.setSelectionModel((TreeSelectionModel)selectModel);
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)EASResource.getString((String)RESPATH, (String)"fm"));
        FMBizBillCollection col = FMBizBillFactory.getRemoteInstance().getFMBizBillCollection("select subSystemName, subSystemAlias where boName is null and subSystemName<> '" + this.CAS + "' order by subSystemName");
        HashMap<String, DefaultKingdeeTreeNode> nodes = new HashMap<String, DefaultKingdeeTreeNode>();
        FMBizBillInfo info = null;
        DefaultKingdeeTreeNode child = null;
        String parent = null;
        for (int i = 0; i < col.size(); ++i) {
            info = col.get(i);
            if (nodes.containsKey(info.getSubSystemName())) continue;
            child = new DefaultKingdeeTreeNode((Object)info);
            nodes.put(info.getSubSystemName(), child);
            child.setText(col.get(i).getSubSystemAlias());
            parent = info.getSubSystemName().substring(0, info.getSubSystemName().lastIndexOf("."));
            if (nodes.containsKey(parent)) {
                ((DefaultKingdeeTreeNode)nodes.get(parent)).add((MutableTreeNode)child);
                continue;
            }
            root.add((MutableTreeNode)child);
        }
        this.treeBizSystem.setModel((TreeModel)new DefaultTreeModel((TreeNode)root));
        this.treeBizSystem.expandAllNodes(true, (TreeNode)root);
    }

    protected void initTable() {
        this.tblMain.checkParsed();
        KDCheckBox checkBox = new KDCheckBox();
        this.tblMain.getColumn(COL_VALUE).setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)checkBox));
        KDComboBox comboBox = new KDComboBox();
        comboBox.addItem((Object)CtrlNodeEnum.submit);
        comboBox.addItem((Object)CtrlNodeEnum.audit);
        comboBox.addItem((Object)CtrlNodeEnum.confirm);
        this.tblMain.getColumn(COL_NODE).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)comboBox));
        this.tblMain.getColumn(COL_NAME).getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(COL_NODE).getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(COL_DESC).getStyleAttributes().setLocked(true);
    }

    @Override
    protected void treeBizSystem_valueChanged(TreeSelectionEvent e) throws Exception {
        DefaultKingdeeTreeNode node;
        super.treeBizSystem_valueChanged(e);
        DefaultKingdeeTreeNode defaultKingdeeTreeNode = node = e.getNewLeadSelectionPath() == null ? null : (DefaultKingdeeTreeNode)e.getNewLeadSelectionPath().getLastPathComponent();
        if (e.getOldLeadSelectionPath() != null) {
            this.clone(this.coll, this.cacheColl);
            this.doBizBillColl();
            if (this.coll != null && !this.coll.isEmpty() && 0 == MsgBox.showConfirm2((String)EASResource.getString((String)RESPATH, (String)"isSave"))) {
                this.save();
            }
        }
        if (e.getOldLeadSelectionPath() == e.getNewLeadSelectionPath()) {
            return;
        }
        if (node != null && !(node.getUserObject() instanceof FMBizBillInfo)) {
            this.redrawTable(null);
        } else if (node != null && node.getUserObject() instanceof FMBizBillInfo) {
            FMBizBillInfo info = (FMBizBillInfo)node.getUserObject();
            this.redrawTable(info);
        }
    }

    private void redrawTable(FMBizBillInfo info) {
        this.initBizBillColl(info);
        this.clone(this.cacheColl, this.coll);
        this.tblMain.removeRows();
        int size = this.coll.size();
        for (int i = 0; i < size; ++i) {
            IRow row = this.tblMain.addRow();
            row.getCell(COL_ID).setValue((Object)this.coll.get(i).getId().toString());
            row.getCell(COL_NAME).setValue((Object)MessageFormat.format(EASResource.getString((String)RESPATH, (String)"bgCtrl"), this.coll.get(i).getBoAlias()));
            row.getCell(COL_VALUE).setValue((Object)this.convert(this.coll.get(i)).isIsCtrl());
            row.getCell(COL_NODE).setValue((Object)this.convert(this.coll.get(i)).getCtrlNode());
            row.getCell(COL_DESC).setValue((Object)MessageFormat.format(EASResource.getString((String)RESPATH, (String)"isBgCtrl"), this.coll.get(i).getBoAlias()));
            row.getCell(COL_PARAMID).setValue((Object)this.convert(this.coll.get(i)).getId().toString());
            this.setLock(row);
        }
    }

    protected void setLock(IRow row) {
        if (UPBILLID.equals(row.getCell(COL_ID).getValue().toString()) || DOWNBILLID.equals(row.getCell(COL_ID).getValue().toString())) {
            row.getCell(COL_NODE).getStyleAttributes().setLocked(false);
        }
    }

    private FMBizParamInfo convert(FMBizBillInfo info) {
        int size = info.getBizParam().size();
        for (int i = 0; i < size; ++i) {
            if (this.companyInfo == null || !info.getBizParam().get(i).getCompany().getId().equals((Object)this.companyInfo.getId())) continue;
            return info.getBizParam().get(i);
        }
        FMBizParamInfo paramInfo = new FMBizParamInfo();
        paramInfo.setId(BOSUuid.create((BOSObjectType)paramInfo.getBOSType()));
        paramInfo.setBizBill(info);
        paramInfo.setCompany(this.companyInfo);
        paramInfo.setIsCtrl(false);
        paramInfo.setCtrlNode(CtrlNodeEnum.submit);
        return paramInfo;
    }

    private void initBizBillColl(FMBizBillInfo info) {
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("boName", null, CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("subSystemName", (Object)this.CAS, CompareType.NOTEQUALS));
            if (info != null) {
                filter.appendFilterItem("subSystemName", (Object)info.getSubSystemName());
            }
            view.getSelector().add("*");
            view.getSelector().add("bizParam.*");
            view.setFilter(filter);
            this.coll = FMBizBillFactory.getRemoteInstance().getFMBizBillCollection(view);
            int size = this.coll.size();
            for (int i = 0; i < size; ++i) {
                this.buildParamBillInfo(this.coll.get(i));
            }
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
    }

    private void buildParamBillInfo(FMBizBillInfo info) {
        HashSet<String> ids = new HashSet<String>();
        for (int i = 0; i < info.getBizParam().size(); ++i) {
            ids.add(info.getBizParam().get(i).getCompany().getId().toString());
        }
        if (this.companyInfo != null && !ids.contains(this.companyInfo.getId().toString())) {
            FMBizParamInfo paramInfo = new FMBizParamInfo();
            paramInfo.setId(BOSUuid.create((BOSObjectType)paramInfo.getBOSType()));
            paramInfo.setBizBill(info);
            paramInfo.setCompany(this.companyInfo);
            paramInfo.setIsCtrl(false);
            paramInfo.setCtrlNode(CtrlNodeEnum.submit);
            info.getBizParam().add(paramInfo);
        }
    }

    public Vector getOrgTypeVect() throws BOSException, EASBizException {
        Vector<OrgType> vect = new Vector<OrgType>();
        vect.add(OrgType.Company);
        return vect;
    }

    public void setOrgInfo(OrgType orgType, OrgUnitInfo orgUnit, OrgTreeInfo orgTree) {
    }

    public void sendOrgInfo(OrgType orgType, OrgUnitInfo orgUnit, OrgTreeInfo orgTree) {
        if (orgUnit == null || !(orgUnit instanceof CompanyOrgUnitInfo)) {
            return;
        }
        this.companyInfo = (CompanyOrgUnitInfo)orgUnit;
        if (this.treeBizSystem.getSelectionRows() != null && this.treeBizSystem.getSelectionRows().length > 0) {
            if (this.treeBizSystem.getSelectionRows()[0] == 0) {
                this.redrawTable(null);
            }
        } else {
            this.treeBizSystem.setSelectionRow(0);
        }
    }

    public void otherParamSave() throws BOSException, EASBizException {
        this.clone(this.coll, this.cacheColl);
        this.doBizBillColl();
        this.save();
    }

    private void save() throws EASBizException, BOSException {
        FMBizBillFactory.getRemoteInstance().updateParam(this.coll);
    }

    private void doBizBillColl() {
        this.tblMain.getEditManager().stopEditing();
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            this.doBizBillColl(this.tblMain.getRow(i));
        }
    }

    private void doBizBillColl(IRow row) {
        for (int i = this.coll.size() - 1; i >= 0; --i) {
            if (!this.same(row.getCell(COL_ID).getValue(), this.coll.get(i).getId().toString())) continue;
            this.doBizBillColl(row, this.coll.get(i));
        }
    }

    private void doBizBillColl(IRow row, FMBizBillInfo info) {
        for (int i = 0; i < info.getBizParam().size(); ++i) {
            if (!this.same(row.getCell(COL_PARAMID).getValue(), info.getBizParam().get(i).getId().toString())) continue;
            if (this.same((Boolean)row.getCell(COL_VALUE).getValue(), info.getBizParam().get(i).isIsCtrl()) && this.same(row.getCell(COL_NODE).getValue(), (Object)info.getBizParam().get(i).getCtrlNode())) {
                this.coll.remove(info);
                continue;
            }
            info.getBizParam().get(i).setIsCtrl((Boolean)row.getCell(COL_VALUE).getValue());
            info.getBizParam().get(i).setCtrlNode((CtrlNodeEnum)((Object)row.getCell(COL_NODE).getValue()));
        }
    }

    private boolean same(Object obj1, Object obj2) {
        if (obj1 == null && obj2 == null) {
            return true;
        }
        if (obj1 instanceof String && obj2 instanceof String) {
            return ((String)obj1).equals((String)obj2);
        }
        if (obj1 instanceof Boolean && obj2 instanceof Boolean) {
            return ((Boolean)obj1).equals((Boolean)obj2);
        }
        if (obj1 instanceof CtrlNodeEnum && obj2 instanceof CtrlNodeEnum) {
            return ((CtrlNodeEnum)((Object)obj1)).equals((Object)((CtrlNodeEnum)((Object)obj2)));
        }
        return obj1.equals(obj2);
    }

    private void clone(FMBizBillCollection _coll, FMBizBillCollection target) {
        if (_coll == null || target == null) {
            return;
        }
        _coll.clear();
        _coll.addCollection(target);
    }

    private class MyTreeSelectModel
    extends DefaultTreeSelectionModel {
        private static final long serialVersionUID = 1L;

        private MyTreeSelectModel() {
        }

        @Override
        public void removeSelectionPaths(TreePath[] paths) {
        }
    }
}

