/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.client;

import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.SqlOperateTypeEnum;
import com.kingdee.eas.fm.common.client.AbstractFMSqlLogFilterUI;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.common.client.FMSqlLogFilterParam;
import java.util.Date;
import org.apache.log4j.Logger;

public class FMSqlLogFilterUI
extends AbstractFMSqlLogFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(FMSqlLogFilterUI.class);

    @Override
    protected void init() throws Exception {
        super.init();
        this.btnCompanySelect.setVisible(false);
        this.initBillStatus(this.comboOperateType);
        this.pkDateFrom.setValue((Object)DateHelper.getDayBegin());
        this.pkDateTo.setValue((Object)DateHelper.getDayBegin());
        this.pkDateFrom.setSupportedEmpty(false);
        this.pkDateTo.setSupportedEmpty(false);
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        FMClientHelper.setSelectObject(this.comboOperateType, (Object)FMSysDefinedEnum.ALL_ITEMS);
    }

    private void initBillStatus(KDComboBox combo) {
        combo.removeAllItems();
        combo.addItem((Object)SqlOperateTypeEnum.update);
        combo.addItem((Object)SqlOperateTypeEnum.insert);
        combo.addItem((Object)SqlOperateTypeEnum.delete);
        combo.addItem((Object)SqlOperateTypeEnum.alter);
        combo.addItem((Object)SqlOperateTypeEnum.drop);
        combo.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
    }

    @Override
    public void clear() {
        super.clear();
        try {
            this.init();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    @Override
    public boolean verify() {
        FMClientVerifyHelper.verifyBeginEndDateRel((CoreUIObject)this, (Date)this.pkDateFrom.getValue(), (Date)this.pkDateTo.getValue());
        java.sql.Date startDate = this.pkDateFrom.getSqlDate();
        java.sql.Date endDate = this.pkDateTo.getSqlDate();
        FMClientVerifyHelper.verifyBeginEndDateRel((CoreUIObject)this, startDate, endDate);
        return super.verify();
    }

    @Override
    public Object getParam() {
        FMSqlLogFilterParam paramInfo = new FMSqlLogFilterParam();
        if (this.comboOperateType.getSelectedItem().equals((Object)FMSysDefinedEnum.ALL_ITEMS)) {
            paramInfo.setOperateType(999);
        } else {
            paramInfo.setOperateType(((SqlOperateTypeEnum)((Object)this.comboOperateType.getSelectedItem())).getValue());
        }
        paramInfo.setStartDate((Date)this.pkDateFrom.getValue());
        Date tmpDate = (Date)this.pkDateTo.getValue();
        long time = tmpDate.getTime();
        Date endDate = new Date(time + 86399000L);
        paramInfo.setEndDate(endDate);
        return paramInfo;
    }

    @Override
    public void setParam(Object param) {
        FMSqlLogFilterParam paramInfo = (FMSqlLogFilterParam)param;
        if (paramInfo.getOperateType() == 999) {
            this.comboOperateType.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        } else {
            this.comboOperateType.setSelectedItem((Object)SqlOperateTypeEnum.getEnum(paramInfo.getOperateType()));
        }
        this.pkDateTo.setValue((Object)paramInfo.getEndDate());
        this.pkDateFrom.setValue((Object)paramInfo.getStartDate());
    }

    @Override
    protected Class getParamClass() {
        return FMSqlLogFilterParam.class;
    }
}

