/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.btp.client.AbstractBTPMakeBillFromMultiDataListUI;
import com.kingdee.eas.base.btp.client.BTPMakeBillFromMultiDataListUI;
import com.kingdee.eas.base.dap.DAPException;
import com.kingdee.eas.base.uiframe.client.UIFactoryHelper;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class FmBTPMakeBillFromMultiDataListUI
extends AbstractBTPMakeBillFromMultiDataListUI {
    private static final Logger logger = CoreUIObject.getLogger(BTPMakeBillFromMultiDataListUI.class);
    private boolean isCancel = false;
    private CoreBillBaseCollection srcBillCollection;
    private Map bosTypeToEntity = new HashMap();
    private List bosTypeList = new ArrayList();
    protected ListUI currentBillListUI;
    private List srcBillColsList;
    private String srcBillListUIName;

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionConfirm.setEnabled(true);
        this.actionCancel.setEnabled(true);
        this.actionQuery.setEnabled(true);
        this.actionView.setEnabled(true);
        this.actionRefresh.setEnabled(true);
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnView.setIcon(EASResource.getIcon((String)"imgTbtn_view"));
        this.btnLocate.setIcon(EASResource.getIcon((String)"imgTbtn_speedgoto"));
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblPanel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(final ChangeEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        KDTabbedPane tabpane = (KDTabbedPane)e.getSource();
                        if (tabpane.getSelectedComponent() == null) {
                            int index = tabpane.getSelectedIndex();
                            if (index > -1) {
                                String bosType = (String)FmBTPMakeBillFromMultiDataListUI.this.bosTypeList.get(index);
                                EntityObjectInfo srcEntity = (EntityObjectInfo)FmBTPMakeBillFromMultiDataListUI.this.bosTypeToEntity.get(bosType);
                                try {
                                    ListUI billListUI = FmBTPMakeBillFromMultiDataListUI.this.newTab(srcEntity);
                                    tabpane.setComponentAt(index, (Component)((CoreBillListUI)billListUI));
                                    FmBTPMakeBillFromMultiDataListUI.this.currentBillListUI = billListUI;
                                }
                                catch (Exception ex) {
                                    FmBTPMakeBillFromMultiDataListUI.this.handleException(ex);
                                }
                            }
                        } else if (tabpane.getSelectedComponent() instanceof IUIObject) {
                            FmBTPMakeBillFromMultiDataListUI.this.currentBillListUI = (ListUI)tabpane.getSelectedComponent();
                        }
                    }
                });
            }
        });
    }

    protected ListUI newTab(EntityObjectInfo srcEntity) throws UIException {
        String f7ListUIName = (String)this.getUIContext().get("srcBillListUIName");
        if (f7ListUIName == null || f7ListUIName.equals("")) {
            // empty if block
        }
        HashMap uiCtx = new HashMap();
        if (this.getUIContext().get("BTPEDITPARAMETER") != null) {
            uiCtx.put("BTPEDITPARAMETER", this.getUIContext().get("BTPEDITPARAMETER"));
        }
        uiCtx.put("BOTPViewStatus", new Integer(1));
        if (this.getUIContext().get("BOTPFilter") != null) {
            uiCtx.put("BOTPFilter", this.getUIContext().get("BOTPFilter"));
        }
        if (this.getUIWindow() == null) {
            uiCtx.put("Owner", this.getUIContext().get("Owner"));
        } else {
            uiCtx.put("Owner", this);
        }
        ListUI uiObj = (ListUI)UIFactoryHelper.initUIObject((String)f7ListUIName, uiCtx, null, (String)"FINDVIEW");
        uiObj.getTableForBOTP().addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getClickCount() == 2) {
                    try {
                        FmBTPMakeBillFromMultiDataListUI.this.actionConfirm_actionPerformed(null);
                    }
                    catch (Exception e1) {
                        FmBTPMakeBillFromMultiDataListUI.this.handUIException(e1);
                    }
                }
            }
        });
        int width = 920;
        int height = 250;
        uiObj.getUIContentPane().setSize(new Dimension(width, height));
        uiObj.getMainTable().setBounds(5, 5, width - 5, height - 5);
        return uiObj;
    }

    public void loadFields() {
        super.loadFields();
    }

    public void storeFields() {
        super.storeFields();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.actionConfirm_actionPerformed(e);
        int count = this.tblPanel.getTabCount();
        for (int i = 0; i < count; ++i) {
            CoreBillListUI billListUI = (CoreBillListUI)this.tblPanel.getComponentAt(i);
            if (billListUI == null) {
                throw new DAPException(DAPException.BILLHASNOSELECT, new Object[]{((EntityObjectInfo)this.bosTypeToEntity.get(this.bosTypeList.get(i))).getAlias()});
            }
            if (this.srcBillCollection == null) {
                this.srcBillCollection = new CoreBillBaseCollection();
            }
            if (this.srcBillColsList == null) {
                this.srcBillColsList = new ArrayList();
            }
            this.srcBillCollection.addCollection(billListUI.getBillCollectionForPub());
            this.srcBillColsList.add(billListUI.getBillCollectionForPub());
        }
        if (this.srcBillCollection != null && this.srcBillCollection.size() > 0) {
            this.setCancel(false);
        } else {
            this.srcBillCollection = null;
            this.setCancel(true);
        }
        this.getUIWindow().close();
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.srcBillCollection = null;
        this.setCancel(true);
        this.getUIWindow().close();
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        if (this.currentBillListUI != null) {
            ((CoreBillListUI)this.currentBillListUI).actionQuery_actionPerformed(e);
        }
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        super.actionView_actionPerformed(e);
        if (this.currentBillListUI != null) {
            ((CoreBillListUI)this.currentBillListUI).actionView_actionPerformed(e);
        }
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        if (this.currentBillListUI != null) {
            ((CoreBillListUI)this.currentBillListUI).actionRefresh_actionPerformed(e);
        }
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public void setCancel(boolean isCancel) {
        this.isCancel = isCancel;
    }

    public CoreBillBaseCollection getSrcBillCollection() {
        return this.srcBillCollection;
    }

    public List getSrcBillColsList() {
        return this.srcBillColsList;
    }

    public void setSrcBosType(String bosType) throws BOSException {
        IMetaDataLoader metadataLoader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        EntityObjectInfo srcEntity = metadataLoader.getEntity(new BOSObjectType(bosType));
        ListUI srcBillListUI = this.newTab(srcEntity);
        this.tblPanel.addTab(srcEntity.getAlias(), (Component)((CoreBillListUI)srcBillListUI));
    }

    public void setSrcBosTypeList(List bosTypeList) {
        this.bosTypeList = bosTypeList;
        IMetaDataLoader metadataLoader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        for (String bosType : bosTypeList) {
            EntityObjectInfo srcEntity = metadataLoader.getEntity(new BOSObjectType(bosType));
            this.bosTypeToEntity.put(bosType, srcEntity);
            String alias = srcEntity.getAlias();
            this.tblPanel.addTab(alias, null);
            if (this.tblPanel.getTabCount() <= 0 || this.tblPanel.getSelectedIndex() >= 0) continue;
            this.tblPanel.setSelectedIndex(0);
        }
    }

    public boolean destroyWindow() {
        int count = this.tblPanel.getTabCount();
        for (int i = 0; i < count; ++i) {
            Component obj = this.tblPanel.getComponentAt(i);
            if (obj == null || !(obj instanceof ListUI)) continue;
            ((ListUI)obj).destroyWindow();
        }
        return super.destroyWindow();
    }

    public void actionLocate_actionPerformed(ActionEvent e) throws Exception {
        if (this.currentBillListUI != null) {
            this.currentBillListUI.actionLocate_actionPerformed(e);
        }
    }
}

