/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.client.helper.PermissionUIHelper;
import com.kingdee.eas.basedata.assistant.BankCollection;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.NewOrgUtils;
import com.kingdee.eas.basedata.org.OUException;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.EJBAccessFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.AbstractFmbiRptBaseFilterUI;
import com.kingdee.eas.fm.common.client.INewCompanyF7UsedAble;
import com.kingdee.eas.fm.common.client.NewCompanyF7Builder;
import com.kingdee.eas.fm.common.client.NewCompanyF7Substitute;
import com.kingdee.eas.fm.common.client.query.QuerySolutionConvert;
import com.kingdee.eas.fm.common.util.RptFmClientUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.bireport.util.SimpleTreeNode;
import com.kingdee.eas.framework.report.RptFilterCollection;
import com.kingdee.eas.framework.report.RptFilterInfo;
import com.kingdee.eas.framework.report.RptFilterUtils;
import com.kingdee.eas.framework.report.util.RptConditionManager;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptParamsUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import org.apache.log4j.Logger;

public class FmbiRptBaseFilterUI
extends AbstractFmbiRptBaseFilterUI
implements RptFmClientUtil.SelectCompanyListener,
RptFmClientUtil.SelectBankListener,
INewCompanyF7UsedAble {
    private static final Logger logger = CoreUIObject.getLogger(FmbiRptBaseFilterUI.class);
    protected Set<String> companyIdSet = null;
    protected String[] companyIds = null;
    protected SimpleTreeNode selectedNode = null;
    protected Set bankIdSet = null;
    protected KDDialog bankSelectDlg = null;
    protected ItemAction actionListOnLoad;
    private IUIObject listUI;
    protected NewCompanyF7Builder newCompanyF7Builder = new NewCompanyF7Builder(this);

    public FmbiRptBaseFilterUI() throws Exception {
        this.companyIdSet = new HashSet<String>();
    }

    protected Set getIdSetFromF7(KDBizPromptBox bizBox) {
        return AccessHelper.getIds(AccessHelper.getF7Ids(bizBox));
    }

    protected CoreBaseInfo[] getBaseInfoFromIdSet(Set idSet) throws BOSException {
        if (idSet == null || idSet.size() <= 0) {
            return null;
        }
        ICoreBase bizCtrl = EJBAccessFactory.createRemoteInstance().getEntityBizInterface(idSet.toArray()[0].toString());
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        CoreBaseCollection collection = bizCtrl.getCollection(evi);
        CoreBaseInfo[] ovs = new CoreBaseInfo[collection.size()];
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            ovs[i] = collection.get(i);
        }
        return ovs;
    }

    @Override
    protected void btnCompanySelect_actionPerformed(ActionEvent e) throws Exception {
        NewCompanyF7Substitute newCompanyF7 = new NewCompanyF7Substitute(this, this.getNewCompanyF7());
        newCompanyF7.showAndSaveSelected();
    }

    protected NewCompanyF7 getNewCompanyF7() {
        return this.getSubPermissionCompanyOrg();
    }

    protected NewCompanyF7 getAllCompanyOrg() {
        return this.newCompanyF7Builder.buildWithAllCompanyOrg();
    }

    protected NewCompanyF7 getSubPermissionCompanyOrg() {
        return this.newCompanyF7Builder.buildWithSubPermissionCompanyOrg(this.getListUI().getMetaDataPK(), FMHelper.getActionPK(this.actionListOnLoad));
    }

    public void setActionListOnLoad(ItemAction actionListOnLoad) {
        this.actionListOnLoad = actionListOnLoad;
    }

    public IUIObject getListUI() {
        return this.listUI;
    }

    public void setListUI(IUIObject listUI) {
        this.listUI = listUI;
    }

    @Override
    public String[] getSelectedCompanyIds() {
        return this.getCompanyIds();
    }

    @Override
    public void saveSelectedCompanyIds(Object Object2) {
        this.companyClear();
        this.companyIdSet.addAll(Arrays.asList(this.getSelectedOrgIds(Object2)));
    }

    private String[] getSelectedOrgIds(Object Object2) {
        FullOrgUnitInfo[] orgs = PermissionUIHelper.getOrgs((Object)Object2);
        if (orgs == null || orgs.length == 0) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < orgs.length; ++i) {
            FullOrgUnitInfo fullOrgUnitInfo = orgs[i];
            result.add(fullOrgUnitInfo.getId().toString());
        }
        return result.toArray(new String[0]);
    }

    protected TreeModel getCompanyTreeModel() throws Exception {
        DefaultKingdeeTreeNode kdroot;
        CtrlUnitInfo cuInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        if (cuInfo == null) {
            throw new OUException(OUException.CU_CAN_NOT_NULL);
        }
        TreeModel orgTreeModel = null;
        orgTreeModel = NewOrgUtils.getTreeModel((OrgViewType)OrgViewType.COMPANY, (String)"", (String)cuInfo.getId().toString(), (IMetaDataPK)new MetaDataPK(this.getMetaDataPK().getFullName()), (IMetaDataPK)new MetaDataPK("OnLoad"));
        Object root = orgTreeModel.getRoot();
        if (root != null && root instanceof DefaultKingdeeTreeNode && (kdroot = (DefaultKingdeeTreeNode)root).getUserObject() == null) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"14_FmbiRptBaseFilterUI"));
            SysUtil.abort();
        }
        return orgTreeModel;
    }

    protected String[] getCompanyIds() {
        return this.companyIdSet.toArray(new String[0]);
    }

    public void setCompanyIdSet(Set idSet) {
        this.companyIdSet = idSet;
    }

    public void handUIException(Throwable throwable) {
        logger.error((Object)throwable.getMessage(), throwable);
        super.handUIException(throwable);
    }

    public void onInit(RptParams initParams) throws Exception {
        this.btnSelectCompany.setIcon(EASResource.getIcon((String)"imgTbtn_orgstruchart"));
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)company)) {
            this.btnSelectCompany.setVisible(true);
        } else {
            this.btnSelectCompany.setVisible(false);
            this.companyClear();
            this.companyIdSet.add(company.getId().toString());
        }
    }

    public void companyClear() {
        if (this.companyIdSet != null) {
            this.companyIdSet.clear();
        } else {
            this.companyIdSet = new HashSet<String>();
        }
    }

    public RptParams getCustomCondition() {
        RptConditionManager rm = new RptConditionManager();
        rm.recordAllStatus((Container)((Object)this));
        rm.setProperty("companyIdSet", this.companyIdSet);
        return rm.toRptParams();
    }

    public void setCustomCondition(RptParams params) {
        RptConditionManager rm = new RptConditionManager(params);
        rm.restoreAllStatus((Container)((Object)this));
        this.companyIdSet = (Set)params.getObject("companyIdSet");
    }

    public CustomerParams getCustomerParams() {
        Object param = this.getParam();
        if (param == null) {
            return null;
        }
        try {
            QuerySolutionConvert convert = new QuerySolutionConvert();
            CustomerParams cp = convert.convertToCustomerParams(param);
            return cp;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            this.handUIException(e);
            return null;
        }
    }

    public void setCustomerParams(CustomerParams cp) {
        try {
            if (this.isNewQuerySolution(cp)) {
                QuerySolutionConvert convert = new QuerySolutionConvert();
                this.setParam(convert.convertToBizParams(RptParams.class, cp));
            } else {
                Object param = RptParamsUtil.getFromCustomerParams((CustomerParams)cp);
                if (param instanceof RptFilterInfo || param instanceof RptFilterCollection || param instanceof RptFilterInfo[] || param instanceof RptFilterCollection[]) {
                    this.setParam(RptFilterUtils.toObjectFromRptFilterMap((Object)RptParamsUtil.getFromCustomerParams((CustomerParams)cp)));
                } else {
                    this.setParam(RptParamsUtil.getFromCustomerParams((CustomerParams)cp));
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"15_FmbiRptBaseFilterUI"));
            SysUtil.abort();
        }
    }

    private boolean isNewQuerySolution(CustomerParams cp) {
        return cp.getCustomerParam(QuerySolutionConvert.FM_NEW_QUERY_SULUTION) != null;
    }

    public boolean verify() {
        if (this.companyIdSet == null || this.companyIdSet.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"16_FmbiRptBaseFilterUI"));
            return false;
        }
        return true;
    }

    @Override
    public void onCompanySelected(String[] companyIds) {
        this.companyIdSet = new HashSet<String>();
        if (companyIds != null) {
            this.companyIdSet.addAll(Arrays.asList(companyIds));
        }
    }

    @Override
    public void onBankSelected(DefaultKingdeeTreeNode selectedNode) {
        DefaultKingdeeTreeNode node = selectedNode;
        this.selectedNode = SimpleTreeNode.convert((DefaultMutableTreeNode)node);
    }

    protected Set getIdSetFromByBankTreeNode(SimpleTreeNode node) {
        if (node == null) {
            return null;
        }
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iter = node.childIterator();
        while (iter.hasNext()) {
            SimpleTreeNode n = (SimpleTreeNode)iter.next();
            if (!n.getValue().toString().equals("")) {
                BankInfo bankInfo = (BankInfo)n.getValue();
                hashSet.add(bankInfo.getId().toString());
            }
            hashSet.addAll(this.getIdSetFromByBankTreeNode(n));
        }
        return hashSet;
    }

    protected SimpleTreeNode getBankTreeNodeFromByIdSet(Set bankSet) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(new BankInfo());
        BankInfo rootBankInfo = new BankInfo();
        rootBankInfo.setName(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"105_RptFmClientUtil"));
        rootBankInfo.setId(BOSUuid.read((String)"36353433-3663-3321-3783-3902578210331C9A9013"));
        DefaultMutableTreeNode defNode = new DefaultMutableTreeNode(rootBankInfo);
        node.add(defNode);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (EmptyUtil.isEmpty((Collection)bankSet)) {
            return null;
        }
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)bankSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("longNumber"));
        view.setSorter(sorter);
        BankCollection coll = null;
        try {
            coll = BankFactory.getRemoteInstance().getBankCollection(view);
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        HashMap treeMap = new HashMap();
        HashMap<String, BankInfo> bankMap = new HashMap<String, BankInfo>();
        for (int i = 0; i < coll.size(); ++i) {
            bankMap.put(coll.get(i).getId().toString(), coll.get(i));
        }
        for (Map.Entry entry : bankMap.entrySet()) {
            String key = (String)entry.getKey();
            BankInfo value = (BankInfo)bankMap.get(key);
            if (treeMap.containsKey(key)) continue;
            DefaultKingdeeTreeNode child = new DefaultKingdeeTreeNode((Object)value);
            this.addNode(child, defNode, treeMap, value, bankMap);
        }
        return SimpleTreeNode.convert((DefaultMutableTreeNode)node);
    }

    private void addNode(DefaultKingdeeTreeNode child, DefaultMutableTreeNode node, Map treeMap, BankInfo bankInfo, Map bankMap) {
        if (bankInfo.getParent() == null || bankInfo.getParent().getId() == null || !bankMap.containsKey(bankInfo.getParent().getId().toString())) {
            String key = bankInfo.getId().toString();
            node.add((MutableTreeNode)child);
            treeMap.put(key, child);
        } else if (treeMap.containsKey(bankInfo.getParent().getId().toString())) {
            DefaultKingdeeTreeNode parent = (DefaultKingdeeTreeNode)treeMap.get(bankInfo.getParent().getId().toString());
            parent.add((MutableTreeNode)child);
            treeMap.put(bankInfo.getId().toString(), child);
        } else {
            String key = bankInfo.getParent().getId().toString();
            BankInfo value = (BankInfo)bankMap.get(key);
            DefaultKingdeeTreeNode parent = new DefaultKingdeeTreeNode((Object)value);
            this.addNode(parent, node, treeMap, value, bankMap);
            parent.add((MutableTreeNode)child);
            treeMap.put(bankInfo.getId().toString(), child);
        }
    }

    public void clear() {
        super.clear();
        try {
            this.onInit(this.getInitParams());
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    protected Set getNameSetFromByBankTreeNode(SimpleTreeNode node) {
        if (node == null) {
            return null;
        }
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iter = node.childIterator();
        while (iter.hasNext()) {
            SimpleTreeNode n = (SimpleTreeNode)iter.next();
            if (!n.getValue().toString().equals("")) {
                BankInfo bankInfo = (BankInfo)n.getValue();
                Iterator it = n.childIterator();
                if (!it.hasNext()) {
                    hashSet.add(bankInfo.getName());
                }
            }
            hashSet.addAll(this.getNameSetFromByBankTreeNode(n));
        }
        return hashSet;
    }
}

