/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.analysis.olap.Member;
import com.kingdee.bos.ctrl.swing.KDMenu;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.BankCollection;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.IOrgStructure;
import com.kingdee.eas.basedata.org.OUException;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.FMCommonFacadeFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.fm.common.client.AbstractFmbiRptBaseMainUI;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FmbiRptBaseFilterUI;
import com.kingdee.eas.fm.common.client.query.QuerySolutionConvert;
import com.kingdee.eas.fm.common.util.RptFmClientUtil;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.bireport.client.BireportBaseFilterUI;
import com.kingdee.eas.framework.bireport.util.SimpleTreeNode;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.report.RptFilterCollection;
import com.kingdee.eas.framework.report.RptFilterInfo;
import com.kingdee.eas.framework.report.RptFilterUtils;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptParamsUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.log4j.Logger;

public abstract class FmbiRptBaseMainUI
extends AbstractFmbiRptBaseMainUI {
    private static final Logger logger = CoreUIObject.getLogger(FmbiRptBaseMainUI.class);
    public static final String BIRPTVIEWDETAIL = "BiRptViewDetail";

    public FmbiRptBaseMainUI() throws Exception {
        this.actionJoinQuery.setVisible(false);
        FMClientHelper.addSqlMenu((CoreUIObject)this, this.menuTool);
    }

    protected CustomerQueryPanel getCustomerQueryPanel() throws Exception {
        BireportBaseFilterUI queryDialogUserPanel = this.getQueryDialogUserPanel();
        if (queryDialogUserPanel instanceof FmbiRptBaseFilterUI) {
            FmbiRptBaseFilterUI fmbiRptBaseFilterUI = (FmbiRptBaseFilterUI)queryDialogUserPanel;
            fmbiRptBaseFilterUI.setActionListOnLoad((ItemAction)this.actionOnLoad);
            fmbiRptBaseFilterUI.setListUI((IUIObject)this);
        }
        return queryDialogUserPanel;
    }

    protected boolean isCanCopyPaste() {
        return false;
    }

    protected RptParams getParamsForInit() {
        HashSet<String> set = new HashSet<String>();
        set.add(SysContext.getSysContext().getCurrentFIUnit().getId().toString());
        RptParams pp = new RptParams();
        pp.setObject("companyIdSet", set);
        return pp;
    }

    protected RptParams getParamsForRequest() {
        return this.params;
    }

    protected Map getDimensionIdSet() {
        return new HashMap();
    }

    protected void initViewDetailFilterParam(FilterParam filterParam) throws BOSException {
        Member[] ms = this.getSelectedDataCellItemInfo();
        if (ms == null) {
            return;
        }
        Map map = this.getDimensionIdSet();
        try {
            Iterator itValue = map.values().iterator();
            while (itValue.hasNext()) {
                PropertyUtils.setProperty((Object)filterParam, (String)itValue.toString(), new HashSet());
            }
            for (Member m : ms) {
                String dimName;
                if (!m.isLeaf() || !map.containsKey(dimName = m.getDimension().getLabel())) continue;
                String propName = (String)map.get(dimName);
                Set set = (Set)PropertyUtils.getProperty((Object)filterParam, (String)propName);
                if (m.getKey() == null) continue;
                set.add(m.getKey());
            }
        }
        catch (IllegalAccessException e) {
            throw FMHelper.toBOSException(e);
        }
        catch (InvocationTargetException e) {
            throw FMHelper.toBOSException(e);
        }
        catch (NoSuchMethodException e) {
            throw FMHelper.toBOSException(e);
        }
    }

    protected SimpleTreeNode getCompanyTree() throws Exception {
        CtrlUnitInfo cuInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        if (cuInfo == null) {
            throw new OUException(OUException.CU_CAN_NOT_NULL);
        }
        IOrgStructure istruct = OrgStructureFactory.getRemoteInstance();
        OrgStructureInfo rootInfo = istruct.getOrgStructureInfo("select id,longnumber,isLeaf,unit.id,unit.name where unit.id = '" + cuInfo.getId().toString() + "' and tree.id = '" + "00000000-0000-0000-0000-0000000000024F2827FD" + "'");
        return FMCommonFacadeFactory.getRemoteInstance().getCompanyTree("00000000-0000-0000-0000-0000000000024F2827FD", rootInfo, (IMetaDataPK)new MetaDataPK(this.getMetaDataPK().getFullName()), (IMetaDataPK)new MetaDataPK("OnLoad"));
    }

    protected SimpleTreeNode getBankTree() throws Exception {
        DefaultKingdeeTreeNode selectedNode;
        DefaultKingdeeTreeNode node = selectedNode = RptFmClientUtil.buildTreeByBankCollection(RptFmClientUtil.getBankCollection());
        return SimpleTreeNode.convert((DefaultMutableTreeNode)node);
    }

    private void addChildNode(SimpleTreeNode root, BankInfo info) {
        SimpleTreeNode node = new SimpleTreeNode((Object)info, 1);
        SimpleTreeNode parent = null;
        if (info.getParent() != null) {
            parent = this.searchNodeById(root, info.getParent().getId().toString());
        }
        if (parent != null) {
            parent.addChild(node);
        } else {
            String id = info.getId().toString();
            for (int i = 0; i < root.getChildCount(); ++i) {
                SimpleTreeNode s = root.getChildAt(i);
                BankInfo rootItem = (BankInfo)s.getValue();
                if (rootItem.getParent() == null || !rootItem.getParent().getId().toString().equals(id)) continue;
                node.addChild(s);
                root.removeChild(s);
                --i;
            }
            root.addChild(node);
        }
    }

    private SimpleTreeNode searchNodeById(SimpleTreeNode root, String id) {
        BankInfo info = (BankInfo)root.getValue();
        if (info != null) {
            if (id.equals(info.getId().toString())) {
                return root;
            }
            for (int i = 0; i < root.getChildCount(); ++i) {
                SimpleTreeNode node = this.searchNodeById(root.getChildAt(i), id);
                if (node == null) continue;
                return node;
            }
        }
        return null;
    }

    protected DefaultMutableTreeNode getBankDefaultMutableTreeNode() {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
        BankCollection bankCollection = FmbiRptBaseMainUI.getBankCollection();
        this.addBankNode(rootNode, bankCollection);
        return rootNode;
    }

    protected static BankCollection getBankCollection() {
        EntityViewInfo vi = new EntityViewInfo();
        FilterInfo fInfo = new FilterInfo();
        vi.setFilter(fInfo);
        BankCollection bankCollection = null;
        try {
            bankCollection = BankFactory.getRemoteInstance().getBankCollection(vi);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        if (bankCollection == null || bankCollection.size() == 0) {
            return null;
        }
        return bankCollection;
    }

    protected static BankCollection getChildBankCollection(BankInfo bankInfo) {
        String bankId = bankInfo.getId().toString();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)bankId));
        EntityViewInfo vi = new EntityViewInfo();
        vi.setFilter(filter);
        BankCollection bankCollection = null;
        try {
            bankCollection = BankFactory.getRemoteInstance().getBankCollection(vi);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        if (bankCollection == null || bankCollection.size() == 0) {
            return null;
        }
        return bankCollection;
    }

    protected void addBankNode(DefaultMutableTreeNode rootNode, BankCollection bankCollection) {
        BankCollection addBankCollection = bankCollection;
        for (int i = 0; i < addBankCollection.size(); ++i) {
            BankInfo bank = addBankCollection.get(i);
            rootNode.add(new DefaultMutableTreeNode(bank));
            if (bank.isIsLeaf()) continue;
            this.addBankNode(rootNode, FmbiRptBaseMainUI.getChildBankCollection(bank));
        }
    }

    protected SystemEnum getSystemEnumForOA() {
        return FMClientHelper.getSystemEnum((CoreUI)this);
    }

    public void onLoad() throws Exception {
        this.checkCurrentCompany();
        super.onLoad();
        com.kingdee.eas.base.core.fm.FMClientHelper.addOnLineHelpMenu((CoreUIObject)this, (KDMenu)this.menuView);
        this.getMainStatusBar().setPerTitle(FMClientHelper.getSysStatusBarTitle((CoreUI)this));
    }

    protected CustomerParams buildCustomerParams() throws Exception {
        QuerySolutionConvert convert = new QuerySolutionConvert();
        CustomerParams cp = convert.convertToCustomerParams(this.params);
        return cp;
    }

    protected Object buildRptParams(CustomerParams cp) throws Exception {
        if (this.isNewQuerySolution(cp)) {
            QuerySolutionConvert convert = new QuerySolutionConvert();
            return convert.convertToBizParams(RptParams.class, cp);
        }
        Object param = RptParamsUtil.getFromCustomerParams((CustomerParams)cp);
        if (param instanceof RptFilterInfo || param instanceof RptFilterCollection || param instanceof RptFilterInfo[] || param instanceof RptFilterCollection[]) {
            return RptFilterUtils.toObjectFromRptFilterMap((Object)RptParamsUtil.getFromCustomerParams((CustomerParams)cp));
        }
        return RptParamsUtil.getFromCustomerParams((CustomerParams)cp);
    }

    private boolean isNewQuerySolution(CustomerParams cp) {
        return cp.getCustomerParam(QuerySolutionConvert.FM_NEW_QUERY_SULUTION) != null;
    }

    private void checkCurrentCompany() {
        CompanyOrgUnitInfo companyOrgUnitInfo = SysContext.getSysContext().getCurrentFIUnit();
        if (companyOrgUnitInfo == null) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fm.common.FMResource", (String)"currenctCompanyNotEmpty"));
            SysUtil.abort();
        }
        if (companyOrgUnitInfo.getAccountTable() == null) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fm.common.FMResource", (String)"currenctCompanyAcctTableNull"));
            SysUtil.abort();
        }
    }

    protected SimpleTreeNode getBankTreeNodeFromByIdSet(Set bankSet) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(new BankInfo());
        BankInfo rootBankInfo = new BankInfo();
        rootBankInfo.setName(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"105_RptFmClientUtil"));
        rootBankInfo.setId(BOSUuid.read((String)"36353433-3663-3321-3783-3902578210331C9A9013"));
        DefaultMutableTreeNode defNode = new DefaultMutableTreeNode(rootBankInfo);
        node.add(defNode);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (!EmptyUtil.isEmpty((Collection)bankSet)) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)bankSet, CompareType.INCLUDE));
        }
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("longNumber"));
        view.setSorter(sorter);
        BankCollection coll = null;
        try {
            coll = BankFactory.getRemoteInstance().getBankCollection(view);
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        HashMap treeMap = new HashMap();
        HashMap<String, BankInfo> bankMap = new HashMap<String, BankInfo>();
        for (int i = 0; i < coll.size(); ++i) {
            bankMap.put(coll.get(i).getId().toString(), coll.get(i));
        }
        for (Map.Entry entry : bankMap.entrySet()) {
            String key = (String)entry.getKey();
            BankInfo value = (BankInfo)bankMap.get(key);
            if (treeMap.containsKey(key)) continue;
            DefaultKingdeeTreeNode child = new DefaultKingdeeTreeNode((Object)value);
            this.addNode(child, defNode, treeMap, value, bankMap);
        }
        return SimpleTreeNode.convert((DefaultMutableTreeNode)node);
    }

    private void addNode(DefaultKingdeeTreeNode child, DefaultMutableTreeNode node, Map treeMap, BankInfo bankInfo, Map bankMap) {
        if (bankInfo.getParent() == null || bankInfo.getParent().getId() == null || !bankMap.containsKey(bankInfo.getParent().getId().toString())) {
            String key = bankInfo.getId().toString();
            node.add((MutableTreeNode)child);
            treeMap.put(key, child);
        } else if (treeMap.containsKey(bankInfo.getParent().getId().toString())) {
            DefaultKingdeeTreeNode parent = (DefaultKingdeeTreeNode)treeMap.get(bankInfo.getParent().getId().toString());
            parent.add((MutableTreeNode)child);
            treeMap.put(bankInfo.getId().toString(), child);
        } else {
            String key = bankInfo.getParent().getId().toString();
            BankInfo value = (BankInfo)bankMap.get(key);
            DefaultKingdeeTreeNode parent = new DefaultKingdeeTreeNode((Object)value);
            this.addNode(parent, node, treeMap, value, bankMap);
            parent.add((MutableTreeNode)child);
            treeMap.put(bankInfo.getId().toString(), child);
        }
    }
}

