/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.fi.cas.FundFlowDirection;
import com.kingdee.eas.fi.cas.FundFlowItemInfo;
import com.kingdee.eas.fm.common.CheckUtils;
import com.kingdee.eas.fm.common.ConvertUtils;
import com.kingdee.eas.fm.common.DynamicUtils;
import com.kingdee.eas.fm.common.IFmMbgUsed;
import com.kingdee.eas.fm.common.client.FundBgF7Info;
import com.kingdee.eas.fm.common.client.FundBgItemDialog;
import com.kingdee.eas.fm.common.client.FundBgUtils;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Component;

public class FundBgF7Manager {
    static int FUNDITEM = 0;
    static int MBGNUMBER = 1;
    static int MBGNAME = 2;
    protected KDPromptBox fundBgF7;
    protected IFmMbgUsed info;
    protected CoreUI ui;
    protected String companyId = null;
    protected FundFlowDirection direction = null;
    protected boolean mbg001 = false;
    private String[] fields = null;

    public FundBgF7Manager() {
    }

    public FundBgF7Manager(String ... fields) {
        if (fields == null || fields.length != 3) {
            throw new IllegalArgumentException();
        }
        this.fields = fields;
    }

    public void loadFields(CoreUI ui, KDLabelContainer oldBgF7, KDLabelContainer newBgF7, IFmMbgUsed info, FundFlowDirection direction) {
        String companyId = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString();
        this.loadFields(ui, companyId, oldBgF7, newBgF7, info, direction);
    }

    public void loadFields(CoreUI ui, String companyId, KDLabelContainer oldBgF7, KDLabelContainer newBgF7, IFmMbgUsed info, FundFlowDirection direction, boolean mbg001) {
        this.loadFields(ui, companyId, oldBgF7, newBgF7, mbg001, info, direction);
    }

    public void loadFields(CoreUI ui, String companyId, KDLabelContainer oldBgF7, KDLabelContainer newBgF7, IFmMbgUsed info, FundFlowDirection direction) {
        boolean mbg001 = ContextHelperFactory.getRemoteInstance().getBooleanParam("MBG_C001", ConvertUtils.PK(companyId));
        this.loadFields(ui, companyId, oldBgF7, newBgF7, mbg001, info, direction);
    }

    public void loadFields(CoreUI ui, String companyId, KDLabelContainer oldBgF7, KDLabelContainer newBgF7, boolean mbg001, IFmMbgUsed info, FundFlowDirection direction) {
        this.mbg001 = mbg001;
        if (mbg001) {
            oldBgF7.setVisible(false);
            newBgF7.setLocation(oldBgF7.getLocation());
            newBgF7.setBoundLabelLength(oldBgF7.getBoundLabelLength());
            newBgF7.setBounds(oldBgF7.getBounds());
            newBgF7.getParent().remove((Component)newBgF7);
            oldBgF7.getParent().add((Component)newBgF7, oldBgF7.getClientProperty((Object)"KDLayoutConstraints"));
            newBgF7.setVisible(true);
            this.loadFields(ui, companyId, (KDBizPromptBox)newBgF7.getBoundEditor(), info, direction);
        } else {
            newBgF7.setVisible(false);
        }
    }

    protected void loadFields(CoreUI ui, String companyId, KDBizPromptBox fundBgF7, IFmMbgUsed info, FundFlowDirection direction) {
        this.ui = ui;
        this.fundBgF7 = fundBgF7;
        this.info = info;
        this.companyId = companyId;
        this.direction = direction;
        fundBgF7.setDisplayFormat("$name$");
        fundBgF7.setCommitFormat("$name$");
        fundBgF7.setEditFormat("$name$");
        fundBgF7.setVisible(true);
        fundBgF7.setEditable(false);
        fundBgF7.setSelector((KDPromptSelector)new FundBgItemDialog(ui, companyId, (KDPromptBox)fundBgF7, direction));
        this.loadData();
    }

    public void storeFields() {
        if (!this.mbg001) {
            return;
        }
        FundBgF7Info f7Value = (FundBgF7Info)((Object)this.fundBgF7.getValue());
        if (f7Value == null) {
            this.info.put(this.getFundPropName(), null);
            this.info.put(this.getMBGNamePropName(), null);
            this.info.put(this.getMBGNumberPropName(), null);
        } else {
            this.info.put(this.getFundPropName(), f7Value.fundBgValue);
            String[] bg = FundBgUtils.getMbgComb(this.info, f7Value.fundBgValue, this.companyId, this.ui, f7Value.bgValue, 0);
            this.info.put(this.getMBGNumberPropName(), bg[0]);
            this.info.put(this.getMBGNamePropName(), bg[1]);
        }
    }

    protected void loadData() {
        if (!this.mbg001 || this.fundBgF7 == null || this.info == null) {
            return;
        }
        FundFlowItemInfo fundFlowItem = null;
        if (CheckUtils.exist(ConvertUtils.PROP(this.info, this.getFundPropName() + ".name"))) {
            fundFlowItem = (FundFlowItemInfo)ConvertUtils.PROP(this.info, this.getFundPropName());
        } else if (CheckUtils.exist(this.getFundFlowItemId())) {
            IObjectPK pk = ConvertUtils.PK(this.getFundFlowItemId());
            try {
                fundFlowItem = (FundFlowItemInfo)DynamicUtils.getInfo(pk, ConvertUtils.SIC("name,number"));
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        if (CheckUtils.exist(fundFlowItem)) {
            FundBgF7Info f7info = new FundBgF7Info();
            f7info.fundBgValue = fundFlowItem;
            f7info.bgValue = FundBgUtils.getBgDimensionMember(this.getMbgNumber(), this.getMbgName(), fundFlowItem, this.companyId, this.ui);
            f7info.refreshName();
            this.fundBgF7.setValue((Object)f7info);
        } else {
            this.fundBgF7.setValue(null);
        }
    }

    public void verify(IFmMbgUsed info) throws Exception {
        if (!this.mbg001) {
            return;
        }
        FundBgUtils.checkBgDimension(info, (FundFlowItemInfo)info.get(this.getFundPropName()), this.companyId, this.ui, 0, null);
    }

    protected String getFundFlowItemId() {
        return ConvertUtils.IDSTR(this.info.get(this.getFundPropName()));
    }

    protected String getMbgNumber() {
        return (String)this.info.get(this.getMBGNumberPropName());
    }

    protected String getMbgName() {
        return (String)this.info.get(this.getMBGNamePropName());
    }

    protected String getFundPropName() {
        if (this.fields != null) {
            return this.fields[FUNDITEM];
        }
        if (this.direction == FundFlowDirection.IN) {
            return this.info.getInPropName()[FUNDITEM];
        }
        return this.info.getOutPropName()[FUNDITEM];
    }

    protected String getMBGNumberPropName() {
        if (this.fields != null) {
            return this.fields[MBGNUMBER];
        }
        if (this.direction == FundFlowDirection.IN) {
            return this.info.getInPropName()[MBGNUMBER];
        }
        return this.info.getOutPropName()[MBGNUMBER];
    }

    protected String getMBGNamePropName() {
        if (this.fields != null) {
            return this.fields[MBGNAME];
        }
        if (this.direction == FundFlowDirection.IN) {
            return this.info.getInPropName()[MBGNAME];
        }
        return this.info.getOutPropName()[MBGNAME];
    }
}

