/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.FundFlowDirection;
import com.kingdee.eas.fi.cas.FundFlowItemInfo;
import com.kingdee.eas.fi.cas.client.FundFlowItemPromptBox;
import com.kingdee.eas.fm.common.CheckUtils;
import com.kingdee.eas.fm.common.IFmMbgUsed;
import com.kingdee.eas.fm.common.client.FMBgControlDimensionMemberSelectDialog;
import com.kingdee.eas.fm.common.client.FundBgF7Info;
import com.kingdee.eas.fm.common.client.FundBgItemDialog;
import com.kingdee.eas.fm.common.client.FundBgUtils;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.MbgParamsFactory;
import com.kingdee.eas.ma.control.client.BgControlDimensionMemberSelectDialog;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.utils.SourceDisplayInfo;
import java.awt.Component;
import java.util.List;

public class FundBgF7TableManager {
    static int FUNDITEM = 0;
    static int MBGNUMBER = 1;
    static int MBGNAME = 2;
    protected KDTable table = null;
    protected String colFundFlowItem = null;
    protected String colExtendItem = null;
    protected FundFlowDirection direction = null;
    protected boolean mbg001 = false;
    protected String companyId = null;
    protected CoreUI ui = null;
    protected String colBgDim = null;

    public void initFundBgF7(CoreUI ui, String companyId, KDTable table, String colBgItem, String colFundFlowItem, String colExtendItem, FundFlowDirection direction, boolean mbg001) {
        this.initFundBgF7(ui, companyId, table, colBgItem, colFundFlowItem, colExtendItem, mbg001, direction);
    }

    public void initFundBgF7(CoreUI ui, String companyId, KDTable table, String colBgItem, String colFundFlowItem, String colExtendItem, FundFlowDirection direction) {
        boolean mbg001 = false;
        try {
            String mbg001Str = MbgParamsFactory.getRemoteInstance().getParamValue(companyId, "MBG_C001");
            if (mbg001Str != null) {
                mbg001 = Boolean.parseBoolean(mbg001Str);
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        this.initFundBgF7(ui, companyId, table, colBgItem, colFundFlowItem, colExtendItem, mbg001, direction);
    }

    public void initFundBgF7(CoreUI ui, String companyId, KDTable table, String colBgItem, String colFundFlowItem, String colExtendItem, boolean mbg001, FundFlowDirection direction) {
        this.colFundFlowItem = colFundFlowItem;
        this.colExtendItem = colExtendItem;
        this.table = table;
        this.direction = direction;
        this.mbg001 = mbg001;
        this.companyId = companyId;
        this.ui = ui;
        this.initFundFlowItemF7();
        this.initEntendItemF7();
        this.setLock(colBgItem);
        this.addListener();
    }

    public void loadFields(IObjectCollection col) {
        if (!this.mbg001 || CheckUtils.isEmpty(col)) {
            return;
        }
        for (int i = 0; i < col.size(); ++i) {
            IFmMbgUsed entryInfo = (IFmMbgUsed)col.getObject(i);
            String bgNumber = entryInfo.getString(this.getMBGNumberPropName(entryInfo));
            String bgName = entryInfo.getString(this.getMBGNamePropName(entryInfo));
            FundFlowItemInfo fInfo = (FundFlowItemInfo)entryInfo.get(this.getFundPropName(entryInfo));
            this.table.getCell(i, this.colFundFlowItem).setValue((Object)fInfo);
            this.table.getCell(i, this.colExtendItem).setValue((Object)FundBgUtils.getBgDimensionMember(bgNumber, bgName, fInfo, this.companyId, this.ui));
        }
    }

    public void storeFields(IFmMbgUsed info, IObjectCollection col) {
        if (!this.mbg001 || CheckUtils.isEmpty(col)) {
            return;
        }
        for (int i = 0; i < col.size(); ++i) {
            IFmMbgUsed entryInfo = (IFmMbgUsed)col.getObject(i);
            FundFlowItemInfo item = (FundFlowItemInfo)this.table.getCell(i, this.colFundFlowItem).getValue();
            BgDimensionMember extendItem = (BgDimensionMember)this.table.getCell(i, this.colExtendItem).getValue();
            entryInfo.put(this.getFundPropName(entryInfo), item);
            String[] bg = FundBgUtils.getMbgComb(info, item, this.companyId, this.ui, extendItem, i);
            entryInfo.put(this.getMBGNumberPropName(entryInfo), bg[0]);
            entryInfo.put(this.getMBGNamePropName(entryInfo), bg[1]);
        }
    }

    public void storeFields(IFmMbgUsed info, IFmMbgUsed entryInfo, IRow row) {
        if (!this.mbg001) {
            return;
        }
        FundFlowItemInfo item = (FundFlowItemInfo)row.getCell(this.colFundFlowItem).getValue();
        BgDimensionMember extendItem = (BgDimensionMember)row.getCell(this.colExtendItem).getValue();
        entryInfo.put(this.getFundPropName(entryInfo), item);
        String[] bg = FundBgUtils.getMbgComb(info, item, this.companyId, this.ui, extendItem, row.getRowIndex());
        entryInfo.put(this.getMBGNumberPropName(entryInfo), bg[0]);
        entryInfo.put(this.getMBGNamePropName(entryInfo), bg[1]);
    }

    public void verify(IFmMbgUsed info) throws Exception {
        if (!this.mbg001) {
            return;
        }
        int size = this.table.getRowCount();
        for (int i = 0; i < size; ++i) {
            FundBgUtils.checkBgDimension(info, (FundFlowItemInfo)this.table.getRow(i).getCell(this.colFundFlowItem).getValue(), this.companyId, this.ui, i, this.table.getRow(i).getCell(this.colExtendItem));
        }
    }

    private void setLock(String colBgItem) {
        if (this.mbg001) {
            this.table.getColumn(colBgItem).getStyleAttributes().setHided(true);
            this.table.getColumn(this.colExtendItem).getStyleAttributes().setHided(false);
            this.table.getColumn(this.colExtendItem).getStyleAttributes().setLocked(true);
        } else {
            this.table.getColumn(colBgItem).getStyleAttributes().setHided(false);
            this.table.getColumn(this.colFundFlowItem).getStyleAttributes().setHided(true);
            this.table.getColumn(this.colExtendItem).getStyleAttributes().setHided(true);
            String boName = FundBgUtils.getBoName(this.ui);
            if ("com.kingdee.eas.fi.cas.app.ReceivingBill".equals(boName) || "com.kingdee.eas.fi.cas.app.PaymentBill".equals(boName)) {
                this.table.getColumn(this.colFundFlowItem).getStyleAttributes().setHided(false);
            }
        }
    }

    private void addListener() {
        this.table.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                FundBgF7TableManager.this.tableValueChanged(e);
            }
        });
    }

    private void initFundFlowItemF7() {
        if (!this.mbg001) {
            return;
        }
        KDBizPromptBox f7 = new KDBizPromptBox();
        f7.setQueryInfo("com.kingdee.eas.fi.cas.F7FundFlowItemQuery");
        FundFlowItemPromptBox selector = new FundFlowItemPromptBox((IUIObject)this.ui, this.direction);
        selector.setMultiSelect(false);
        f7.setSelector((KDPromptSelector)selector);
        f7.setEnabledMultiSelection(false);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)"1"));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(0)));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        f7.setEntityViewInfo(evi);
        f7.setEditFormat("$number$");
        f7.setDisplayFormat("$name$");
        f7.setCommitFormat("$number$;$name$");
        this.table.getColumn(this.colFundFlowItem).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)f7));
    }

    private void initEntendItemF7() {
        if (!this.mbg001) {
            return;
        }
        KDBizPromptBox f7 = new KDBizPromptBox();
        FMBgControlDimensionMemberSelectDialog dialog = new FMBgControlDimensionMemberSelectDialog((Component)this.ui, this.companyId);
        f7.setSelector((KDPromptSelector)dialog);
        f7.setDisplayFormat("$name$");
        f7.setEditFormat("$number$");
        f7.setCommitFormat("$number$");
        f7.setEditable(false);
        f7.setHistoryRecordEnabled(false);
        f7.setMyCommonUseEnabled(false);
        this.table.getColumn(this.colExtendItem).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)f7));
        f7.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                FundBgF7TableManager.this.extendItemWillShow(e);
            }
        });
    }

    private void tableValueChanged(KDTEditEvent e) {
        if (e.getValue() != null && e.getValue().equals(e.getOldValue()) || e.getValue() == null && e.getOldValue() == null) {
            return;
        }
        int rowIndex = e.getRowIndex();
        if (e.getColIndex() == this.table.getColumnIndex(this.colFundFlowItem)) {
            this.table.getRow(rowIndex).getCell(this.colExtendItem).setValue(null);
        }
    }

    private void extendItemWillShow(SelectorEvent e) {
        int rowIndex = this.table.getSelectManager().getActiveRowIndex();
        this.initExtendItem(rowIndex);
    }

    private void initExtendItem(int rowIndex) {
        FundFlowItemInfo fInfo = (FundFlowItemInfo)this.table.getRow(rowIndex).getCell(this.colFundFlowItem).getValue();
        if (fInfo == null) {
            this.table.getRow(rowIndex).getCell(this.colExtendItem).getStyleAttributes().setLocked(true);
            return;
        }
        List<SourceDisplayInfo> src = FundBgUtils.getBgSource(fInfo, this.companyId, this.ui);
        ICellEditor cellEditor = this.table.getColumn(this.colExtendItem).getEditor();
        if (EmptyUtil.isEmpty((Object)cellEditor) || EmptyUtil.isEmpty(src)) {
            return;
        }
        KDBizPromptBox f7 = (KDBizPromptBox)cellEditor.getComponent();
        BgControlDimensionMemberSelectDialog dialog = (BgControlDimensionMemberSelectDialog)f7.getSelector();
        dialog.setCanSelectSources(src);
        if (src != null && !src.isEmpty()) {
            this.table.getRow(rowIndex).getCell(this.colExtendItem).getStyleAttributes().setLocked(false);
        } else {
            this.table.getRow(rowIndex).getCell(this.colExtendItem).getStyleAttributes().setLocked(true);
        }
    }

    protected String getFundPropName(IFmMbgUsed info) {
        if (this.direction == FundFlowDirection.IN) {
            return info.getInPropName()[FUNDITEM];
        }
        return info.getOutPropName()[FUNDITEM];
    }

    protected String getMBGNumberPropName(IFmMbgUsed info) {
        if (this.direction == FundFlowDirection.IN) {
            return info.getInPropName()[MBGNUMBER];
        }
        return info.getOutPropName()[MBGNUMBER];
    }

    protected String getMBGNamePropName(IFmMbgUsed info) {
        if (this.direction == FundFlowDirection.IN) {
            return info.getInPropName()[MBGNAME];
        }
        return info.getOutPropName()[MBGNAME];
    }

    public void initFundBg4Comb(CoreUI ui, String companyId, KDTable table, String oldBgColName, String colBgDim, FundFlowDirection direction) {
        boolean MBG001 = false;
        try {
            String mbg001Str = MbgParamsFactory.getRemoteInstance().getParamValue(companyId, "MBG_C001");
            if (mbg001Str != null) {
                MBG001 = Boolean.parseBoolean(mbg001Str);
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        this.initFundBg4Comb(ui, companyId, table, oldBgColName, colBgDim, MBG001, direction);
    }

    public void initFundBg4Comb(CoreUI ui, String companyId, KDTable table, String colBgItem, String colBgDim, boolean mbg001, FundFlowDirection direction) {
        this.ui = ui;
        this.companyId = companyId;
        this.table = table;
        this.colBgDim = colBgDim;
        this.table = table;
        this.mbg001 = mbg001;
        this.direction = direction;
        if (mbg001) {
            table.getColumn(colBgDim).getStyleAttributes().setHided(false);
            table.getColumn(colBgItem).getStyleAttributes().setHided(true);
            KDBizPromptBox fundBgF7 = new KDBizPromptBox();
            table.add((Component)fundBgF7);
            table.getColumn(colBgDim).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)fundBgF7));
            fundBgF7.setDisplayFormat("$name$");
            fundBgF7.setCommitFormat("$name$");
            fundBgF7.setEditFormat("$name$");
            fundBgF7.setVisible(true);
            fundBgF7.setEditable(false);
            FundBgItemDialog fundBgdg = new FundBgItemDialog(ui, companyId, (KDPromptBox)fundBgF7, direction);
            fundBgF7.setSelector((KDPromptSelector)fundBgdg);
        } else {
            table.getColumn(colBgDim).getStyleAttributes().setHided(true);
            table.getColumn(colBgItem).getStyleAttributes().setHided(false);
        }
    }

    public void storeFields4Comb(IFmMbgUsed info, IRow row) {
        if (!this.mbg001) {
            return;
        }
        FundBgF7Info tableEntryObject = (FundBgF7Info)((Object)row.getCell(this.colBgDim).getValue());
        if (tableEntryObject == null) {
            info.put(this.getFundPropName(info), null);
            info.put(this.getMBGNamePropName(info), null);
            info.put(this.getMBGNumberPropName(info), null);
        } else {
            if (info.containsKey(this.colBgDim)) {
                info.remove(this.colBgDim);
            }
            info.put(this.getFundPropName(info), tableEntryObject.fundBgValue);
            String[] bg = FundBgUtils.getMbgComb(info, tableEntryObject.fundBgValue, this.companyId, this.ui, tableEntryObject.bgValue, row.getRowIndex());
            info.put(this.getMBGNumberPropName(info), bg[0]);
            info.put(this.getMBGNamePropName(info), bg[1]);
        }
    }
}

