/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.EJBAccessFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.FundFlowItemInfo;
import com.kingdee.eas.fm.common.ConvertUtils;
import com.kingdee.eas.fm.common.FmMbgHelper;
import com.kingdee.eas.fm.common.IFmMbgUsed;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.control.BgControlException;
import com.kingdee.eas.ma.control.BgControlRuleInfo;
import com.kingdee.eas.ma.control.BgControlSchemeCollection;
import com.kingdee.eas.ma.control.BgControlSchemeFacadeFactory;
import com.kingdee.eas.ma.control.BgControlSchemeFactory;
import com.kingdee.eas.ma.control.BgControlSchemeInfo;
import com.kingdee.eas.ma.control.utils.BgControlUtils;
import com.kingdee.eas.ma.fm.FmBgCtrlCombRelationCollection;
import com.kingdee.eas.ma.fm.FmBgCtrlCombRelationFactory;
import com.kingdee.eas.ma.fm.client.FmBgCtrlCombRelHandler;
import com.kingdee.eas.ma.mbg.DimensionSourceCollection;
import com.kingdee.eas.ma.mbg.DimensionSourceFactory;
import com.kingdee.eas.ma.mbg.DimensionSourceInfo;
import com.kingdee.eas.ma.mbg.client.utils.DimensionClientHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.utils.SourceDisplayInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class FundBgUtils {
    private static final Logger logger = Logger.getLogger(FundBgUtils.class);
    public static String BG_DIMENSION_DISPLAY = "{0},{1}";
    public static final String COMMA = ",";
    public static final String COLON = ":";
    public static final String REC = "com.kingdee.eas.fi.cas.app.ReceivingBill";
    public static final String PAY = "com.kingdee.eas.fi.cas.app.PaymentBill";

    public static String getMbgNumber(BgDimensionMember bg) {
        String[] nums;
        if (FundBgUtils.isNull(bg)) {
            return null;
        }
        String[] srcs = bg.getSrcNumber().split(COMMA);
        if (srcs.length != (nums = bg.getNumber().split(COMMA)).length) {
            return null;
        }
        String[] ret = new String[srcs.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = srcs[i] + COLON + nums[i];
        }
        return ConvertUtils.Join(COMMA, ret);
    }

    public static String getMbgName(BgDimensionMember bg) {
        if (FundBgUtils.isNull(bg)) {
            return null;
        }
        String[] names = bg.getName().split(COMMA);
        return ConvertUtils.Join(COMMA, names);
    }

    public static BgDimensionMember getBgDimensionMember(String number, String name) {
        if (number == null) {
            return null;
        }
        String[] gp = number.split(COMMA);
        String[] srcs = new String[gp.length];
        String[] nums = new String[gp.length];
        for (int i = 0; i < gp.length; ++i) {
            String one = gp[i];
            String[] temp = one.split(COLON);
            srcs[i] = temp[0];
            nums[i] = temp[1];
        }
        BgDimensionMember bg = new BgDimensionMember(null, null, name, ConvertUtils.Join(COMMA, nums));
        bg.setSrcNumber(ConvertUtils.Join(COMMA, srcs));
        return bg;
    }

    public static BgDimensionMember getBgDimensionMember(String number, String name, FundFlowItemInfo fInfo, String companyId, CoreUI ui) {
        Object col = null;
        BgDimensionMember bg = FundBgUtils.getBgDimensionMember(number, name);
        if (col == null || col.isEmpty()) {
            return bg;
        }
        if (col.get(0).getExistsDimNum() == null) {
            return bg;
        }
        String[] srcNumArr = col.get(0).getExistsDimNum().split(COMMA);
        FundBgUtils.delBillDim(bg, srcNumArr);
        if (FundBgUtils.isNull(bg)) {
            return null;
        }
        return bg;
    }

    public static boolean isNull(BgDimensionMember bg) {
        return bg == null || bg.getNumber() == null || "".equals(bg.getNumber().trim());
    }

    public static FilterInfo getBgDimensionFilter(DimensionSourceInfo source, FilterInfo filter, String orgId) {
        if (filter == null) {
            filter = new FilterInfo();
        }
        if ("T_BD_AccountBanks".equalsIgnoreCase(source.getSrcTable())) {
            ConvertUtils.FILTER(filter, ConvertUtils.FITEM("COMPANY.id", orgId), ConvertUtils.FITEM("isClosed", 0));
            return filter;
        }
        if ("T_BD_Customer".equalsIgnoreCase(source.getSrcTable())) {
            ConvertUtils.FILTER(filter, ConvertUtils.FITEM("USEDSTATUS", 1), ConvertUtils.FITEM("id in ( select FCUSTOMERID from T_BD_CustomerCompanyInfo where FCOMORGID = '" + orgId + "' and FUSINGSTATUS=0 )"), ConvertUtils.FITEM("id in ( SELECT cd.FCUSTOMERID FROM  T_BD_CustomerGroupDetail cd, T_BD_CSSPGroupStandard cs where cd.FCUSTOMERGROUPSTANDARDID = cs.fid and cs.FIsBasic = 1 ) "));
            return filter;
        }
        if ("T_BD_Supplier".equalsIgnoreCase(source.getSrcTable())) {
            ConvertUtils.FILTER(filter, ConvertUtils.FITEM("USEDSTATUS", 1), ConvertUtils.FITEM("id in ( select FSUPPLIERID from T_BD_SupplierCompanyInfo where FCOMORGID = '" + orgId + "' and FUSINGSTATUS=0 )"));
            return filter;
        }
        if ("T_BD_Material".equalsIgnoreCase(source.getSrcTable())) {
            ConvertUtils.FILTER(filter, ConvertUtils.FITEM("id in ( select FMATERIALID from T_BD_MaterialCompanyInfo where FCOMPANYID = '" + orgId + "' and FStatus=1 )"));
            return filter;
        }
        return filter;
    }

    public static FmBgCtrlCombRelationCollection getCombRelCol(FundFlowItemInfo fInfo, String companyId, CoreUI ui) {
        if (fInfo == null) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("company.id", (Object)companyId);
        filter.appendFilterItem("fundFlowItem.id", (Object)fInfo.getId().toString());
        filter.appendFilterItem("bizBill.boName", (Object)FundBgUtils.getBoName(ui));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("entry.dimsrc.*");
        view.setSelector(sic);
        try {
            return FmBgCtrlCombRelationFactory.getRemoteInstance().getFmBgCtrlCombRelationCollection(view);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
            return null;
        }
    }

    protected static List<SourceDisplayInfo> getBgSource(FundFlowItemInfo fInfo, String companyId, CoreUI ui) {
        try {
            DimensionSourceCollection col = new DimensionSourceCollection();
            DimensionClientHelper.loadSourceNameInfo((DimensionSourceCollection)col);
            ArrayList<SourceDisplayInfo> ret = new ArrayList<SourceDisplayInfo>();
            for (int i = 0; i < col.size(); ++i) {
            }
            return ret;
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
            return null;
        }
    }

    protected static String getBoName(CoreUI ui) {
        Class<?> clz = ui.getClass().getSuperclass();
        Field field = null;
        try {
            field = clz.getDeclaredField("editData");
            field.setAccessible(true);
            String name = field.get(ui).getClass().getName();
            return FundBgUtils.convert(name);
        }
        catch (Exception e) {
            try {
                Object obj;
                Method method = FundBgUtils.getMethod(ui.getClass());
                if (method != null && (obj = method.invoke((Object)ui, new Object[0])) != null) {
                    String name = obj.getClass().getName();
                    return FundBgUtils.convert(name);
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
            return null;
        }
    }

    public static Method getMethod(Class<?> clz) throws SecurityException, NoSuchMethodException {
        while (clz != null) {
            if (clz.getMethod("getDataObject", new Class[0]) != null) {
                return clz.getMethod("getDataObject", new Class[0]);
            }
            clz = clz.getSuperclass();
        }
        return null;
    }

    protected static String convert(String name) {
        StringBuilder sb = new StringBuilder();
        sb.append(name.substring(0, name.lastIndexOf("."))).append(".app").append(name.substring(name.lastIndexOf("."), name.length())).toString();
        return sb.substring(0, sb.length() - 4);
    }

    public static String[] getMbgComb(IFmMbgUsed info, FundFlowItemInfo fInfo, String companyId, CoreUI ui, BgDimensionMember bg, int rowIndex) {
        long start = System.currentTimeMillis();
        String[] arr = new String[2];
        if (fInfo == null) {
            return arr;
        }
        logger.info((Object)("########getMbgComb.cost: " + (System.currentTimeMillis() - start) + "ms########"));
        return arr;
    }

    public static void delBillDim(BgDimensionMember bg, String[] srcNumArr) {
        if (srcNumArr == null || bg == null) {
            return;
        }
        List<String> srcNumList = Arrays.asList(srcNumArr);
        String[] srcNums = bg.getSrcNumber().split(COMMA);
        String[] numbers = bg.getNumber().split(COMMA);
        String[] names = bg.getName().split(COMMA);
        for (int i = 0; i < srcNums.length; ++i) {
            if (!srcNumList.contains(srcNums[i])) continue;
            srcNums[i] = null;
            numbers[i] = null;
            names[i] = null;
        }
        bg.setSrcNumber(ConvertUtils.Join(COMMA, srcNums));
        bg.setNumber(ConvertUtils.Join(COMMA, numbers));
        bg.setName(ConvertUtils.Join(COMMA, names));
    }

    public static String[] addBillDim(BgDimensionMember bg, IFmMbgUsed info, CoreUI ui, int rowIndex, String[] srcNumArr, String[] nameArr) {
        String[] arr = new String[2];
        StringBuilder sbNumber = new StringBuilder();
        StringBuilder sbName = new StringBuilder();
        for (int i = 0; i < srcNumArr.length; ++i) {
            String srcNum;
            String boName = FundBgUtils.getBoName(ui);
            IObjectValue objValue = FundBgUtils.getDimValue(info, boName, srcNum = srcNumArr[i], rowIndex);
            if (objValue != null && objValue.get("number") != null) {
                sbNumber.append(srcNumArr[i]).append(COLON).append(objValue.get("number")).append(COMMA);
            }
            if (objValue == null || objValue.get("name") == null) continue;
            sbName.append(nameArr[i]).append(COLON).append(objValue.get("name")).append(COMMA);
        }
        if (FundBgUtils.getMbgNumber(bg) == null) {
            if (sbNumber.length() > 0) {
                arr[0] = sbNumber.delete(sbNumber.length() - 1, sbNumber.length()).toString();
                arr[1] = sbName.delete(sbName.length() - 1, sbName.length()).toString();
            }
        } else {
            arr[0] = sbNumber.append(FundBgUtils.getMbgNumber(bg)).toString();
            arr[1] = sbName.append(FundBgUtils.getMbgName(bg)).toString();
        }
        return arr;
    }

    private static IObjectValue getDimValue(IFmMbgUsed info, String boName, String srcNum, int rowIndex) {
        IObjectValue objValue = null;
        try {
            FmBgCtrlCombRelHandler.Key key = new FmBgCtrlCombRelHandler.Key(boName, srcNum);
            if (FmBgCtrlCombRelHandler.fieldMap.containsKey(key)) {
                String[] fields = ((String)FmBgCtrlCombRelHandler.fieldMap.get(key)).split("\\.");
                objValue = FundBgUtils.getValue(info, fields, 0, rowIndex);
                FundBgUtils.fillAttribute(objValue);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return objValue;
    }

    private static IObjectValue getValue(IObjectValue objValue, String[] fields, int index, int rowIndex) throws EASBizException, BOSException {
        if (objValue == null) {
            return null;
        }
        if (objValue.get(fields[index]) == null) {
            return null;
        }
        if (objValue.get(fields[index]) instanceof IObjectValue) {
            objValue = (IObjectValue)objValue.get(fields[index]);
        } else if (objValue.get(fields[index]) instanceof IObjectCollection) {
            IObjectCollection objCol = (IObjectCollection)objValue.get(fields[index]);
            objValue = objCol.getObject(rowIndex);
        } else if (objValue.get(fields[index]) instanceof String) {
            String id = (String)objValue.get(fields[index]);
            objValue = EJBAccessFactory.createRemoteInstance().getEntityInfo(id);
        } else {
            return null;
        }
        if (index == fields.length - 1) {
            return objValue;
        }
        return FundBgUtils.getValue(objValue, fields, index + 1, rowIndex);
    }

    public static void fillAttribute(IObjectValue objValue) throws EASBizException, BOSException {
        if (objValue == null || objValue.get("id") == null) {
            return;
        }
        if (objValue.get("number") != null && objValue.get("name") != null) {
            return;
        }
        CoreBaseInfo coreBase = EJBAccessFactory.createRemoteInstance().getEntityInfo(objValue.get("id").toString());
        objValue.setString("number", coreBase.getString("number"));
        objValue.setString("name", coreBase.getString("name"));
    }

    public static int getParam(String paramNumber, String companyId) {
        return ContextHelperFactory.getRemoteInstance().getIntParam(paramNumber, (IObjectPK)new ObjectUuidPK(companyId));
    }

    public static BgControlSchemeInfo queryControlScheme(IObjectValue model, String bizUnit, String OUID) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)bizUnit) || StringUtils.isEmpty((String)OUID)) {
            throw new BgControlException(BgControlException.BIZOROUIDERROR);
        }
        String bizStr = BgControlSchemeFacadeFactory.getRemoteInstance().getDefaultBizUnit(bizUnit, 4);
        if (StringUtils.isEmpty((String)bizStr)) {
            throw new BgControlException(BgControlException.NOFOUNDDEFAULTBIZ);
        }
        Object bizValue = BgControlUtils.getBillBizValue(null, (String)bizStr, (IObjectValue)model);
        Timestamp timestamp = FundBgUtils.checkDefaultBizDateValue(bizValue);
        return FundBgUtils.queryControlScheme(bizUnit, OUID, timestamp);
    }

    private static Timestamp checkDefaultBizDateValue(Object bizValue) throws EASBizException {
        if (bizValue == null) {
            throw new BgControlException(BgControlException.NOFOUNDDEFAULTBIZ);
        }
        Timestamp timestamp = null;
        if (bizValue instanceof Timestamp) {
            timestamp = (Timestamp)bizValue;
        } else if (bizValue instanceof Date) {
            timestamp = new Timestamp(((Date)bizValue).getTime());
        }
        if (timestamp == null) {
            throw new BgControlException(BgControlException.NOFOUNDDEFAULTBIZ);
        }
        return timestamp;
    }

    private static BgControlSchemeInfo queryControlScheme(String bizUnit, String OUID, Timestamp timestamp) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)OUID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bizUnit", (Object)bizUnit, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isValid", (Object)Boolean.TRUE, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)timestamp, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)timestamp, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isSysDefault", (Object)Boolean.FALSE, CompareType.EQUALS));
        view.setFilter(filter);
        view.getSelector().addObjectCollection((IObjectCollection)FundBgUtils.getSelector());
        BgControlSchemeCollection colls = BgControlSchemeFactory.getRemoteInstance().getBgControlSchemeCollection(view);
        if (colls != null && colls.size() > 0) {
            return colls.get(0);
        }
        return null;
    }

    public static SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("orgUnit.id");
        sic.add("orgUnit.name");
        sic.add("orgUnit.number");
        sic.add("bizSystem");
        sic.add("bizSystemAlias");
        sic.add("bizUnit");
        sic.add("bizUnitAlias");
        sic.add("isValid");
        sic.add("beginDate");
        sic.add("endDate");
        sic.add("isSysDefault");
        sic.add("parentID");
        sic.add("rootID");
        sic.add("base.id");
        sic.add("base.isAllowAccess");
        sic.add("base.isCtrlOfEmpty");
        sic.add("rule.id");
        sic.add("rule.seq");
        sic.add("rule.orgUnit");
        sic.add("rule.orgUnitAlias");
        sic.add("rule.dimItem");
        sic.add("rule.dimItemAlias");
        sic.add("rule.currency");
        sic.add("rule.currencyAlias");
        sic.add("rule.periodType");
        sic.add("rule.bizDate");
        sic.add("rule.bizDateAlias");
        sic.add("rule.bgElementNumber");
        sic.add("rule.bgScenarioNumber");
        sic.add("rule.requestAmount");
        sic.add("rule.requestAmountAlias");
        sic.add("rule.requestAmountEx");
        sic.add("rule.ruleCondition");
        sic.add("rule.ruleConditionAlias");
        sic.add("rule.parentID");
        sic.add("rule.limitValue");
        sic.add("rule.bgSchemeType.id");
        sic.add("rule.bgSchemeType.name");
        sic.add("rule.bgSchemeType.number");
        sic.add("rule.bgPeriodType.id");
        sic.add("rule.bgPeriodType.number");
        sic.add("rule.bgPeriodType.name");
        sic.add("rule.bgPeriodType.fiscalYear");
        sic.add("itemMaps.id");
        sic.add("itemMaps.bizProp");
        sic.add("itemMaps.entry.id");
        sic.add("itemMaps.entry.bizItemValue");
        sic.add("itemMaps.entry.bizItemAlias");
        sic.add("itemMaps.entry.mbgItemValue");
        sic.add("itemMaps.entry.mbgItemAlias");
        sic.add("itemMaps.entry.matching");
        return sic;
    }

    public static void checkBgDimension(IFmMbgUsed info, FundFlowItemInfo fInfo, String companyId, CoreUI ui, int rowIndex, ICell extendCell) throws BOSException, EASBizException {
        long start = System.currentTimeMillis();
        String boName = FundBgUtils.getBoName(ui);
        if (REC.equals(boName) ? FundBgUtils.getParam("CS042", companyId) == 0 : (PAY.equals(boName) ? FundBgUtils.getParam("CS043", companyId) == 0 : !FmMbgHelper.isCtrl(null, info.getBOSType(), companyId))) {
            return;
        }
        BgControlSchemeInfo strategyInfo = FundBgUtils.queryControlScheme(info, boName, companyId);
        if (strategyInfo == null) {
            return;
        }
        BgControlRuleInfo ruleInfo = strategyInfo.getRule().get(0);
        if (!ruleInfo.getDimItem().contains("bgDimNum")) {
            return;
        }
        FmBgCtrlCombRelationCollection col = FundBgUtils.getCombRelCol(fInfo, companyId, ui);
        if (col == null || col.isEmpty() || col.get(0).getExistsDimNum() == null) {
            return;
        }
        String[] srcNumArr = col.get(0).getExistsDimNum().split(COMMA);
        for (int i = 0; i < srcNumArr.length; ++i) {
            String srcNum = srcNumArr[i];
            IObjectValue objValue = FundBgUtils.getDimValue(info, boName, srcNum, rowIndex);
            if (objValue != null) continue;
            MsgBox.showWarning((String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"1084_FundBgUtils"), ResourceBase.getString((String)FundBgUtils.getResMap().get(srcNum), (Locale)Locale.getDefault())));
            SysUtil.abort();
        }
        if (extendCell != null && extendCell.getValue() == null && col.get(0).getEntry().size() > 0 && ruleInfo.getDimItem().contains(".mbgNumber")) {
            extendCell.getStyleAttributes().setLocked(false);
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"1085_FundBgUtils"));
            SysUtil.abort();
        }
        logger.info((Object)("########checkBgDimension.cost: " + (System.currentTimeMillis() - start) + "ms########"));
    }

    public static Map<String, String> getResMap() {
        HashMap<String, String> resMap = new HashMap<String, String>();
        resMap.put("Act", "com.kingdee.eas.ma.fm.client.FmClientResource.BankAccount");
        resMap.put("Ban", "com.kingdee.eas.ma.fm.client.FmClientResource.Bank");
        resMap.put("Set", "com.kingdee.eas.ma.fm.client.FmClientResource.SettleType");
        resMap.put("Pro", "com.kingdee.eas.ma.fm.client.FmClientResource.Project");
        resMap.put("Fee", "com.kingdee.eas.ma.fm.client.FmClientResource.FeeType");
        resMap.put("Cus", "com.kingdee.eas.ma.fm.client.FmClientResource.Customer");
        resMap.put("Sup", "com.kingdee.eas.ma.fm.client.FmClientResource.Supplier");
        return resMap;
    }

    static class NameComparator
    extends SrcNumComparator {
        NameComparator() {
        }

        @Override
        public int compare(String str1, String str2) {
            if (str1 == null || str2 == null) {
                return 0;
            }
            String name1 = str1.split(FundBgUtils.COLON)[0];
            String name2 = str2.split(FundBgUtils.COLON)[0];
            if (nameRef.get(name1) == null || nameRef.get(name2) == null) {
                return 0;
            }
            Integer refField1 = Integer.valueOf(((String)nameRef.get(name1)).replaceAll("F", ""));
            Integer refField2 = Integer.valueOf(((String)nameRef.get(name2)).replaceAll("F", ""));
            return refField1.compareTo(refField2);
        }
    }

    static class SrcNumComparator
    implements Comparator<String> {
        protected static final Map<String, String> srcNumRef = new HashMap<String, String>();
        protected static final Map<String, String> nameRef = new HashMap<String, String>();

        SrcNumComparator() {
        }

        @Override
        public int compare(String str1, String str2) {
            if (str1 == null || str2 == null) {
                return 0;
            }
            String srcNum1 = str1.split(FundBgUtils.COLON)[0];
            String srcNum2 = str2.split(FundBgUtils.COLON)[0];
            if (srcNumRef.get(srcNum1) == null || srcNumRef.get(srcNum2) == null) {
                return 0;
            }
            Integer refField1 = Integer.valueOf(srcNumRef.get(srcNum1).replaceAll("F", ""));
            Integer refField2 = Integer.valueOf(srcNumRef.get(srcNum2).replaceAll("F", ""));
            return refField1.compareTo(refField2);
        }

        static {
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("srcNumber");
            sic.add("dimension.name");
            sic.add("dimension.refField");
            view.setSelector(sic);
            DimensionSourceCollection col = null;
            try {
                col = DimensionSourceFactory.getRemoteInstance().getDimensionSourceCollection(view);
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            for (int i = 0; i < col.size(); ++i) {
                srcNumRef.put(col.get(i).getSrcNumber(), col.get(i).getDimension().getRefField());
                nameRef.put(col.get(i).getDimension().getName(), col.get(i).getDimension().getRefField());
            }
        }
    }
}

