/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Color;
import java.math.BigDecimal;

public class KDTableTotalRowUtil {
    private KDTable table;
    private String[] columnNames;
    private static final String COMMONRESOURCE = "com.kingdee.eas.fm.common.client.FMCommonClientResource";

    public KDTableTotalRowUtil(KDTable table, String[] columnNames) {
        this.table = table;
        this.columnNames = columnNames;
    }

    public void resetTotalRow() {
        this.addTotalRow();
        int idx = this.locateTotalRow();
        IRow totalRow = this.table.getRow(idx);
        for (int i = 0; i < this.columnNames.length; ++i) {
            totalRow.getCell(this.columnNames[i]).setValue((Object)this.calculate(this.columnNames[i]));
        }
    }

    public void resetTotalRow(boolean defaultStyle) {
        this.addTotalRow(defaultStyle);
        int idx = this.locateTotalRow();
        IRow totalRow = this.table.getRow(idx);
        for (int i = 0; i < this.columnNames.length; ++i) {
            totalRow.getCell(this.columnNames[i]).setValue((Object)this.calculate(this.columnNames[i]));
        }
    }

    private BigDecimal calculate(String columnName) {
        int rowCount = this.table.getRowCount();
        BigDecimal sum = Constants.ZERO;
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.table.getRow(i);
            if (row.getStyleAttributes().getBackground().equals(new Color(0xF6F6B6))) continue;
            sum = FMHelper.add(sum, (BigDecimal)row.getCell(columnName).getValue());
        }
        return sum;
    }

    private void addTotalRow() {
        int idx = this.locateTotalRow();
        if (idx == -1) {
            IRow totalRow = this.table.addRow();
            totalRow.getStyleAttributes().setBackground(new Color(0xF6F6B6));
            totalRow.getStyleAttributes().setLocked(true);
            totalRow.getCell(0).setValue((Object)EASResource.getString((String)COMMONRESOURCE, (String)"total"));
            totalRow.getCell(0).getStyleAttributes().setBold(true);
            totalRow.getCell(0).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
        }
    }

    private void addTotalRow(boolean defaultStyle) {
        int idx = this.locateTotalRow();
        if (idx == -1) {
            IRow totalRow = this.table.addRow();
            totalRow.getStyleAttributes().setBackground(new Color(0xF6F6B6));
            totalRow.getStyleAttributes().setLocked(true);
            totalRow.getCell(0).setValue((Object)EASResource.getString((String)COMMONRESOURCE, (String)"total"));
        }
    }

    public void removeTotalRow() {
        int idx = this.locateTotalRow();
        if (idx != -1) {
            this.table.removeRow(idx);
        }
    }

    private int locateTotalRow() {
        int rowCount = this.table.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.table.getRow(i);
            if (!row.getStyleAttributes().getBackground().equals(new Color(0xF6F6B6))) continue;
            return i;
        }
        return -1;
    }

    public int locateLastRow() {
        int rowCount = this.table.getRowCount();
        int lastRow = -1;
        int i = 0;
        while (i < rowCount) {
            IRow row = this.table.getRow(i);
            if (row.getStyleAttributes().getBackground().equals(new Color(0xF6F6B6))) {
                return i - 1;
            }
            lastRow = i++;
        }
        return lastRow;
    }

    public IRow getLastRow() {
        int lastRow = this.locateLastRow();
        return lastRow >= 0 ? this.table.getRow(lastRow) : null;
    }
}

