/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.IOrgStructure;
import com.kingdee.eas.basedata.org.NewOrgViewFacadeFactory;
import com.kingdee.eas.basedata.org.OUException;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.client.EASResource;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class LayerTreeHelper {
    private KDTree treeOrigin;
    private KDTree treeSelected;
    private String[] companyIds;
    private IMetaDataPK metaDataPK;
    private IMetaDataPK actionPK;

    public LayerTreeHelper(KDTree treeOrigin, KDTree treeSelected, String[] companyIds, IMetaDataPK metaDataPK, IMetaDataPK actionPK) {
        this.treeOrigin = treeOrigin;
        this.treeSelected = treeSelected;
        this.companyIds = companyIds;
        this.metaDataPK = metaDataPK;
        this.actionPK = actionPK;
    }

    public void init() throws EASBizException, BOSException {
        this.addAllKingdeeTreeListener();
        this.initFirstLayerTree();
        this.treeSelected.setModel((TreeModel)((Object)new LayerKingdeeTreeModel((TreeNode)new KDTreeNode((Object)"hideNode"))));
        this.treeSelected.setRootVisible(false);
        this.treeSelected.setShowsRootHandles(true);
    }

    private void initFirstLayerTree() throws BOSException, EASBizException {
        CtrlUnitInfo cuInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        if (cuInfo == null) {
            throw new OUException(OUException.CU_CAN_NOT_NULL);
        }
        IOrgStructure istruct = OrgStructureFactory.getRemoteInstance();
        OrgStructureInfo rootInfo = istruct.getOrgStructureInfo("select id,longnumber,isLeaf,unit.id,unit.name where unit.id = '" + cuInfo.getId().toString() + "' and tree.id = '" + "00000000-0000-0000-0000-0000000000024F2827FD" + "'");
        DefaultKingdeeTreeNode rootNode = new DefaultKingdeeTreeNode((Object)rootInfo);
        this.treeOrigin.setModel((TreeModel)((Object)new LayerKingdeeTreeModel((TreeNode)rootNode)));
        this.loadOneLayerByLeftTree(rootNode, true);
        this.treeOrigin.updateUI();
    }

    private void addAllKingdeeTreeListener() {
        this.treeOrigin.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent event) {
                DefaultKingdeeTreeNode selectedNode = (DefaultKingdeeTreeNode)event.getPath().getLastPathComponent();
                try {
                    LayerTreeHelper.this.loadOneLayerByLeftTree(selectedNode, true);
                }
                catch (Exception e) {
                    throw new RuntimeException(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"140_LayerTreeHelper"), e);
                }
            }
        });
        this.treeOrigin.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                DefaultKingdeeTreeNode selectedNode = (DefaultKingdeeTreeNode)event.getPath().getLastPathComponent();
                try {
                    LayerTreeHelper.this.loadOneLayerByLeftTree(selectedNode, true);
                }
                catch (Exception e) {
                    throw new RuntimeException(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"140_LayerTreeHelper"), e);
                }
            }
        });
        this.treeSelected.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent event) {
                DefaultKingdeeTreeNode selectedNode = (DefaultKingdeeTreeNode)event.getPath().getLastPathComponent();
                try {
                    LayerTreeHelper.this.loadOneLayerByLeftTree(selectedNode, false);
                }
                catch (Exception e) {
                    throw new RuntimeException(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"140_LayerTreeHelper"), e);
                }
            }
        });
        this.treeSelected.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                DefaultKingdeeTreeNode selectedNode = (DefaultKingdeeTreeNode)event.getPath().getLastPathComponent();
                try {
                    LayerTreeHelper.this.loadOneLayerByLeftTree(selectedNode, false);
                }
                catch (Exception e) {
                    throw new RuntimeException(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"140_LayerTreeHelper"), e);
                }
            }
        });
    }

    private void loadOneLayerByLeftTree(DefaultKingdeeTreeNode selectedNode, boolean isByLeftTree) throws BOSException, EASBizException {
        if (selectedNode == null) {
            return;
        }
        OrgStructureInfo selectedInfo = (OrgStructureInfo)selectedNode.getUserObject();
        if (selectedInfo.getBoolean("isChildLoaded") || selectedInfo.isIsLeaf()) {
            return;
        }
        DefaultKingdeeTreeNode leftTreeSelectedNode = null;
        if (!isByLeftTree && (leftTreeSelectedNode = this.findByOrgStructureInfo((DefaultKingdeeTreeNode)this.treeOrigin.getModel().getRoot(), selectedInfo)) == null) {
            return;
        }
        List childNodes = NewOrgViewFacadeFactory.getRemoteInstance().getViewDirectChildNodesByUIPKAndActionPK("00000000-0000-0000-0000-0000000000024F2827FD", selectedInfo, this.metaDataPK, this.actionPK);
        Collections.sort(childNodes, new Comparator<OrgStructureInfo>(){

            @Override
            public int compare(OrgStructureInfo o1, OrgStructureInfo o2) {
                return o1.getLongNumber().compareTo(o2.getLongNumber());
            }
        });
        for (OrgStructureInfo childInfo : childNodes) {
            selectedNode.add((MutableTreeNode)new DefaultKingdeeTreeNode((Object)childInfo));
            if (isByLeftTree) continue;
            leftTreeSelectedNode.add((MutableTreeNode)new DefaultKingdeeTreeNode((Object)childInfo));
        }
        selectedInfo.setBoolean("isChildLoaded", true);
    }

    private DefaultKingdeeTreeNode findByOrgStructureInfo(DefaultKingdeeTreeNode node, OrgStructureInfo orgStructureInfo) {
        OrgStructureInfo nodeOrgStructureInfo;
        if (node == null || orgStructureInfo == null) {
            return null;
        }
        if (node.getUserObject() instanceof OrgStructureInfo && (nodeOrgStructureInfo = (OrgStructureInfo)node.getUserObject()).getId().equals((Object)orgStructureInfo.getId())) {
            return node;
        }
        Enumeration it = node.children();
        while (it.hasMoreElements()) {
            DefaultKingdeeTreeNode childNode = (DefaultKingdeeTreeNode)it.nextElement();
            DefaultKingdeeTreeNode findResult = this.findByOrgStructureInfo(childNode, orgStructureInfo);
            if (findResult == null) continue;
            return findResult;
        }
        return null;
    }

    class LayerKingdeeTreeModel
    extends KingdeeTreeModel {
        private static final long serialVersionUID = 1L;

        public LayerKingdeeTreeModel(TreeNode root) {
            super(root);
        }

        public boolean isLeaf(Object node) {
            DefaultKingdeeTreeNode tmpNode = (DefaultKingdeeTreeNode)node;
            if (tmpNode.getUserObject() instanceof CoreBaseInfo) {
                CoreBaseInfo info = (CoreBaseInfo)tmpNode.getUserObject();
                if (tmpNode.getChildCount() > 0) {
                    return false;
                }
                return info == null || info.get("isleaf") != null && (Boolean)info.get("isleaf") == true;
            }
            return false;
        }
    }
}

