/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fm.common.IUserOption;
import com.kingdee.eas.fm.common.UserOptionCollection;
import com.kingdee.eas.fm.common.UserOptionFactory;
import com.kingdee.eas.fm.common.UserOptionInfo;
import com.kingdee.eas.fm.common.UserOptionUtil;
import com.kingdee.eas.fm.common.client.AbstractMultiUserOptionUI;
import com.kingdee.eas.fm.common.client.UserOptionNameUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.Date;
import java.util.Map;
import javax.swing.Icon;

public abstract class MultiUserOptionUI
extends AbstractMultiUserOptionUI {
    public UserOptionInfo currentOption = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.refreshSolutionList();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAddNew.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnDelete.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnEdit.setIcon(EASResource.getIcon((String)"imgTbtn_edit"));
        this.btnAddNew.setText("");
        this.btnSave.setText("");
        this.btnDelete.setText("");
        this.btnEdit.setText("");
    }

    public void refreshSolutionList() throws Exception {
        this.list.removeAllElements();
        IUserOption userOption = UserOptionFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        UserInfo userInfo = ContextHelperFactory.getRemoteInstance().getCurrentUser();
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        fi.getFilterItems().add(new FilterItemInfo("company", (Object)companyInfo.getId().toString()));
        fi.getFilterItems().add(new FilterItemInfo("optKey", (Object)this.getMetaDataPK().getFullName()));
        evi.setFilter(fi);
        UserOptionCollection userOptionCollection = userOption.getUserOptionCollection(evi);
        UserOptionInfo userOptionInfo = null;
        Icon icon = EASResource.getIcon((String)"imgTree_public");
        int size = userOptionCollection.size();
        for (int i = 0; i < size; ++i) {
            userOptionInfo = userOptionCollection.get(i);
            this.list.addElement((Object)userOptionInfo);
            this.list.setElementIcon(icon, i);
        }
        if (userOptionCollection.size() > 0) {
            this.list.setSelectedValue((Object)userOptionCollection.get(0), true);
            this.currentOption = userOptionCollection.get(0);
            this.setOption(this.currentOption);
        } else {
            this.currentOption = null;
        }
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.btnConfirm_actionPerformed(e);
        this.disposeUIWindow();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.disposeUIWindow();
    }

    @Override
    protected void btnAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.btnAddNew_actionPerformed(e);
        this.initComponent();
        this.list.setSelectedIndex(-1);
    }

    @Override
    protected void btnEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.list.getElementCount() == 0) {
            return;
        }
        String name = UserOptionNameUI.showDialogWindows((IUIObject)this);
        if (name == null || name.length() == 0) {
            return;
        }
        UserOptionInfo userOptionInfo = (UserOptionInfo)this.list.getSelectedValue();
        userOptionInfo.setName(name);
        this.storeUserOption(userOptionInfo);
    }

    @Override
    protected void btnDelete_actionPerformed(ActionEvent e) throws Exception {
        if (this.list.getElementCount() == 0 || this.list.getSelectedValue() == null) {
            return;
        }
        if (MsgBox.isCancel((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")))) {
            return;
        }
        UserOptionInfo userOptionInfo = (UserOptionInfo)this.list.getSelectedValue();
        IUserOption userOption = UserOptionFactory.getRemoteInstance();
        userOption.delete((IObjectPK)new ObjectUuidPK(userOptionInfo.getId().toString()));
        this.refreshSolutionList();
    }

    @Override
    protected void btnSave_actionPerformed(ActionEvent e) throws Exception {
        this.verifyInput();
        String name = UserOptionNameUI.showDialogWindows((IUIObject)this);
        if (name == null || name.length() == 0) {
            return;
        }
        UserOptionInfo userOptionInfo = new UserOptionInfo();
        UserInfo userInfo = ContextHelperFactory.getRemoteInstance().getCurrentUser();
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        userOptionInfo.setName(name);
        userOptionInfo.setCreateUser(userInfo);
        userOptionInfo.setCreateDate(new Date());
        userOptionInfo.setCompany(companyInfo);
        userOptionInfo.setOptKey(this.getMetaDataPK().getFullName());
        userOptionInfo.setOptValue(UserOptionUtil.getUserOptionValue((Container)((Object)this), this.getComponentValue()));
        this.storeUserOption(userOptionInfo);
    }

    private void storeUserOption(UserOptionInfo userOptionInfo) throws Exception {
        IUserOption userOption = UserOptionFactory.getRemoteInstance();
        userOption.submit(userOptionInfo, true);
        this.refreshSolutionList();
    }

    protected Map getComponentValue() throws Exception {
        return null;
    }

    protected void setComponentValue(Map map) throws Exception {
    }

    @Override
    protected void list_mouseClicked(MouseEvent e) throws Exception {
        if (e.getClickCount() == 1) {
            if (this.list.getElementCount() == 0) {
                return;
            }
            UserOptionInfo userOptionInfo = (UserOptionInfo)this.list.getSelectedValue();
            this.setOption(userOptionInfo);
        }
    }

    private void setOption(UserOptionInfo userOption) throws Exception {
        Map map = UserOptionUtil.string2Map(userOption.getOptValue());
        UserOptionUtil.setUIStatus((Container)((Object)this), map);
        this.setComponentValue(map);
        this.currentOption = userOption;
    }

    private Map getUserOptionMap(String name) throws Exception {
        IUserOption userOption = UserOptionFactory.getRemoteInstance();
        return userOption.getUserOptionMap(this.getMetaDataPK().getFullName(), name);
    }

    protected abstract void initComponent() throws Exception;

    protected abstract void verifyInput() throws Exception;
}

