/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.client;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexLockType;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.FrameWorkClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.Uuid;
import java.util.List;

public class MutexUtils {
    public static void setMutex(CoreUI ui, String id) {
        try {
            ui.pubFireVOChangeListener(id);
        }
        catch (Throwable ex) {
            ui.handUIException(ex);
            SysUtil.abort();
        }
    }

    public static void releaseMutex(CoreUI ui) {
        try {
            ui.pubFireVOChangeListener(null);
        }
        catch (Throwable ex) {
            ui.handUIException(ex);
            SysUtil.abort();
        }
    }

    public static MutexParameter setMutexParameter(Uuid uuid, String mutexName, String actionName) {
        MutexParameter param = new MutexParameter();
        String dcName = SysContext.getSysContext().getDcName() != null ? SysContext.getSysContext().getDcName() : "";
        param.setDcName(dcName);
        param.setRequestId(uuid);
        param.setMutexName(mutexName);
        param.setActionName(actionName);
        param.setUserID(SysContext.getSysContext().getCurrentUserInfo().getId());
        param.setOrgUnitID(SysContext.getSysContext().getCurrentFIUnit().getId());
        param.setMutexLockType(MutexLockType.EXCLUSIVE_LOCK);
        return param;
    }

    public static void requestMutex(MutexParameter param) throws BOSException, EASBizException {
        IMutexServiceControl mutexService = MutexServiceControlFactory.getRemoteInstance();
        boolean isSuccess = mutexService.requestMutex(param);
        if (!isSuccess) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"69_MutexUtils"));
            SysUtil.abort();
        }
    }

    public static void setMutex(Uuid uuid, String mutexName, String actionName) throws EASBizException, BOSException {
        MutexParameter param = MutexUtils.setMutexParameter(uuid, mutexName, actionName);
        MutexUtils.requestMutex(param);
    }

    public static void releaseMutex(Uuid id) {
        IMutexServiceControl mutexService = MutexServiceControlFactory.getRemoteInstance();
        mutexService.releaseMutex(id);
    }

    public static void requestMutex(CoreUI ui, String id) {
        MutexUtils.setMutex(ui, id);
    }

    public static void requestMutex(CoreUI ui, String[] ids) {
        for (int i = 0; i < ids.length; ++i) {
            MutexUtils.setMutex(ui, ids[i]);
        }
    }

    public static void requestMutex(CoreUI ui, List ids) {
        for (String id : ids) {
            MutexUtils.setMutex(ui, id);
        }
    }

    public static void releaseMutex(String id) {
        IMutexServiceControl mutexServiceControl = FrameWorkClientUtils.createMutexServiceControl();
        mutexServiceControl.releaseObjIDForUpdate(id);
    }

    public static void releaseMutex(List ids) {
        for (String id : ids) {
            MutexUtils.releaseMutex(id);
        }
    }

    public static void releaseMutex(String[] ids) {
        for (int i = 0; i < ids.length; ++i) {
            MutexUtils.releaseMutex(ids[i]);
        }
    }
}

