/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;

public final class PeriodHelper {
    private static Map periodCache;

    public static void initPeriodSpinner(CompanyOrgUnitInfo companyInfo, KDSpinner beginYearSpinner, KDSpinner beginPeriodSpinner, SystemEnum systemEnum) throws EASBizException, BOSException {
        PeriodInfo currPeriod = FMClientHelper.getCurrentPeriod(null, companyInfo, systemEnum);
        beginYearSpinner.setModel((SpinnerModel)PeriodHelper.getYearSnm(companyInfo, systemEnum));
        beginPeriodSpinner.setModel((SpinnerModel)PeriodHelper.getMonthSnm(companyInfo, (Integer)beginYearSpinner.getValue(), systemEnum));
        if (currPeriod != null) {
            beginYearSpinner.setValue((Object)new Integer(currPeriod.getPeriodYear()));
            beginPeriodSpinner.setValue((Object)new Integer(currPeriod.getPeriodNumber()));
        }
    }

    public static SpinnerNumberModel getYearSnm(CompanyOrgUnitInfo companyInfo, SystemEnum systemEnum) throws EASBizException, BOSException {
        ObjectUuidPK companyPK = new ObjectUuidPK(companyInfo.getId());
        if (periodCache == null || !periodCache.containsKey(companyPK)) {
            PeriodHelper.cachePeriod(companyInfo, systemEnum);
        }
        TreeMap yearMap = (TreeMap)periodCache.get(companyPK);
        int begin = (Integer)yearMap.firstKey();
        int end = (Integer)yearMap.lastKey();
        PeriodInfo startPeriod = FMClientHelper.getStartPeriodInfo(null, companyInfo, systemEnum);
        begin = startPeriod.getPeriodYear();
        SpinnerNumberModel result = null;
        if (begin > end) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"375_PeriodHelper"));
            SysUtil.abort();
        } else {
            result = new SpinnerNumberModel(begin, begin, end, 1);
        }
        return result;
    }

    public static SpinnerNumberModel getMonthSnm(CompanyOrgUnitInfo companyInfo, Integer year, SystemEnum systemEnum) throws EASBizException, BOSException {
        ObjectUuidPK companyPK = new ObjectUuidPK(companyInfo.getId());
        if (periodCache == null || !periodCache.containsKey(companyPK)) {
            PeriodHelper.cachePeriod(companyInfo, systemEnum);
        }
        TreeMap yearMap = (TreeMap)periodCache.get(companyPK);
        PeriodCollection pc = (PeriodCollection)yearMap.get(year);
        int begin = 1;
        int end = 1;
        if (pc != null && pc.get(0) != null) {
            begin = pc.get(0).getPeriodNumber();
        }
        if (pc != null && pc.get(pc.size() - 1) != null) {
            end = pc.get(pc.size() - 1).getPeriodNumber();
        }
        SpinnerNumberModel result = new SpinnerNumberModel(begin, begin, end, 1);
        return result;
    }

    private static void cachePeriod(CompanyOrgUnitInfo companyInfo, SystemEnum systemEnum) throws EASBizException, BOSException {
        if (periodCache == null) {
            periodCache = new HashMap();
        }
        TreeMap<Integer, PeriodCollection> result = new TreeMap<Integer, PeriodCollection>();
        PeriodCollection pc = PeriodHelper.getPeriodc(companyInfo, systemEnum);
        for (PeriodInfo pi : pc) {
            PeriodCollection tmpPc;
            Integer year = new Integer(pi.getPeriodYear());
            if (!result.containsKey(year)) {
                tmpPc = new PeriodCollection();
                tmpPc.add(pi);
                result.put(year, tmpPc);
                continue;
            }
            tmpPc = (PeriodCollection)result.get(year);
            tmpPc.add(pi);
        }
        periodCache.put(new ObjectUuidPK(companyInfo.getId()), result);
    }

    private static PeriodCollection getPeriodc(CompanyOrgUnitInfo companyInfo, SystemEnum systemEnum) throws BOSException, EASBizException {
        if (companyInfo.getAccountPeriodType() == null || companyInfo.getAccountPeriodType().getId() == null) {
            ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getRemoteInstance();
            companyInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyInfo.getId()));
        }
        IPeriod iPeriod = PeriodFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)companyInfo.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
        evi.getSorter().add(new SorterItemInfo("periodYear"));
        evi.getSorter().add(new SorterItemInfo("periodNumber"));
        evi.setFilter(filter);
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        if (periodc == null || periodc.size() == 0) {
            return null;
        }
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)companyInfo)) {
            return periodc;
        }
        PeriodInfo startPeriod = FMClientHelper.getStartPeriodInfo(null, companyInfo, systemEnum);
        PeriodCollection rsltCols = new PeriodCollection();
        int n = periodc.size();
        for (int i = 0; i < n; ++i) {
            PeriodInfo periodInfo = periodc.get(i);
            if (!PeriodHelper.isAfterStartPeriod(startPeriod, periodInfo)) continue;
            rsltCols.add(periodInfo);
        }
        return rsltCols;
    }

    public static boolean isAfterStartPeriod(PeriodInfo startPeriod, PeriodInfo periodInfo) {
        if (startPeriod == null || periodInfo == null) {
            return false;
        }
        if (startPeriod.getPeriodYear() < periodInfo.getPeriodYear()) {
            return true;
        }
        return startPeriod.getPeriodYear() == periodInfo.getPeriodYear() && startPeriod.getPeriodNumber() <= periodInfo.getPeriodNumber();
    }

    public static void setPeriodNum(CompanyOrgUnitInfo companyInfo, KDSpinner spMonth, Integer year, SystemEnum systemEnum) throws EASBizException, BOSException {
        ObjectUuidPK companyPK = new ObjectUuidPK(companyInfo.getId());
        if (periodCache == null || !periodCache.containsKey(companyPK)) {
            PeriodHelper.cachePeriod(companyInfo, systemEnum);
        }
        int curValue = Integer.parseInt(spMonth.getValue().toString());
        TreeMap yearMap = (TreeMap)periodCache.get(companyPK);
        PeriodCollection pc = (PeriodCollection)yearMap.get(year);
        if (pc == null || pc != null && pc.size() < 1) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResource", (String)"CheckPeriodMsg"));
            SysUtil.abort();
        }
        int begin = pc.get(0).getPeriodNumber();
        int end = pc.get(pc.size() - 1).getPeriodNumber();
        SpinnerNumberModel model = null;
        model = curValue >= begin && curValue <= end ? new SpinnerNumberModel(curValue, begin, end, 1) : new SpinnerNumberModel(begin, begin, end, 1);
        spMonth.setModel((SpinnerModel)model);
    }

    public static SystemEnum getBeginDateSysEnumOf4(String companyId) throws EASBizException, BOSException {
        return PeriodHelper.getBeginOrEndDateEnum(true, companyId);
    }

    public static SystemEnum getEndDateSysEnumOf4(String companyId) throws EASBizException, BOSException {
        return PeriodHelper.getBeginOrEndDateEnum(false, companyId);
    }

    private static SystemEnum getBeginOrEndDateEnum(Boolean begin, String companyId) throws BOSException, EASBizException {
        ISystemStatusCtrol ictrol = SystemStatusCtrolFactory.getRemoteInstance();
        PeriodInfo ivtCurPeriodInfo = ictrol.getCacheCurrentPeriod(30, companyId);
        PeriodInfo ctlCurPeriodInfo = ictrol.getCacheCurrentPeriod(31, companyId);
        PeriodInfo finCurPeriodInfo = ictrol.getCacheCurrentPeriod(29, companyId);
        PeriodInfo ntCurPeriodInfo = ictrol.getCacheCurrentPeriod(28, companyId);
        HashMap<SystemEnum, PeriodInfo> perMap = new HashMap<SystemEnum, PeriodInfo>();
        Date beginDate = null;
        Date endDate = null;
        if (ivtCurPeriodInfo != null) {
            perMap.put(SystemEnum.IVT_MANAGE, ivtCurPeriodInfo);
            endDate = beginDate = ivtCurPeriodInfo.getBeginDate();
        }
        if (ctlCurPeriodInfo != null) {
            perMap.put(SystemEnum.CTL_MANAGE, ctlCurPeriodInfo);
            endDate = beginDate = ctlCurPeriodInfo.getBeginDate();
        }
        if (finCurPeriodInfo != null) {
            perMap.put(SystemEnum.FIN_MANAGE, finCurPeriodInfo);
            endDate = beginDate = finCurPeriodInfo.getBeginDate();
        }
        if (ntCurPeriodInfo != null) {
            perMap.put(SystemEnum.NT_MANAGEMENT, ntCurPeriodInfo);
            endDate = beginDate = ntCurPeriodInfo.getBeginDate();
        }
        SystemEnum sysEnum = null;
        if (perMap.size() > 0) {
            sysEnum = begin != false ? PeriodHelper.getBeginDateEnum(perMap, beginDate) : PeriodHelper.getEndDateEnum(perMap, endDate);
        }
        return sysEnum;
    }

    private static SystemEnum getBeginDateEnum(HashMap<SystemEnum, PeriodInfo> perMap, Date beginDate) {
        SystemEnum beginSysEnum = null;
        for (Map.Entry<SystemEnum, PeriodInfo> entry : perMap.entrySet()) {
            Date tmp = entry.getValue().getBeginDate();
            if (beginDate == null) {
                beginDate = tmp;
                beginSysEnum = entry.getKey();
                continue;
            }
            if (tmp.after(beginDate)) continue;
            beginDate = tmp;
            beginSysEnum = entry.getKey();
        }
        return beginSysEnum;
    }

    private static SystemEnum getEndDateEnum(HashMap<SystemEnum, PeriodInfo> perMap, Date endDate) {
        SystemEnum endSysEnum = null;
        for (Map.Entry<SystemEnum, PeriodInfo> entry : perMap.entrySet()) {
            Date tmp = entry.getValue().getBeginDate();
            if (endDate == null) {
                endDate = tmp;
                endSysEnum = entry.getKey();
                continue;
            }
            if (tmp.before(endDate)) continue;
            endDate = tmp;
            endSysEnum = entry.getKey();
        }
        return endSysEnum;
    }
}

