/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.client.PeriodHelper;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import java.util.Date;
import java.util.TreeMap;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PeriodRangeModel {
    KDSpinner spiBeginYear;
    KDSpinner spiBeginMonth;
    KDSpinner spiEndYear;
    KDSpinner spiEndMonth;
    TreeMap result = new TreeMap();

    public void init() {
        CompanyOrgUnitInfo curCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        PeriodCollection pc = FMClientHelper.getValidPeriodColl(curCompany);
        if (pc == null || pc.size() == 0) {
            // empty if block
        }
        this.result = FMClientHelper.periodAssembleMap(pc);
        this.initVaues(this.spiBeginYear, this.spiBeginMonth, this.spiEndYear, this.spiEndMonth);
        PeriodInfo curPeriod = null;
        if (!GlUtils.isCompanyUnion((CompanyOrgUnitInfo)curCompany)) {
            try {
                curPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)curCompany);
            }
            catch (Exception e) {
                SysUtil.abort((Throwable)e);
            }
        } else {
            try {
                curPeriod = PeriodUtils.getPeriodInfo((Date)new Date(), (CompanyOrgUnitInfo)curCompany);
            }
            catch (EASBizException e1) {
                SysUtil.abort((Throwable)e1);
            }
            catch (BOSException e1) {
                SysUtil.abort((Throwable)e1);
            }
        }
        this.spiEndMonth.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    PeriodRangeModel.this.spiEndMonth_stateChanged(e);
                }
                catch (Exception exception) {
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        });
        this.spiEndYear.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    PeriodRangeModel.this.spiEndYear_stateChanged(e);
                }
                catch (Exception exception) {
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        });
        this.spiBeginMonth.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PeriodRangeModel.this.spiBeginMonth_stateChanged(e);
            }
        });
        this.spiBeginYear.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PeriodRangeModel.this.spiBeginYear_stateChanged(e);
            }
        });
        if (curPeriod != null) {
            this.spiBeginYear.setValue((Object)new Integer(curPeriod.getPeriodYear()));
            this.spiBeginMonth.setValue((Object)new Integer(curPeriod.getPeriodNumber()));
            this.spiEndYear.setValue((Object)new Integer(curPeriod.getPeriodYear()));
            this.spiEndMonth.setValue((Object)new Integer(curPeriod.getPeriodNumber()));
        }
    }

    protected void spiBeginYear_stateChanged(ChangeEvent e) {
        PeriodHelper.periodChange((KDSpinner)this.spiBeginYear, (KDSpinner)this.spiBeginMonth, (KDSpinner)this.spiEndYear, (KDSpinner)this.spiEndMonth);
        this.setMonthModel(this.spiBeginMonth, (Integer)this.spiBeginYear.getValue());
    }

    protected void spiBeginMonth_stateChanged(ChangeEvent e) {
        PeriodHelper.periodChange((KDSpinner)this.spiBeginYear, (KDSpinner)this.spiBeginMonth, (KDSpinner)this.spiEndYear, (KDSpinner)this.spiEndMonth);
    }

    protected void spiEndMonth_stateChanged(ChangeEvent e) {
        PeriodHelper.periodChange((KDSpinner)this.spiBeginYear, (KDSpinner)this.spiBeginMonth, (KDSpinner)this.spiEndYear, (KDSpinner)this.spiEndMonth);
    }

    protected void spiEndYear_stateChanged(ChangeEvent e) {
        int yearFrom = Integer.parseInt(this.spiBeginYear.getValue().toString());
        int yearTo = Integer.parseInt(this.spiEndYear.getValue().toString());
        int numberFrom = Integer.parseInt(this.spiBeginMonth.getValue().toString());
        PeriodHelper.periodChange((KDSpinner)this.spiBeginYear, (KDSpinner)this.spiBeginMonth, (KDSpinner)this.spiEndYear, (KDSpinner)this.spiEndMonth);
        this.setMonthModel(this.spiEndMonth, (Integer)this.spiEndYear.getValue());
        if (yearFrom == yearTo) {
            this.spiEndMonth.setValue((Object)new Integer(numberFrom), false);
        }
    }

    private void initVaues(KDSpinner spiBeginYear, KDSpinner spiBeginMonth, KDSpinner spiEndYear, KDSpinner spiEndMonth) {
        int beginYear = (Integer)this.result.firstKey();
        int endYear = (Integer)this.result.lastKey();
        SpinnerNumberModel yearMo1 = new SpinnerNumberModel(beginYear, beginYear, endYear, 1);
        spiBeginYear.setModel((SpinnerModel)yearMo1);
        SpinnerNumberModel yearMo2 = new SpinnerNumberModel(beginYear, beginYear, endYear, 1);
        spiEndYear.setModel((SpinnerModel)yearMo2);
        this.setMonthModel(spiBeginMonth, beginYear);
        this.setMonthModel(spiEndMonth, beginYear);
    }

    private void setMonthModel(KDSpinner spi, int year) {
        PeriodCollection periodSubCo = (PeriodCollection)this.result.get(new Integer(year));
        int beginMonth = periodSubCo.get(0).getPeriodNumber();
        int endMonth = periodSubCo.get(periodSubCo.size() - 1).getPeriodNumber();
        SpinnerNumberModel monthMo1 = new SpinnerNumberModel(beginMonth, beginMonth, endMonth, 1);
        spi.setModel((SpinnerModel)monthMo1);
    }

    public KDSpinner getSpiBeginMonth() {
        return this.spiBeginMonth;
    }

    public void setSpiBeginMonth(KDSpinner spiBeginMonth) {
        this.spiBeginMonth = spiBeginMonth;
    }

    public KDSpinner getSpiBeginYear() {
        return this.spiBeginYear;
    }

    public void setSpiBeginYear(KDSpinner spiBeginYear) {
        this.spiBeginYear = spiBeginYear;
    }

    public KDSpinner getSpiEndMonth() {
        return this.spiEndMonth;
    }

    public void setSpiEndMonth(KDSpinner spiEndMonth) {
        this.spiEndMonth = spiEndMonth;
    }

    public KDSpinner getSpiEndYear() {
        return this.spiEndYear;
    }

    public void setSpiEndYear(KDSpinner spiEndYear) {
        this.spiEndYear = spiEndYear;
    }
}

