/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.client;

import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.client.AbstractSimpleNotePadUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Map;
import org.apache.log4j.Logger;

public class SimpleNotePadUI
extends AbstractSimpleNotePadUI {
    private static final Logger logger = CoreUIObject.getLogger(SimpleNotePadUI.class);
    private KDFileChooser fileChooser = new KDFileChooser();
    protected FileDialog fileDialog;
    private String txtMain = null;
    private int result = 2;
    private static final String MSG = "msg";

    public void setText(String txt) {
        this.txtMain = txt;
    }

    public String getText() {
        return this.txtMain;
    }

    public static IUIWindow showMessageByModel(UIContext uiCtx, String infoString) {
        IUIWindow uiWindow = null;
        try {
            uiCtx.put((Object)MSG, (Object)infoString);
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(SimpleNotePadUI.class.getName(), (Map)uiCtx, null);
        }
        catch (UIException uIException) {
            // empty catch block
        }
        if (uiWindow != null) {
            uiWindow.show();
        }
        return uiWindow;
    }

    public void onLoad() throws Exception {
        Object o;
        super.onLoad();
        if (this.getUIContext().get(MSG) != null) {
            String strMsg = (String)this.getUIContext().get(MSG);
            while (!StringUtils.isEmpty((String)strMsg) && strMsg.length() > 1 && (strMsg.substring(0, 1).equals("\r") || strMsg.substring(0, 1).equals("\n"))) {
                strMsg = strMsg.substring(2);
            }
            this.txtArea_Main.setText(strMsg);
            this.txtArea_Main.setSelectionStart(1);
            this.txtArea_Main.setSelectionEnd(1);
            this.txtArea_Main.setCaretPosition(0);
        }
        if (this.getUIContext().get("Title") != null) {
            this.setUITitle((String)this.getUIContext().get("Title"));
        }
        if ((o = this.getUIContext().get("ShowOpen")) != null && o instanceof Boolean && !((Boolean)o).booleanValue()) {
            this.btn_Open.setVisible(false);
        }
        this.btnOk.setEnabled(true);
        this.btnCancel.setEnabled(true);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btn_Open.setIcon(EASResource.getIcon((String)"imgTbtn_open"));
        this.btn_Save.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.result = 2;
        this.getUIWindow().close();
    }

    @Override
    public void actionOk_actionPerformed(ActionEvent e) throws Exception {
        this.result = 0;
        this.getUIWindow().close();
    }

    public int getResult() {
        return this.result;
    }

    @Override
    protected void btn_Exit_actionPerformed(ActionEvent e) throws Exception {
        this.result = 2;
        this.disposeUIWindow();
    }

    @Override
    protected void btn_New_actionPerformed(ActionEvent e) throws Exception {
        this.txtArea_Main.setText(null);
    }

    @Override
    protected void btn_Open_actionPerformed(ActionEvent e) throws Exception {
        int returnVal = this.fileChooser.showOpenDialog((Component)((Object)this));
        if (returnVal != 0) {
            return;
        }
        File f = this.fileChooser.getSelectedFile();
        if (f.exists()) {
            this.txtArea_Main.setText(null);
            this.setUITitle(f.getName());
            FileLoader loader = new FileLoader(f, this.txtArea_Main.getText());
            loader.setName("com.kingdee.eas.fi.gr.cslrpt.client.FileLoadThread");
            loader.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void btn_Save_actionPerformed(ActionEvent e) throws Exception {
        FileOutputStream fstrm = null;
        OutputStreamWriter out = null;
        try {
            int returnVal = this.fileChooser.showSaveDialog((Component)((Object)this));
            if (returnVal != 0) {
                return;
            }
            File file = this.fileChooser.getSelectedFile();
            fstrm = new FileOutputStream(file);
            out = new OutputStreamWriter(fstrm);
            out.write(this.txtArea_Main.getText().replaceAll("\n", "\r\n"));
            out.flush();
        }
        catch (IOException io) {
            logger.debug((Object)("IOException: " + io.getMessage()));
        }
        finally {
            if (fstrm != null) {
                fstrm.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    class FileLoader
    extends Thread {
        String str;
        File file;

        FileLoader(File f, String txtMain) {
            this.setPriority(4);
            this.file = f;
            this.str = txtMain;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            FileInputStream in = null;
            InputStreamReader inr = null;
            BufferedReader read = null;
            StringBuffer strbuff = new StringBuffer();
            try {
                in = new FileInputStream(this.file);
                inr = new InputStreamReader(in);
                read = new BufferedReader(inr);
                String tmp = null;
                while ((tmp = read.readLine()) != null) {
                    strbuff.append(tmp + "\n");
                }
                SimpleNotePadUI.this.txtArea_Main.setText(strbuff.toString());
            }
            catch (IOException e) {
                SimpleNotePadUI.this.handUIException(e);
            }
            finally {
                try {
                    if (read != null) {
                        read.close();
                    }
                    if (inr != null) {
                        inr.close();
                    }
                    if (in != null) {
                        ((InputStream)in).close();
                    }
                }
                catch (IOException e1) {
                    SimpleNotePadUI.this.handUIException(e1);
                }
            }
        }
    }
}

