/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.ISortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.FMIsqlFacadeFactory;
import com.kingdee.eas.fm.common.FMSuspensionAccountFilterParam;
import com.kingdee.eas.fm.common.TimeConditionsEnum;
import com.kingdee.eas.fm.common.client.AbstractSuspensionAccountUI;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.common.client.FMSuspensionAccountFilterUI;
import com.kingdee.eas.fm.common.client.SuspensionJournalList;
import com.kingdee.eas.framework.bireport.util.BirtUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

public class SuspensionAccountUI
extends AbstractSuspensionAccountUI {
    private static final Logger logger = CoreUIObject.getLogger(SuspensionAccountUI.class);
    FMSuspensionAccountFilterUI filterUI = null;
    private Map paramMap;
    private ISortManager sm = null;
    private String sort = "order by ACC ASC";
    private int sort_Account = 0;

    public SuspensionAccountUI() throws Exception {
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                SuspensionAccountUI.this.setListUITable(SuspensionAccountUI.this.tblMain, e);
            }
        });
    }

    public void setListUITable(KDTable tblMain, KDTDataRequestEvent e) {
        IRow row = null;
        for (int j = 0; j < tblMain.getRowCount(); ++j) {
            row = tblMain.getRow(j);
            row.getCell("amount").getStyleAttributes().setNumberFormat("###,##0.00\\%");
            row.getCell("amount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.actionView.setEnabled(true);
        this.actionViewDetail.setEnabled(true);
    }

    @Override
    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new FMSuspensionAccountFilterUI();
        }
        return this.filterUI;
    }

    @Override
    protected KDTable getMainTable() {
        this.tblMain.getIndexColumn().setWidthAdjustMode((short)0);
        return this.tblMain;
    }

    @Override
    protected void execQuery() throws BOSException {
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        FMSuspensionAccountFilterParam filterParam = (FMSuspensionAccountFilterParam)this.getFilterParam();
        if (filterParam == null) {
            return;
        }
        this.tblMain.checkParsed();
        this.tblMain.setEditable(false);
        this.tblMain.removeRows(true);
        this.kDDatePicker1.setValue((Object)filterParam.getSelectDate());
        if (filterParam.getCount() != 0) {
            this.kDTextField1.setText("" + filterParam.getTimeconditions().getAlias(SysContext.getSysContext().getLocale()) + EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"1086_SuspensionAccountUI") + filterParam.getCount() + "");
            this.actionViewDetail.setEnabled(true);
        } else {
            this.kDTextField1.setText("" + filterParam.getTimeconditions().getAlias(SysContext.getSysContext().getLocale()) + EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"1087_SuspensionAccountUI"));
            this.actionViewDetail.setEnabled(false);
        }
        this.kDTextField1.setEditable(false);
        IRowSet rs = this.getRowSet(filterParam);
        try {
            this.filldata(rs, filterParam);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 0 && e.getButton() == 1 && e.getClickCount() == 1) {
            this.sm = new KDTSortManager(this.tblMain);
            if (this.tblMain.getSortMange() != null) {
                this.tblMain.removeKDTMouseListener((KDTMouseListener)this.tblMain.getSortMange());
            }
            if (e.getType() == 0 && e.getColIndex() == 7) {
                if (this.sort_Account == 0) {
                    this.sm.sort(e.getColIndex(), 1);
                    this.sort = "Order by ACC DESC";
                    this.execQuery();
                    this.sort_Account = 1;
                    return;
                }
                if (this.sort_Account == 1) {
                    this.sm.sort(e.getColIndex(), 0);
                    this.sort = "Order by ACC ASC";
                    this.execQuery();
                    this.sort_Account = 0;
                    return;
                }
            }
            if (e.getType() == 0 && e.getColIndex() == 8) {
                if (this.sort_Account == 0) {
                    this.sm.sort(e.getColIndex(), 0);
                    this.sort = "Order by SS ASC";
                    this.execQuery();
                    this.sort_Account = 1;
                    return;
                }
                if (this.sort_Account == 1) {
                    this.sm.sort(e.getColIndex(), 1);
                    this.sort = "Order by SS DESC";
                    this.execQuery();
                    this.sort_Account = 0;
                    return;
                }
            }
            return;
        }
        super.tblMain_tableClicked(e);
    }

    public IRowSet getRowSet(FMSuspensionAccountFilterParam filterParam) throws BOSException {
        StringBuffer sql = new StringBuffer();
        String datesql = null;
        Date endDate = filterParam.getSelectDate();
        Date fromdDate = null;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(endDate);
        if (filterParam.getTimeconditions() == TimeConditionsEnum.halfYear) {
            calendar.add(2, -6);
        }
        if (filterParam.getTimeconditions() == TimeConditionsEnum.oneYear) {
            calendar.add(1, -1);
        }
        if (filterParam.getTimeconditions() == TimeConditionsEnum.twoYear || filterParam.getTimeconditions() == TimeConditionsEnum.overTwoYear) {
            calendar.add(1, -2);
        }
        fromdDate = calendar.getTime();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String defaultfromDate = sdf.format(fromdDate);
        String defaultEndDate = sdf.format(endDate);
        datesql = filterParam.getTimeconditions() == TimeConditionsEnum.overTwoYear ? " FBIZDATE <= {ts'" + defaultfromDate + "'}" : "FBIZDATE>={ts'" + defaultfromDate + "'} and FBIZDATE <= {ts'" + defaultEndDate + "'}";
        if (filterParam.getCount() == 0) {
            sql.append("select fid as FAccountBankID from  T_BD_AccountBanks where fid not in (select DISTINCT FACCOUNTBANKID from T_CAS_Journal where FACCOUNTBANKID in (");
            sql.append(" select FID  from T_BD_AccountBanks where FCOMPANYID in (" + BirtUtils.idListToInClause((Collection)filterParam.getCompanyid()) + ") and ");
            sql.append("" + datesql + "))");
            sql.append(" and FCOMPANYID in (" + BirtUtils.idListToInClause((Collection)filterParam.getCompanyid()) + ")");
        } else {
            sql.append("select * from (select FAccountBankID,count(FAccountBankID) as ACC,sum(FDebitAmount) as SDebitAmount,sum(FcreditAmount) as ScreditAmount,sum(FDebitAmount)+sum(FcreditAmount)");
            sql.append("as SS from T_CAS_Journal where FAccountBankID in( select FAccountBankID from   (select count(FAccountBankID) as ni,FAccountBankID from T_CAS_Journal where ");
            sql.append("" + datesql + "");
            sql.append(" and FAccountBankID in(select fid from T_BD_AccountBanks where");
            sql.append(" FCOMPANYID in (" + BirtUtils.idListToInClause((Collection)filterParam.getCompanyid()) + ") and FISCLOSED=0) GROUP BY FAccountBankID )");
            sql.append("as nm where nm.ni<" + filterParam.getCount() + ") and " + datesql + "  and FPeriodId is not null GROUP BY FAccountBankID ");
            sql.append(" union all select fid as FAccountBankID, 0 as ACC,0 as SDebitAmount,0 as ScreditAmount,0 as SS from  T_BD_AccountBanks where fid not in (select DISTINCT FACCOUNTBANKID from T_CAS_Journal where FACCOUNTBANKID in (");
            sql.append(" select FID  from T_BD_AccountBanks where FCOMPANYID in (" + BirtUtils.idListToInClause((Collection)filterParam.getCompanyid()) + ") and ");
            sql.append("" + datesql + "))");
            sql.append(" and FCOMPANYID in (" + BirtUtils.idListToInClause((Collection)filterParam.getCompanyid()) + ") and FISCLOSED=0) temp ");
            sql.append("" + this.sort + "");
        }
        try {
            return FMIsqlFacadeFactory.getRemoteInstance().executeQuery(sql.toString(), null);
        }
        catch (EASBizException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void filldata(IRowSet rs, FMSuspensionAccountFilterParam filterParam) throws SQLException, EASBizException, BOSException {
        boolean isZero = filterParam.getCount() == 0;
        int precision = 2;
        while (rs.next()) {
            IRow row = this.tblMain.addRow();
            AccountBankInfo accountBank = AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(rs.getString("FAccountBankID")), this.getselector());
            row.getCell("accountID").setValue((Object)rs.getString("FAccountBankID"));
            row.getCell("company").setValue((Object)accountBank.getCompany().getName());
            row.getCell("bank").setValue((Object)accountBank.getBank().getName());
            row.getCell("accountBankNumber").setValue((Object)accountBank.getNumber());
            row.getCell("account").setValue((Object)accountBank.getBankAccountNumber());
            row.getCell("accountName").setValue((Object)accountBank.getName());
            row.getCell("openDate").setValue((Object)accountBank.getOpenDate());
            row.getCell("openDate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
            if (accountBank.getCurrency() != null) {
                row.getCell("currency").setValue((Object)accountBank.getCurrency().getName());
                FMClientHelper.setNumberFormat(row, "amount", accountBank.getCurrency().getId().toString());
            }
            if (isZero) {
                row.getCell("count").setValue((Object)0);
                row.getCell("count").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                row.getCell("amount").setValue((Object)Constants.ZERO);
                row.getCell("amount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                continue;
            }
            row.getCell("count").setValue((Object)rs.getString("ACC"));
            row.getCell("count").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            row.getCell("amount").setValue((Object)new BigDecimal(rs.getString("SS")));
            row.getCell("amount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }

    @Override
    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        IRow row;
        String billid;
        super.actionView_actionPerformed(e);
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null && (billid = (row = this.tblMain.getRow(selectBlock.getTop())).getCell("accountID").getValue().toString()) != null) {
            FMClientHelper.viewDetailBill((CoreUIObject)this, billid, null);
        }
    }

    @Override
    public void actionViewDetail_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewDetail_actionPerformed(e);
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null) {
            IRow row = this.tblMain.getRow(selectBlock.getTop());
            FMSuspensionAccountFilterParam filterParam = (FMSuspensionAccountFilterParam)this.getFilterParam();
            Date endDate = filterParam.getSelectDate();
            Date fromdDate = null;
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(endDate);
            if (filterParam.getTimeconditions() == TimeConditionsEnum.halfYear) {
                calendar.add(2, -6);
            }
            if (filterParam.getTimeconditions() == TimeConditionsEnum.oneYear) {
                calendar.add(1, -1);
            }
            if (filterParam.getTimeconditions() == TimeConditionsEnum.twoYear || filterParam.getTimeconditions() == TimeConditionsEnum.overTwoYear) {
                calendar.add(1, -2);
            }
            fromdDate = calendar.getTime();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("accountBank.id", row.getCell("accountID").getValue(), CompareType.EQUALS));
            if (filterParam.getTimeconditions() != TimeConditionsEnum.overTwoYear) {
                filter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)fromdDate, CompareType.GREATER_EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)endDate, CompareType.LESS_EQUALS));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)fromdDate, CompareType.LESS_EQUALS));
                endDate = fromdDate;
                fromdDate = null;
            }
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(filter);
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"entityview", (Object)view);
            uiContext.put((Object)"bankAccountNumber", row.getCell("accountBankNumber").getValue());
            uiContext.put((Object)"fromdDate", (Object)fromdDate);
            uiContext.put((Object)"endDate", (Object)endDate);
            IUIWindow uiWindow = null;
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(SuspensionJournalList.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
        }
    }

    private SelectorItemCollection getselector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("openDate"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("bank.name"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("account.name"));
        sic.add(new SelectorItemInfo("bankAccountNumber"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.precision"));
        return sic;
    }
}

