/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fi.cas.JournalSourceEnum;
import com.kingdee.eas.fm.common.client.AbstractSuspensionJournalList;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class SuspensionJournalList
extends AbstractSuspensionJournalList {
    private static final Logger logger = CoreUIObject.getLogger(SuspensionJournalList.class);

    @Override
    public void storeFields() {
        this.accountbankText.setText(this.getUIContext().get("bankAccountNumber").toString());
        this.accountbankText.setEnabled(false);
        super.storeFields();
    }

    @Override
    public void onShow() throws Exception {
        super.onShow();
        this.accountbankText.setText(this.getUIContext().get("bankAccountNumber").toString());
        this.accountbankText.setEnabled(false);
        this.Datefrom.setValue(this.getUIContext().get("fromdDate"));
        this.Dateto.setValue(this.getUIContext().get("endDate"));
    }

    @Override
    protected KDTable getMainTable() {
        return this.kDTable1;
    }

    @Override
    protected void execQuery() throws BOSException {
        this.kDTable1.getDataRequestManager().setDataRequestMode(0);
        this.kDTable1.checkParsed();
        this.kDTable1.setEditable(false);
        this.kDTable1.removeRows(true);
        IRowSet rs = this.getRowSet();
        try {
            this.filldata(rs);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public IRowSet getRowSet() throws BOSException {
        IMetaDataPK pk = MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.fm.common.JournalQuery");
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)pk);
        EntityViewInfo ev = (EntityViewInfo)this.getUIContext().get("entityview");
        exec.setObjectView(ev);
        return exec.executeQuery();
    }

    @Override
    public FMFilterBaseUI getFilterUI() throws Exception {
        return null;
    }

    @Override
    public CommonQueryDialog getQueryDlg() throws Exception {
        return null;
    }

    @Override
    public void onLoad() throws Exception {
        this.actionQuery.setVisible(false);
        this.execQuery();
    }

    private void filldata(IRowSet rs) throws SQLException, EASBizException, BOSException {
        while (rs.next()) {
            IRow row = this.kDTable1.addRow();
            row.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
            this.setHorizontalAlign(row, new String[]{"debit", "credit"}, Styles.HorizontalAlignment.RIGHT);
            this.setHorizontalAlign(row, new String[]{"createDate", "bizDate"}, Styles.HorizontalAlignment.CENTER);
            row.getCell("company").setValue((Object)rs.getString("company.name"));
            row.getCell("createDate").setValue((Object)rs.getString("createDate"));
            row.getCell("bizDate").setValue((Object)rs.getString("bizDate"));
            row.getCell("voucherType").setValue((Object)rs.getString("voucherType"));
            row.getCell("voucherNumber").setValue((Object)rs.getString("voucherNumber"));
            row.getCell("oppAccountNumber").setValue((Object)rs.getString("oppAccountViewNumber"));
            if (rs.getString("billType") != null) {
                BillTypeEnum billTypeEnum = BillTypeEnum.getEnum((int)Integer.parseInt(rs.getString("billType")));
                row.getCell("billType").setValue((Object)billTypeEnum.getAlias(SysContext.getSysContext().getLocale()));
            }
            row.getCell("billNumber").setValue((Object)rs.getString("billNumber"));
            row.getCell("description").setValue((Object)rs.getString("description"));
            row.getCell("settType").setValue((Object)rs.getString("settlementType"));
            row.getCell("settNumber").setValue((Object)rs.getString("settlementNumber"));
            row.getCell("debit").setValue((Object)rs.getString("debitAmount"));
            row.getCell("debit").getStyleAttributes().setNumberFormat("%r{#,##0.00}f");
            row.getCell("credit").setValue((Object)rs.getString("creditAmount"));
            row.getCell("credit").getStyleAttributes().setNumberFormat("%r{#,##0.00}f");
            row.getCell("asstHgName").setValue((Object)rs.getString("assistHgName"));
            row.getCell("cash").setValue((Object)rs.getString("cashier"));
            row.getCell("batchNo").setValue((Object)rs.getString("batchNo"));
            if (rs.getString("verifyStatus") != null) {
                VerifyScopeEnum verifyScope = VerifyScopeEnum.getEnum((int)Integer.parseInt(rs.getString("verifyStatus")));
                row.getCell("verify").setValue((Object)verifyScope.getAlias(SysContext.getSysContext().getLocale()));
            }
            if (rs.getString("source") != null) {
                JournalSourceEnum joursourcenum = JournalSourceEnum.getEnum((int)Integer.parseInt(rs.getString("source")));
                row.getCell("source").setValue((Object)joursourcenum.getAlias(SysContext.getSysContext().getLocale()));
            }
            row.getCell("oppUnit").setValue((Object)rs.getString("oppUnit"));
            row.getCell("oppAcctNumber").setValue((Object)rs.getString("oppAcctNumber"));
            row.getCell("oppBank").setValue((Object)rs.getString("oppBank"));
            row.getCell("currency").setValue((Object)rs.getString("currency.name"));
        }
    }

    private void setHorizontalAlign(IRow row, String[] strings, Styles.HorizontalAlignment right) {
        for (int i = 0; i < strings.length; ++i) {
            row.getCell(strings[i]).getStyleAttributes().setHorizontalAlign(right);
        }
    }
}

