/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.util.StringUtils;

public class TableBindHandler {
    public void bindDataToTable(KDTable table, IObjectCollection collection) {
        if (collection == null) {
            return;
        }
        table.setUserObject((Object)collection);
        table.removeRows();
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            IObjectValue obj = collection.getObject(i);
            IRow row = table.addRow(i);
            this.loadLineFields(table, row, obj);
        }
    }

    public void storeLineFields(KDTable table, IRow row, IObjectValue obj) {
        int n = table.getColumnCount();
        for (int i = 0; i < n; ++i) {
            String bindField = table.getColumn(i).getFieldName();
            if (StringUtils.isEmpty((String)bindField)) continue;
            if (bindField.indexOf(".") >= 0) {
                String[] subItems = StringUtils.split((String)bindField, (String)".");
                IObjectValue subObj = obj;
                int l = subItems.length - 1;
                for (int k = 0; k < l && (subObj = (IObjectValue)subObj.get(subItems[k])) != null; ++k) {
                }
                if (subObj == null) continue;
                subObj.put(subItems[subItems.length - 1], row.getCell(i).getValue());
                continue;
            }
            obj.put(bindField, row.getCell(i).getValue());
        }
    }

    public void bindTableToData(KDTable table, IObjectCollection collection, String srcname) {
        if (collection == null) {
            return;
        }
        collection.clear();
        int n = table.getRowCount();
        for (int i = 0; i < n; ++i) {
            IRow row = table.getRow(i);
            IObjectValue obj = (IObjectValue)row.getUserObject();
            if (obj == null) {
                try {
                    obj = (IObjectValue)Class.forName(srcname).newInstance();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            if (!collection.addObject(obj)) continue;
            this.storeLineFields(table, row, obj);
        }
    }

    public void loadLineFields(KDTable table, IRow row, IObjectValue obj) {
        row.setUserObject((Object)obj);
        int n = table.getColumnCount();
        for (int i = 0; i < n; ++i) {
            String bindField = table.getColumn(i).getFieldName();
            if (StringUtils.isEmpty((String)bindField)) continue;
            if (bindField.indexOf(".") >= 0) {
                String[] subItems = StringUtils.split((String)bindField, (String)".");
                IObjectValue subObj = obj;
                int l = subItems.length - 1;
                for (int k = 0; k < l && (subObj = (IObjectValue)subObj.get(subItems[k])) != null; ++k) {
                }
                if (subObj == null) continue;
                row.getCell(i).setValue(subObj.get(subItems[subItems.length - 1]));
                continue;
            }
            row.getCell(i).setValue(obj.get(bindField));
        }
    }
}

