/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fm.common.client.AbstractTreeViewUI;
import com.kingdee.eas.fm.common.client.CommonTreeNode;
import com.kingdee.eas.fm.common.client.CommonTreeNodeCollecttion;
import com.kingdee.eas.fm.common.client.CommonTreeView;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class TreeViewUI
extends AbstractTreeViewUI {
    private static final Logger logger = CoreUIObject.getLogger(TreeViewUI.class);

    @Override
    public void actionShowTree_actionPerformed(ActionEvent e) throws Exception {
        String tableName = this.txtTableName.getText();
        String fidColumn = this.txtFidColumn.getText();
        String fpidColumn = this.txtFPidColumn.getText();
        String showColumn = this.txtLabelColumn.getText();
        String pidValue = this.txtCustomerPid.getText();
        CommonTreeView ctw = new CommonTreeView(tableName, fidColumn, fpidColumn, showColumn, pidValue);
        this.fillTreeView(ctw);
    }

    private void fillTreeView(CommonTreeView ctw) throws Exception {
        String sql = this.transView2SQL(ctw);
        IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sql).executeSQL();
        this.populateTreeView(ctw, rs);
        DefaultKingdeeTreeNode treeModel = this.buildTreeModel(ctw);
        DefaultTreeModel tm = new DefaultTreeModel((TreeNode)treeModel);
        this.kDTree1.setModel((TreeModel)tm);
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.kDTree1.getModel().getRoot();
        this.kDTree1.expandAllNodes(true, (TreeNode)root);
    }

    private void populateTreeView(CommonTreeView ctw, IRowSet rs) throws Exception {
        CommonTreeNode ctn = null;
        try {
            while (rs.next()) {
                ctn = new CommonTreeNode(rs.getString(1), rs.getString(2), rs.getString(3));
                ctw.getTreeNodes().add(ctn);
            }
        }
        catch (SQLException sqle) {
            throw new BOSException(sqle.getCause());
        }
    }

    private String transView2SQL(CommonTreeView ctw) {
        StringBuffer sb = new StringBuffer();
        sb.append("select ").append(ctw.getIdColumn()).append(",");
        sb.append(ctw.getLabelColumn()).append(",").append(ctw.getPidColumn());
        sb.append(" from ").append(ctw.getTableName());
        if (ctw.getPidValue() != null && ctw.getPidValue().length() > 0) {
            sb.append(" where ").append(ctw.getPidColumn());
            sb.append(" = '").append(ctw.getPidValue()).append("'");
        }
        return sb.toString();
    }

    private DefaultKingdeeTreeNode buildTreeModel(CommonTreeView ctw) throws BOSException {
        if (ctw == null) {
            return null;
        }
        if (ctw.size() == 0) {
            return new DefaultKingdeeTreeNode();
        }
        CommonTreeNode rootNode = CommonTreeNode.createCommonRoot();
        DefaultKingdeeTreeNode rootTreeNode = new DefaultKingdeeTreeNode((Object)rootNode);
        CommonTreeNodeCollecttion nodesCol = ctw.getTreeNodes();
        int n = nodesCol.size();
        for (int i = 0; i < n; ++i) {
            TreeViewUI.addChildNode(rootTreeNode, nodesCol.getIndex(i));
        }
        return rootTreeNode;
    }

    private static void addChildNode(DefaultKingdeeTreeNode root, CommonTreeNode info) {
        DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode((Object)info);
        DefaultKingdeeTreeNode parent = null;
        if (info.getNodePId() != null) {
            parent = TreeViewUI.searchNodeById(root, info.getNodePId());
        }
        if (parent != null) {
            parent.add((MutableTreeNode)node);
        } else {
            String id = info.getNodeId();
            for (int i = 0; i < root.getChildCount(); ++i) {
                DefaultKingdeeTreeNode s = (DefaultKingdeeTreeNode)root.getChildAt(i);
                CommonTreeNode rootItem = (CommonTreeNode)s.getUserObject();
                if (rootItem.getNodePId() == null || !rootItem.getNodePId().equals(id)) continue;
                root.remove((MutableTreeNode)s);
                node.add((MutableTreeNode)s);
                --i;
            }
            root.add((MutableTreeNode)node);
        }
    }

    private static DefaultKingdeeTreeNode searchNodeById(DefaultKingdeeTreeNode root, String id) {
        CommonTreeNode info = (CommonTreeNode)root.getUserObject();
        if (info != null) {
            if (id.equals(info.getNodeId())) {
                return root;
            }
            for (int i = 0; i < root.getChildCount(); ++i) {
                DefaultKingdeeTreeNode node = TreeViewUI.searchNodeById((DefaultKingdeeTreeNode)root.getChildAt(i), id);
                if (node == null) continue;
                return node;
            }
        }
        return null;
    }
}

