/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.client.query;

import com.kingdee.eas.fm.common.client.query.convert.Convert;
import com.kingdee.eas.fm.common.client.query.convert.NullConvert;
import com.kingdee.eas.fm.common.client.query.convert.array.BooleanArrayConvert;
import com.kingdee.eas.fm.common.client.query.convert.array.IdArrayStringConvert;
import com.kingdee.eas.fm.common.client.query.convert.array.InfoArrayConvert;
import com.kingdee.eas.fm.common.client.query.convert.basetype.BooleanConvert;
import com.kingdee.eas.fm.common.client.query.convert.basetype.ByteConvert;
import com.kingdee.eas.fm.common.client.query.convert.basetype.CharacterConvert;
import com.kingdee.eas.fm.common.client.query.convert.basetype.DoubleConvert;
import com.kingdee.eas.fm.common.client.query.convert.basetype.FloatConvert;
import com.kingdee.eas.fm.common.client.query.convert.basetype.IntegerConvert;
import com.kingdee.eas.fm.common.client.query.convert.basetype.LongConvert;
import com.kingdee.eas.fm.common.client.query.convert.basetype.ShortConvert;
import com.kingdee.eas.fm.common.client.query.convert.collection.IdListConvert;
import com.kingdee.eas.fm.common.client.query.convert.collection.IdSetConvert;
import com.kingdee.eas.fm.common.client.query.convert.enumeration.EnumConvert;
import com.kingdee.eas.fm.common.client.query.convert.info.BizInfoConvert;
import com.kingdee.eas.fm.common.client.query.convert.info.CompanyOrgUnitInfoConvert;
import com.kingdee.eas.fm.common.client.query.convert.jdkclasstype.BigDecimalConvert;
import com.kingdee.eas.fm.common.client.query.convert.jdkclasstype.SqlDataConvert;
import com.kingdee.eas.fm.common.client.query.convert.jdkclasstype.StringConvert;
import com.kingdee.eas.fm.common.client.query.convert.jdkclasstype.UtilDataConvert;
import com.kingdee.eas.fm.common.client.query.convert.other.DefaultTreeModelXMLConvert;
import com.kingdee.eas.fm.common.client.query.convert.other.ObjectArrayConvert;
import com.kingdee.eas.util.client.EASResource;

public class ConvertFactory {
    private static final ConvertFactory instance = new ConvertFactory();
    private static final Convert[] converts = new Convert[]{new ByteConvert(), new ShortConvert(), new IntegerConvert(), new LongConvert(), new FloatConvert(), new DoubleConvert(), new BooleanConvert(), new CharacterConvert(), new IdArrayStringConvert(), new StringConvert(), new UtilDataConvert(), new SqlDataConvert(), new BigDecimalConvert(), new BizInfoConvert(), new CompanyOrgUnitInfoConvert(), new BooleanArrayConvert(), new ObjectArrayConvert(), new DefaultTreeModelXMLConvert()};

    private ConvertFactory() {
    }

    public static ConvertFactory getInstance() {
        return instance;
    }

    public Convert createConvert(Object obj) {
        if (obj == null) {
            return new NullConvert();
        }
        return this.createConvert(obj.getClass());
    }

    public Convert createConvert(Class<?> clazz) {
        InfoArrayConvert infoArrayConvert = new InfoArrayConvert(clazz);
        if (infoArrayConvert.canProcess(clazz)) {
            return infoArrayConvert;
        }
        for (Convert convert : converts) {
            if (!convert.canProcess(clazz)) continue;
            return convert;
        }
        EnumConvert enumConvert = new EnumConvert(clazz);
        if (enumConvert.canProcess(clazz)) {
            return enumConvert;
        }
        IdSetConvert idSetConvert = new IdSetConvert(clazz);
        if (idSetConvert.canProcess(clazz)) {
            return idSetConvert;
        }
        IdListConvert idListConvert = new IdListConvert(clazz);
        if (idListConvert.canProcess(clazz)) {
            return idListConvert;
        }
        throw new RuntimeException(String.format(EASResource.getString((String)"com.kingdee.eas.fm.common.client.FMCommonClientResource", (String)"zhuanhuanqi_yichang"), clazz.getName()));
    }
}

