/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.client.query;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.fm.common.client.query.ConvertUtil;
import com.kingdee.eas.fm.common.client.query.GetPropertyException;
import com.kingdee.eas.fm.common.client.query.convert.DecodeException;
import com.kingdee.eas.fm.common.client.query.convert.EncodeException;
import com.kingdee.eas.fm.common.client.query.convert.other.RptParamsXMLConvert;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.client.EASResource;
import java.beans.PropertyDescriptor;
import java.util.Locale;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.log4j.Logger;

public class QuerySolutionConvert {
    private static final Logger LOGGER = CoreUIObject.getLogger(QuerySolutionConvert.class);
    public static String FM_NEW_QUERY_SULUTION = "FM_NEW_QUERY_SULUTION";

    public CustomerParams convertToCustomerParams(Object bizParam) throws EncodeException, GetPropertyException {
        CustomerParams customerParams = new CustomerParams();
        customerParams.addCustomerParam(FM_NEW_QUERY_SULUTION, "true");
        if (bizParam instanceof RptParams) {
            this.processRptParams(bizParam, customerParams);
        } else if (bizParam instanceof DynaBean) {
            this.processDynaProperty(bizParam, customerParams);
        } else {
            this.processBean(bizParam, customerParams);
        }
        return customerParams;
    }

    private void processRptParams(Object bizParam, CustomerParams customerParams) throws EncodeException {
        RptParams rptParams = (RptParams)bizParam;
        for (String key : rptParams.keySet()) {
            Object value = rptParams.getObject(key);
            if (EmptyUtil.isEmpty((Object)value) || this.isIgnoreType(value.getClass())) continue;
            try {
                customerParams.addCustomerParam(key, new RptParamsXMLConvert().encode(value));
            }
            catch (Exception e) {
                LOGGER.error((Object)String.format(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"142_QuerySolutionConvert"), bizParam.getClass().getName(), key), (Throwable)e);
            }
        }
    }

    private boolean isIgnoreType(Class clazz) {
        return Locale.class.isAssignableFrom(clazz);
    }

    private void processDynaProperty(Object bizParam, CustomerParams customerParams) throws EncodeException, GetPropertyException {
        DynaProperty[] properties;
        for (DynaProperty property : properties = ((DynaBean)bizParam).getDynaClass().getDynaProperties()) {
            String key = property.getName();
            Object value = null;
            try {
                value = PropertyUtils.getNestedProperty((Object)bizParam, (String)key);
            }
            catch (Exception e) {
                String msg = String.format(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"143_QuerySolutionConvert"), bizParam.getClass().getName(), key);
                LOGGER.error((Object)msg, (Throwable)e);
                throw new GetPropertyException(msg, e);
            }
            if (EmptyUtil.isEmpty((Object)value) || this.isIgnoreType(value.getClass())) continue;
            try {
                customerParams.addCustomerParam(key, this.convertToString(value));
            }
            catch (Exception e) {
                String msg = String.format(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"142_QuerySolutionConvert"), bizParam.getClass().getName(), key);
                LOGGER.error((Object)msg, (Throwable)e);
                throw new EncodeException(msg, e);
            }
        }
    }

    private void processBean(Object bizParam, CustomerParams customerParams) throws EncodeException, GetPropertyException {
        PropertyDescriptor[] properties;
        for (PropertyDescriptor property : properties = PropertyUtils.getPropertyDescriptors(bizParam.getClass())) {
            String key = property.getName();
            if (property.getReadMethod() == null || property.getWriteMethod() == null) continue;
            Object value = null;
            try {
                value = PropertyUtils.getNestedProperty((Object)bizParam, (String)key);
            }
            catch (Exception e) {
                String msg = String.format(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"143_QuerySolutionConvert"), bizParam.getClass().getName(), key);
                LOGGER.error((Object)msg, (Throwable)e);
                throw new GetPropertyException(msg, e);
            }
            if (value != null && this.isIgnoreType(value.getClass())) continue;
            try {
                customerParams.addCustomerParam(key, this.convertToString(value));
            }
            catch (Exception e) {
                String msg = String.format(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"142_QuerySolutionConvert"), bizParam.getClass().getName(), key);
                LOGGER.error((Object)msg, (Throwable)e);
                throw new EncodeException(msg, e);
            }
        }
    }

    private String convertToString(Object value) throws EncodeException {
        return ConvertUtil.encode(value);
    }

    public Object convertToBizParams(Class paramClass, CustomerParams cp) throws DecodeException {
        try {
            Object param = paramClass.newInstance();
            if (param instanceof RptParams) {
                RptParams rptParams = (RptParams)param;
                for (String key : cp.getKeys()) {
                    if (key.equals(FM_NEW_QUERY_SULUTION)) continue;
                    try {
                        String value = cp.getCustomerParam(key);
                        RptParamsXMLConvert convert = new RptParamsXMLConvert();
                        rptParams.setObject(key, convert.decode(value));
                    }
                    catch (DecodeException e) {
                        String msg = String.format(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"144_QuerySolutionConvert"), paramClass.getName(), key);
                        LOGGER.error((Object)msg, (Throwable)e);
                        throw new DecodeException(msg, e);
                    }
                }
            } else {
                PropertyDescriptor[] properties;
                for (PropertyDescriptor property : properties = PropertyUtils.getPropertyDescriptors((Class)paramClass)) {
                    String key = property.getName();
                    if (property.getReadMethod() == null || property.getWriteMethod() == null || !cp.getKeys().contains(key)) continue;
                    String value = cp.getCustomerParam(key);
                    if (EmptyUtil.isEmpty((String)value) && this.isBaseType(property)) {
                        PropertyUtils.setNestedProperty(param, (String)key, (Object)0);
                        continue;
                    }
                    if (EmptyUtil.isEmpty((String)value) && property.getPropertyType().equals(Boolean.TYPE)) {
                        PropertyUtils.setNestedProperty(param, (String)key, (Object)Boolean.FALSE);
                        continue;
                    }
                    if (EmptyUtil.isEmpty((String)value) && property.getPropertyType().equals(Character.TYPE)) {
                        PropertyUtils.setNestedProperty(param, (String)key, (Object)Character.valueOf(' '));
                        continue;
                    }
                    try {
                        Object bizParamValue = this.convertToBizParam(property.getPropertyType(), value);
                        PropertyUtils.setNestedProperty(param, (String)key, (Object)bizParamValue);
                    }
                    catch (DecodeException e) {
                        String msg = String.format(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"144_QuerySolutionConvert"), paramClass.getName(), key);
                        LOGGER.error((Object)msg, (Throwable)e);
                        throw new DecodeException(msg, e);
                    }
                }
            }
            return param;
        }
        catch (Exception e) {
            String msg = String.format(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"145_QuerySolutionConvert"), "New FM Params", paramClass);
            LOGGER.error((Object)msg, (Throwable)e);
            throw new DecodeException(msg, e);
        }
    }

    private boolean isBaseType(PropertyDescriptor property) {
        return property.getPropertyType().equals(Byte.TYPE) || property.getPropertyType().equals(Short.TYPE) || property.getPropertyType().equals(Integer.TYPE) || property.getPropertyType().equals(Long.TYPE) || property.getPropertyType().equals(Float.TYPE) || property.getPropertyType().equals(Double.TYPE);
    }

    private Object convertToBizParam(Class<?> clazz, String text) throws DecodeException {
        return ConvertUtil.decode(clazz, text);
    }
}

