/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.client.query.convert.array;

import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.fm.common.client.query.convert.Convert;
import org.apache.log4j.Logger;

public class BooleanArrayConvert
implements Convert {
    private static final Logger LOGGER = Logger.getLogger(BooleanArrayConvert.class);

    @Override
    public boolean canProcess(Class<?> clazz) {
        return boolean[].class.isAssignableFrom(clazz);
    }

    @Override
    public String encode(Object objs) {
        StringBuffer buff = new StringBuffer();
        boolean isFirst = true;
        for (boolean id : (boolean[])objs) {
            if (isFirst) {
                isFirst = false;
            } else {
                buff.append(",");
            }
            buff.append(id);
        }
        return buff.toString();
    }

    @Override
    public Object decode(String text) {
        if (EmptyUtil.isEmpty((String)text)) {
            return new boolean[0];
        }
        String[] split = text.split(",");
        boolean[] rets = new boolean[split.length];
        for (int i = 0; i < split.length; ++i) {
            rets[i] = Boolean.valueOf(split[i]);
        }
        return rets;
    }
}

