/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.client.query.convert.array;

import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.query.convert.Convert;
import com.kingdee.eas.fm.common.client.query.convert.DecodeException;
import com.kingdee.eas.fm.common.client.query.convert.other.ObjectArrayConvert;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class InfoArrayConvert
implements Convert {
    private static final Logger LOGGER = Logger.getLogger(InfoArrayConvert.class);
    private Class clazz;

    public InfoArrayConvert(Class<?> clazz) {
        this.clazz = clazz;
    }

    @Override
    public boolean canProcess(Class<?> clazz) {
        return CoreBaseInfo[].class.isAssignableFrom(clazz);
    }

    @Override
    public String encode(Object objs) {
        StringBuffer buff = new StringBuffer("");
        boolean isFirst = true;
        for (CoreBaseInfo info : (CoreBaseInfo[])objs) {
            if (isFirst) {
                isFirst = false;
            } else {
                buff.append(",");
            }
            buff.append(info.getId());
        }
        return buff.toString();
    }

    @Override
    public Object decode(String text) throws DecodeException {
        Object[] split = text.split(",");
        if (EmptyUtil.isEmpty((Object[])split)) {
            return null;
        }
        HashSet<Object> idSet = new HashSet<Object>();
        idSet.addAll(Arrays.asList(split));
        try {
            if (CompanyOrgUnitInfo.class.isAssignableFrom(this.clazz.getComponentType())) {
                return FMHelper.getBaseInfoFromIdSet(new CompanyOrgUnitInfo().getBOSType(), idSet);
            }
            CoreBaseInfo[] baseInfoFromIdSet = FMHelper.getBaseInfoFromIdSet(idSet);
            if (baseInfoFromIdSet != null && baseInfoFromIdSet.length > 0 && FullOrgUnitInfo.class.isAssignableFrom(baseInfoFromIdSet[0].getClass())) {
                return FMHelper.getBaseInfoFromIdSet(new CompanyOrgUnitInfo().getBOSType(), idSet);
            }
            if (baseInfoFromIdSet != null && baseInfoFromIdSet.length > 0 && AccountBankInfo.class.isAssignableFrom(baseInfoFromIdSet[0].getClass())) {
                return FMHelper.getAccountBankInfoFromIdSet(new AccountBankInfo().getBOSType(), idSet);
            }
            return baseInfoFromIdSet;
        }
        catch (Exception e) {
            try {
                return new ObjectArrayConvert().decode(text);
            }
            catch (Exception e1) {
                String errorMsg = String.format("FM query solution convert to InfoArray error. Error message:%s", e.getMessage());
                LOGGER.error((Object)errorMsg, (Throwable)e);
                throw new DecodeException(errorMsg, e);
            }
        }
    }
}

