/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.client.query.convert.collection;

import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.fm.common.client.query.convert.Convert;
import com.kingdee.eas.fm.common.client.query.convert.DecodeException;
import java.util.Collection;
import org.apache.log4j.Logger;

public abstract class IdCollectionConvert
implements Convert {
    private static final Logger LOGGER = Logger.getLogger(IdCollectionConvert.class);
    protected Class clazz;

    public IdCollectionConvert(Class clazz) {
        this.clazz = clazz;
    }

    @Override
    public boolean canProcess(Class<?> clazz) {
        return this.getConvertType().isAssignableFrom(clazz);
    }

    @Override
    public String encode(Object objs) {
        boolean isFirst = true;
        StringBuffer buff = new StringBuffer();
        for (Object id : (Collection)objs) {
            if (isFirst) {
                isFirst = false;
            } else {
                buff.append(",");
            }
            buff.append(id);
        }
        return buff.toString();
    }

    @Override
    public Object decode(String text) throws DecodeException {
        try {
            String[] strs;
            Collection<String> idCollection = this.createCollection();
            if (EmptyUtil.isEmpty((String)text)) {
                return idCollection;
            }
            for (String id : strs = text.split(",")) {
                idCollection.add(id);
            }
            return idCollection;
        }
        catch (Exception e) {
            String errorMsg = String.format("FM query solution convert to %s error. Error message:%s", this.getConvertType().getName(), e.getMessage());
            LOGGER.error((Object)errorMsg, (Throwable)e);
            throw new DecodeException(errorMsg, e);
        }
    }

    protected abstract Class getConvertType();

    protected abstract Collection<String> createCollection() throws InstantiationException, IllegalAccessException;
}

