/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.client.query.convert.enumeration;

import com.kingdee.eas.fm.common.client.query.convert.Convert;
import com.kingdee.eas.fm.common.client.query.convert.DecodeException;
import com.kingdee.util.enums.Enum;
import java.lang.reflect.Method;
import org.apache.log4j.Logger;

public class EnumConvert
implements Convert {
    private static final Logger LOGGER = Logger.getLogger(EnumConvert.class);
    private Class clazz;

    public EnumConvert(Class clazz) {
        this.clazz = clazz;
    }

    @Override
    public boolean canProcess(Class<?> clazz) {
        return Enum.class.isAssignableFrom(clazz);
    }

    @Override
    public String encode(Object obj) {
        try {
            return obj.getClass().getMethod("getValue", new Class[0]).invoke(obj, new Object[0]).toString();
        }
        catch (Exception e) {
            String errorMsg = String.format("FM query solution convert to string error. Error message:%s", e.getMessage());
            LOGGER.error((Object)errorMsg, (Throwable)e);
            throw new RuntimeException(errorMsg, e);
        }
    }

    @Override
    public Object decode(String text) throws DecodeException {
        try {
            Class paramType = (Class)this.clazz.getMethod("getValue", new Class[0]).getGenericReturnType();
            Method getEnumMethod = this.clazz.getMethod("getEnum", paramType);
            return getEnumMethod.invoke((Object)this.clazz, this.getValue(text));
        }
        catch (Exception e) {
            String errorMsg = String.format("FM query solution convert to BOS Enum error. Error message:%s", e.getMessage());
            LOGGER.error((Object)errorMsg, (Throwable)e);
            throw new DecodeException(errorMsg, e);
        }
    }

    private Object getValue(String text) throws SecurityException, NoSuchMethodException {
        String[] keys = new String[]{"int", "long", "float", "double", "String or other"};
        String typeName = ((Class)this.clazz.getMethod("getValue", new Class[0]).getGenericReturnType()).getName();
        if (typeName.equals(keys[0])) {
            return Integer.valueOf(text);
        }
        if (typeName.equals(keys[1])) {
            return Long.valueOf(text);
        }
        if (typeName.equals(keys[2])) {
            return Float.valueOf(text);
        }
        if (typeName.equals(keys[3])) {
            return Double.valueOf(text);
        }
        return text;
    }
}

