/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.client.query.convert.jdkclasstype;

import com.kingdee.eas.fm.common.client.query.convert.Convert;
import com.kingdee.eas.fm.common.client.query.convert.DecodeException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public class UtilDataConvert
implements Convert {
    private static final Logger LOGGER = Logger.getLogger(UtilDataConvert.class);
    private static final DateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    @Override
    public boolean canProcess(Class<?> clazz) {
        return Date.class.equals(clazz);
    }

    @Override
    public String encode(Object obj) {
        return df.format(obj);
    }

    @Override
    public Object decode(String text) throws DecodeException {
        try {
            return df.parse(text);
        }
        catch (ParseException e) {
            String errorMsg = String.format("FM query solution convert to java.util.Date error. Error message:%s", e.getMessage());
            LOGGER.error((Object)errorMsg, (Throwable)e);
            throw new DecodeException(errorMsg, e);
        }
    }
}

