/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.client.query.convert.other;

import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.fm.common.client.query.ConvertUtil;
import com.kingdee.eas.fm.common.client.query.convert.Convert;
import com.kingdee.eas.fm.common.client.query.convert.DecodeException;
import com.kingdee.eas.fm.common.client.query.convert.EncodeException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.client.EASResource;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;

public class DefaultTreeModelXMLConvert
implements Convert {
    @Override
    public boolean canProcess(Class<?> clazz) {
        return TreeModel.class.isAssignableFrom(clazz);
    }

    @Override
    public String encode(Object obj) throws EncodeException {
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement("value");
        DefaultKingdeeTreeNode defaultKingdeeTreeNode = (DefaultKingdeeTreeNode)((DefaultTreeModel)obj).getRoot();
        root.add(this.encodeDefaultKingdeeTreeNode(defaultKingdeeTreeNode));
        return document.asXML();
    }

    private Element encodeDefaultKingdeeTreeNode(DefaultKingdeeTreeNode simpleTreeNode) throws EncodeException {
        Element root = DocumentHelper.createElement((String)"DefaultKingdeeTreeNode");
        root.add(this.encodeValue(simpleTreeNode));
        root.add(this.encodeList(simpleTreeNode));
        return root;
    }

    private Element encodeValue(DefaultKingdeeTreeNode simpleTreeNode) throws EncodeException {
        Element root = DocumentHelper.createElement((String)"value");
        root.addElement("valueType").addText(simpleTreeNode.getUserObject().getClass().getName());
        root.addElement("value").addText(ConvertUtil.encode(simpleTreeNode.getUserObject()));
        return root;
    }

    private Element encodeList(DefaultKingdeeTreeNode simpleTreeNode) throws EncodeException {
        Element root = DocumentHelper.createElement((String)"children");
        Enumeration iterator = simpleTreeNode.children();
        while (iterator.hasMoreElements()) {
            DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)iterator.nextElement();
            root.add(this.encodeDefaultKingdeeTreeNode(child));
        }
        return root;
    }

    @Override
    public Object decode(String text) throws DecodeException {
        try {
            Document document = DocumentHelper.parseText((String)text);
            Element root = document.getRootElement();
            Map<String, CoreBaseInfo> cache = this.getCache(root);
            return new DefaultTreeModel((TreeNode)this.decodeDefaultKingdeeTreeNode(root.element("DefaultKingdeeTreeNode"), cache));
        }
        catch (Exception e) {
            throw new DecodeException(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"141_ComponentStatusXMLConvert"), e);
        }
    }

    private DefaultKingdeeTreeNode decodeDefaultKingdeeTreeNode(Element root, Map<String, CoreBaseInfo> cache) throws EncodeException, DecodeException, ClassNotFoundException {
        DefaultKingdeeTreeNode result = new DefaultKingdeeTreeNode();
        result.setUserObject(this.getDefaultKingdeeTreeNodeUserObject(root.element("value"), cache));
        List elements = root.element("children").elements("DefaultKingdeeTreeNode");
        for (Element child : elements) {
            result.add((MutableTreeNode)this.decodeDefaultKingdeeTreeNode(child, cache));
        }
        return result;
    }

    private Object getDefaultKingdeeTreeNodeUserObject(Element root, Map<String, CoreBaseInfo> cache) throws DecodeException, ClassNotFoundException {
        String valueType = root.elementText("valueType");
        String value = root.elementText("value");
        CoreBaseInfo coreBaseInfo = cache.get(value);
        if (value.equals("36353433-3663-3321-3783-3902578210331C9A9013")) {
            BankInfo rootBankInfo = new BankInfo();
            rootBankInfo.setName(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"105_RptFmClientUtil"));
            rootBankInfo.setId(BOSUuid.read((String)value));
            return rootBankInfo;
        }
        if (coreBaseInfo == null) {
            return ConvertUtil.decode(Class.forName(valueType), value);
        }
        return coreBaseInfo;
    }

    private Map<String, CoreBaseInfo> getCache(Element root) throws DecodeException, ClassNotFoundException, EncodeException {
        List valueElems = root.selectNodes("//DefaultKingdeeTreeNode/value");
        Map<String, Set<String>> type_ids = this.totalType(valueElems);
        String key = this.getMaxKey(type_ids);
        if (key == null) {
            return null;
        }
        Set<String> idSet = type_ids.get(key);
        CoreBaseInfo[] decode = (CoreBaseInfo[])ConvertUtil.decode(Array.newInstance(Class.forName(key), 0).getClass(), ConvertUtil.encode(idSet));
        HashMap<String, CoreBaseInfo> result = new HashMap<String, CoreBaseInfo>();
        for (CoreBaseInfo coreBaseInfo : decode) {
            result.put(coreBaseInfo.getId().toString(), coreBaseInfo);
        }
        return result;
    }

    private String getMaxKey(Map<String, Set<String>> type_ids) {
        int maxSize = 0;
        String key = null;
        for (Map.Entry<String, Set<String>> item : type_ids.entrySet()) {
            if (item.getValue().size() <= maxSize) continue;
            maxSize = item.getValue().size();
            key = item.getKey();
        }
        return key;
    }

    private Map<String, Set<String>> totalType(List<Node> valueElems) {
        HashMap<String, Set<String>> type_ids = new HashMap<String, Set<String>>();
        for (Element element : valueElems) {
            String valueType = element.elementText("valueType");
            String value = element.elementText("value");
            if (!type_ids.containsKey(valueType)) {
                type_ids.put(valueType, new HashSet());
            }
            Set set = (Set)type_ids.get(valueType);
            set.add(value);
        }
        return type_ids;
    }
}

