/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.client.query.convert.other;

import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.fm.be.BankInterface;
import com.kingdee.eas.fm.common.client.query.ConvertUtil;
import com.kingdee.eas.fm.common.client.query.convert.DecodeException;
import com.kingdee.eas.fm.common.client.query.convert.EncodeException;
import com.kingdee.eas.fm.common.client.query.convert.other.BankInterfaceXMLConvert;
import com.kingdee.eas.util.client.EASResource;
import java.util.Collection;
import java.util.List;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class ListXMLConvert {
    public boolean canProcess(Class<?> clazz) {
        return List.class.isAssignableFrom(clazz);
    }

    public Element encode(Object obj) throws EncodeException {
        Element root = DocumentHelper.createElement((String)"value");
        List objs = (List)obj;
        if (EmptyUtil.isEmpty((Collection)objs)) {
            return root;
        }
        if (new BankInterfaceXMLConvert().canProcess(objs.get(0).getClass())) {
            BankInterface[] bankInterfaces = this.convert2CoreBaseInfoArray(objs);
            root.addElement("type").addText(BankInterface.class.getName());
            root.add(new BankInterfaceXMLConvert().encode(bankInterfaces));
        } else {
            root.addElement("type").addText(List.class.getName());
            root.addElement("value").addText(ConvertUtil.encode(objs));
        }
        return root;
    }

    private BankInterface[] convert2CoreBaseInfoArray(List objs) {
        BankInterface[] bankInterfaces = new BankInterface[objs.size()];
        for (int i = 0; i < objs.size(); ++i) {
            bankInterfaces[i] = (BankInterface)objs.get(i);
        }
        return bankInterfaces;
    }

    public Object decode(Element root) throws DecodeException {
        try {
            String type = root.elementText("type");
            if (type == null) {
                return new Object[0];
            }
            Class<?> clazzObj = Class.forName(type);
            if (BankInterface.class.isAssignableFrom(clazzObj)) {
                return new BankInterfaceXMLConvert().decode(root.element("value"));
            }
            return ConvertUtil.decode(clazzObj, root.elementText("value"));
        }
        catch (Exception e) {
            throw new DecodeException(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"141_ComponentStatusXMLConvert"), e);
        }
    }
}

