/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.client.query.convert.other;

import com.kingdee.eas.fm.common.client.query.ConvertUtil;
import com.kingdee.eas.fm.common.client.query.convert.DecodeException;
import com.kingdee.eas.fm.common.client.query.convert.EncodeException;
import com.kingdee.eas.framework.report.util.RptConditionManager;
import com.kingdee.eas.util.client.EASResource;
import java.util.List;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class Object2DArrayXMLConvert {
    private static final String NULL_TYPE = "NULL";

    public boolean canProcess(Class<?> clazz) {
        return clazz.getName().equals("[[Ljava.lang.Object;");
    }

    public Element encode(Object obj) throws EncodeException {
        Element root = DocumentHelper.createElement((String)"value");
        Object[][] objs = (Object[][])obj;
        if (objs == null || objs.length == 0 || objs[0].length == 0) {
            return root;
        }
        for (Object[] objsRow : objs) {
            Element rowElem = root.addElement("row");
            for (Object objsCol : objsRow) {
                Element colElem = rowElem.addElement("column");
                colElem.addElement("type").addText(this.getClassName(objsCol));
                colElem.addElement("value").addText(ConvertUtil.encode(objsCol));
            }
        }
        return root;
    }

    private String getClassName(Object objsCol) {
        if (objsCol == null) {
            return NULL_TYPE;
        }
        return objsCol.getClass().getName();
    }

    public Object decode(Element root) throws DecodeException {
        RptConditionManager.ComponentStatus componentStatus = new RptConditionManager.ComponentStatus();
        List rowsElem = root.elements("row");
        Object[][] result = new Object[rowsElem.size()][];
        int rowIdx = 0;
        for (Element rowElem : rowsElem) {
            int colIdx = 0;
            List columnsElem = rowElem.elements("column");
            result[rowIdx] = new Object[columnsElem.size()];
            for (Element colElem : columnsElem) {
                String type = colElem.elementText("type");
                if (!type.equals(NULL_TYPE)) {
                    try {
                        result[rowIdx][colIdx] = ConvertUtil.decode(Class.forName(type), colElem.elementText("value"));
                    }
                    catch (Exception e) {
                        throw new DecodeException(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"141_ComponentStatusXMLConvert"), e);
                    }
                }
                ++colIdx;
            }
            ++rowIdx;
        }
        return result;
    }
}

