/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.client.query.convert.other;

import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.fm.common.client.query.ConvertUtil;
import com.kingdee.eas.fm.common.client.query.convert.DecodeException;
import com.kingdee.eas.fm.common.client.query.convert.EncodeException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.bireport.util.SimpleTreeNode;
import com.kingdee.eas.util.client.EASResource;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;

public class SimpleTreeNodeXMLConvert {
    public boolean canProcess(Class<?> clazz) {
        return SimpleTreeNode.class.isAssignableFrom(clazz);
    }

    public Element encode(Object obj) throws EncodeException {
        Element root = DocumentHelper.createElement((String)"value");
        root.add(this.encodeSimpleTreeNode((SimpleTreeNode)obj));
        return root;
    }

    private Element encodeSimpleTreeNode(SimpleTreeNode simpleTreeNode) throws EncodeException {
        Element root = DocumentHelper.createElement((String)"SimpleTreeNode");
        root.add(this.encodeValue(simpleTreeNode));
        root.add(this.encodeList(simpleTreeNode));
        return root;
    }

    private Element encodeValue(SimpleTreeNode simpleTreeNode) throws EncodeException {
        Element root = DocumentHelper.createElement((String)"value");
        root.addElement("valueType").addText(simpleTreeNode.getValue().getClass().getName());
        root.addElement("value").addText(ConvertUtil.encode(simpleTreeNode.getValue()));
        return root;
    }

    private Element encodeList(SimpleTreeNode simpleTreeNode) throws EncodeException {
        Element root = DocumentHelper.createElement((String)"children");
        Iterator iterator = simpleTreeNode.childIterator();
        while (iterator.hasNext()) {
            SimpleTreeNode child = (SimpleTreeNode)iterator.next();
            root.add(this.encodeSimpleTreeNode(child));
        }
        return root;
    }

    public Object decode(Element root) throws DecodeException {
        try {
            Map<String, CoreBaseInfo> cache = this.getCache(root);
            return this.decodeSimpleTreeNode(root.element("SimpleTreeNode"), cache);
        }
        catch (Exception e) {
            throw new DecodeException(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"141_ComponentStatusXMLConvert"), e);
        }
    }

    private SimpleTreeNode decodeSimpleTreeNode(Element root, Map<String, CoreBaseInfo> cache) throws EncodeException, DecodeException, ClassNotFoundException {
        SimpleTreeNode result = new SimpleTreeNode();
        result.setValue(this.getSimpleTreeNodeValue(root.element("value"), cache));
        List elements = root.element("children").elements("SimpleTreeNode");
        for (Element child : elements) {
            result.addChild(this.decodeSimpleTreeNode(child, cache));
        }
        return result;
    }

    private Object getSimpleTreeNodeValue(Element root, Map<String, CoreBaseInfo> cache) throws DecodeException, ClassNotFoundException {
        String valueType = root.elementText("valueType");
        String value = root.elementText("value");
        CoreBaseInfo coreBaseInfo = cache.get(value);
        if (value.equals("36353433-3663-3321-3783-3902578210331C9A9013")) {
            BankInfo rootBankInfo = new BankInfo();
            rootBankInfo.setName(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"105_RptFmClientUtil"));
            rootBankInfo.setId(BOSUuid.read((String)value));
            return rootBankInfo;
        }
        if (coreBaseInfo == null) {
            return ConvertUtil.decode(Class.forName(valueType), value);
        }
        return coreBaseInfo;
    }

    private Map<String, CoreBaseInfo> getCache(Element root) throws DecodeException, ClassNotFoundException, EncodeException {
        List valueElems = root.selectNodes("//SimpleTreeNode/value");
        Map<String, Set<String>> type_ids = this.totalType(valueElems);
        String key = this.getMaxKey(type_ids);
        if (key == null) {
            return null;
        }
        Set<String> idSet = type_ids.get(key);
        CoreBaseInfo[] decode = (CoreBaseInfo[])ConvertUtil.decode(Array.newInstance(Class.forName(key), 0).getClass(), ConvertUtil.encode(idSet));
        HashMap<String, CoreBaseInfo> result = new HashMap<String, CoreBaseInfo>();
        for (CoreBaseInfo coreBaseInfo : decode) {
            result.put(coreBaseInfo.getId().toString(), coreBaseInfo);
        }
        return result;
    }

    private String getMaxKey(Map<String, Set<String>> type_ids) {
        int maxSize = 0;
        String key = null;
        for (Map.Entry<String, Set<String>> item : type_ids.entrySet()) {
            if (item.getValue().size() <= maxSize) continue;
            maxSize = item.getValue().size();
            key = item.getKey();
        }
        return key;
    }

    private Map<String, Set<String>> totalType(List<Node> valueElems) {
        HashMap<String, Set<String>> type_ids = new HashMap<String, Set<String>>();
        for (Element element : valueElems) {
            String valueType = element.elementText("valueType");
            String value = element.elementText("value");
            if (!type_ids.containsKey(valueType)) {
                type_ids.put(valueType, new HashSet());
            }
            Set set = (Set)type_ids.get(valueType);
            set.add(value);
        }
        return type_ids;
    }
}

