/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.jsoup.parser;

import com.kingdee.eas.fm.common.jsoup.helper.DescendableLinkedList;
import com.kingdee.eas.fm.common.jsoup.helper.Validate;
import com.kingdee.eas.fm.common.jsoup.nodes.Document;
import com.kingdee.eas.fm.common.jsoup.nodes.Element;
import com.kingdee.eas.fm.common.jsoup.parser.CharacterReader;
import com.kingdee.eas.fm.common.jsoup.parser.ParseErrorList;
import com.kingdee.eas.fm.common.jsoup.parser.Token;
import com.kingdee.eas.fm.common.jsoup.parser.Tokeniser;

abstract class TreeBuilder {
    CharacterReader reader;
    Tokeniser tokeniser;
    protected Document doc;
    protected DescendableLinkedList<Element> stack;
    protected String baseUri;
    protected Token currentToken;
    protected ParseErrorList errors;

    TreeBuilder() {
    }

    protected void initialiseParse(String input, String baseUri, ParseErrorList errors) {
        Validate.notNull(input, "String input must not be null");
        Validate.notNull(baseUri, "BaseURI must not be null");
        this.doc = new Document(baseUri);
        this.reader = new CharacterReader(input);
        this.errors = errors;
        this.tokeniser = new Tokeniser(this.reader, errors);
        this.stack = new DescendableLinkedList();
        this.baseUri = baseUri;
    }

    Document parse(String input, String baseUri) {
        return this.parse(input, baseUri, ParseErrorList.noTracking());
    }

    Document parse(String input, String baseUri, ParseErrorList errors) {
        this.initialiseParse(input, baseUri, errors);
        this.runParser();
        return this.doc;
    }

    protected void runParser() {
        Token token;
        do {
            token = this.tokeniser.read();
            this.process(token);
        } while (token.type != Token.TokenType.EOF);
    }

    protected abstract boolean process(Token var1);

    protected Element currentElement() {
        return (Element)this.stack.getLast();
    }
}

