/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.query.upgrande;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.CustomerParams;
import com.kingdee.eas.base.commonquery.upgrade.IUpgrade;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.query.OldParamLoaderException;
import com.kingdee.eas.fm.common.client.query.QuerySolutionConvert;
import com.kingdee.eas.fm.common.client.query.SetPropertyException;
import com.kingdee.eas.fm.common.client.query.UnSerialException;
import com.kingdee.eas.fm.common.query.upgrande.FilterUIAndFilterParamMapping;
import com.kingdee.eas.fm.common.query.upgrande.NewParamSaveException;
import com.kingdee.eas.framework.report.RptFilterCollection;
import com.kingdee.eas.framework.report.RptFilterInfo;
import com.kingdee.eas.framework.report.RptFilterUtils;
import com.kingdee.eas.framework.report.util.RptParamsUtil;
import com.kingdee.eas.util.client.EASResource;
import com.sun.xml.messaging.saaj.util.ByteInputStream;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.log4j.Logger;

public class FmQuerySolutionUpgrande
implements IUpgrade {
    private static final Logger LOGGER = CoreUIObject.getLogger(FmQuerySolutionUpgrande.class);
    private static final Map<String, String> filterUIAndFilterParamRelation = FilterUIAndFilterParamMapping.getFilterUIAndFilterParamRelation();

    public String getQuerySql() {
        return "SELECT T_QUERY_QUERYPANEL.FID,T_QUERY_QUERYSOLUTION.FNAME_L2 FSolutionName,FPANELCLASSNAME,FCUSTOMERPARAMS FROM T_QUERY_QUERYSOLUTION INNER JOIN T_QUERY_QUERYPANEL ON T_QUERY_QUERYSOLUTION.FID=T_QUERY_QUERYPANEL.FSOLUTIONID WHERE (T_QUERY_QUERYSOLUTION.fparentuiname like 'com.kingdee.eas.fm.%' or T_QUERY_QUERYSOLUTION.fparentuiname like 'com.kingdee.eas.fi.cas.%' or T_QUERY_QUERYSOLUTION.fparentuiname='com.kingdee.eas.basedata.assistant.client.DestroyAccountApplyListUI' or T_QUERY_QUERYSOLUTION.fparentuiname='com.kingdee.eas.basedata.assistant.client.AccountApplyBillListUI' or T_QUERY_QUERYSOLUTION.fparentuiname='com.kingdee.eas.basedata.assistant.client.RptAccountBankDetailMainUI')" + EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"146_FmQuerySolutionUpgrande") + " AND (NOT (fcustomerparams is null))";
    }

    public boolean isNeedConvert(CustomerParams oldCustomerParam) {
        return oldCustomerParam != null && !this.isNewQuerySolution(oldCustomerParam);
    }

    public CustomerParams getNewCustomerParam(String filterUIClassName, CustomerParams oldCustomerParam) throws OldParamLoaderException, NewParamSaveException {
        System.out.println(String.format("begin upgrade:FilterUI is [%s]", filterUIClassName));
        Object param = this.getFmBizFilterParam(filterUIClassName, oldCustomerParam);
        CustomerParams newCustomerParams = this.convertToCustomerParams(param);
        System.out.println(String.format("upgrade sucessfully:FilterUI is [%s]", filterUIClassName));
        return newCustomerParams;
    }

    private boolean isFoundMapping(String filterUIClassName) {
        return !EmptyUtil.isEmpty((String)this.getMapping(filterUIClassName));
    }

    private String getMapping(String filterUIClassName) {
        return filterUIAndFilterParamRelation.get(filterUIClassName);
    }

    private Object getFmBizFilterParam(String filterUIClassName, CustomerParams cp) throws OldParamLoaderException {
        if (!this.isFoundMapping(filterUIClassName)) {
            throw new RuntimeException(String.format("ERROR type [Mapping lose]:[%s]'s FilterParam mapping not found!", filterUIClassName));
        }
        if (this.isRptParams(cp)) {
            System.out.println(String.format("[%s]-[%s] is RPT Params query solution upgrande!", filterUIClassName, this.getMapping(filterUIClassName)));
            Object param = this.getRPTSolution(cp);
            return param;
        }
        if (this.isSingleSolution(cp)) {
            System.out.println(String.format("[%s]-[%s] is Single Params query solution upgrande!", filterUIClassName, this.getMapping(filterUIClassName)));
            return this.getSingleSolution(cp);
        }
        System.out.println(String.format("[%s]-[%s] is Multiple Params query solution upgrande!", filterUIClassName, this.getMapping(filterUIClassName)));
        return this.getMultiSolution(this.getMapping(filterUIClassName), cp);
    }

    private boolean isRptParams(CustomerParams cp) {
        return cp.getCustomerParam("RPTPARAMS_KEY_AT_CUSTOMERPARAMS") != null;
    }

    private Object getRPTSolution(CustomerParams cp) throws OldParamLoaderException {
        try {
            Object param = RptParamsUtil.getFromCustomerParams((com.kingdee.eas.base.commonquery.client.CustomerParams)this.cast(cp));
            param = param instanceof RptFilterInfo || param instanceof RptFilterCollection || param instanceof RptFilterInfo[] || param instanceof RptFilterCollection[] ? RptFilterUtils.toObjectFromRptFilterMap((Object)RptParamsUtil.getFromCustomerParams((com.kingdee.eas.base.commonquery.client.CustomerParams)this.cast(cp))) : RptParamsUtil.getFromCustomerParams((com.kingdee.eas.base.commonquery.client.CustomerParams)this.cast(cp));
            return param;
        }
        catch (EASBizException e) {
            throw new OldParamLoaderException(String.format("Load old query solution error!Query solution type is [%s]!key is [%s]!", "RPT Params", "RPTPARAMS_KEY_AT_CUSTOMERPARAMS"), e);
        }
    }

    private boolean isSingleSolution(CustomerParams cp) {
        return this.getSingleSolutionValue(cp) != null;
    }

    private Object getSingleSolution(CustomerParams cp) throws OldParamLoaderException {
        try {
            return this.getUnSerialValue(this.getSingleSolutionValue(cp));
        }
        catch (Exception e) {
            throw new OldParamLoaderException(String.format("Load old query solution error!Query solution type is [%s]!key is [%s]!", "Single Params", "fmcustomer"), e);
        }
    }

    private String getSingleSolutionValue(CustomerParams cp) {
        return cp.getCustomerParam("fmcustomer");
    }

    private Object getMultiSolution(String paramClassName, CustomerParams cp) throws OldParamLoaderException {
        try {
            Class<?> paramClass = Class.forName(paramClassName);
            PropertyDescriptor[] properties = PropertyUtils.getPropertyDescriptors(paramClass);
            Object resultParam = paramClass.newInstance();
            for (PropertyDescriptor property : properties) {
                String key = property.getName();
                String value = cp.getCustomerParam(key);
                try {
                    this.setValue(property, resultParam, key, value);
                }
                catch (Exception e) {
                    String msg = String.format("Field error!Load old query solution'field error!Class is [%s]!field name is [%s]!", paramClass.getName(), key);
                    LOGGER.error((Object)msg, (Throwable)e);
                    throw new OldParamLoaderException(msg, e);
                }
            }
            return resultParam;
        }
        catch (Exception e) {
            String msg = String.format("Load old query solution error!Query solution type is [%s]!Class is [%s]!", "Multiple Params", paramClassName);
            LOGGER.error((Object)msg, (Throwable)e);
            throw new OldParamLoaderException(msg, e);
        }
    }

    private void setValue(PropertyDescriptor property, Object param, String key, String value) throws UnSerialException, SetPropertyException {
        Object unSerialValue;
        Object object = unSerialValue = EmptyUtil.isEmpty((String)value) ? null : this.getUnSerialValue(value);
        if (property.getReadMethod() != null && property.getWriteMethod() != null) {
            try {
                if (EmptyUtil.isEmpty((Object)unSerialValue) && this.isBaseType(property)) {
                    PropertyUtils.setNestedProperty((Object)param, (String)key, (Object)0);
                } else if (EmptyUtil.isEmpty((Object)unSerialValue) && property.getPropertyType().equals(Boolean.TYPE)) {
                    PropertyUtils.setNestedProperty((Object)param, (String)key, (Object)Boolean.FALSE);
                } else if (EmptyUtil.isEmpty((Object)unSerialValue) && property.getPropertyType().equals(Character.TYPE)) {
                    PropertyUtils.setNestedProperty((Object)param, (String)key, (Object)Character.valueOf(' '));
                } else {
                    PropertyUtils.setNestedProperty((Object)param, (String)key, (Object)unSerialValue);
                }
            }
            catch (Exception e) {
                String msg = String.format("Property setValue() error!Class is [%s]!key is [%s]!value is [%s]!", param.getClass().getName(), key, value);
                throw new SetPropertyException(msg, e);
            }
        }
    }

    private boolean isBaseType(PropertyDescriptor property) {
        return property.getPropertyType().equals(Byte.TYPE) || property.getPropertyType().equals(Short.TYPE) || property.getPropertyType().equals(Integer.TYPE) || property.getPropertyType().equals(Long.TYPE) || property.getPropertyType().equals(Float.TYPE) || property.getPropertyType().equals(Double.TYPE);
    }

    private boolean isNewQuerySolution(CustomerParams cp) {
        return cp.getCustomerParam(QuerySolutionConvert.FM_NEW_QUERY_SULUTION) != null;
    }

    private Object getUnSerialValue(String paramValue) throws UnSerialException {
        Object param = null;
        ObjectInputStream objectIs = null;
        try {
            byte[] bytes = FMHelper.decode(paramValue.getBytes());
            ByteInputStream byteIs = new ByteInputStream(bytes, bytes.length);
            objectIs = new ObjectInputStream((InputStream)byteIs);
            param = objectIs.readObject();
        }
        catch (Exception e) {
            throw new UnSerialException(e);
        }
        finally {
            if (objectIs != null) {
                try {
                    objectIs.close();
                }
                catch (IOException e) {
                    throw new UnSerialException(e);
                }
            }
        }
        return param;
    }

    private CustomerParams convertToCustomerParams(Object param) throws NewParamSaveException {
        CustomerParams newCustomerParam;
        QuerySolutionConvert convert = new QuerySolutionConvert();
        try {
            newCustomerParam = this.cast(convert.convertToCustomerParams(param));
        }
        catch (Exception e) {
            throw new NewParamSaveException("New query solution parse error!", e);
        }
        return newCustomerParam;
    }

    private CustomerParams cast(com.kingdee.eas.base.commonquery.client.CustomerParams customerParams) {
        return customerParams.castToCommonCustomerParams();
    }

    private com.kingdee.eas.base.commonquery.client.CustomerParams cast(CustomerParams customerParams) {
        com.kingdee.eas.base.commonquery.client.CustomerParams cp = new com.kingdee.eas.base.commonquery.client.CustomerParams();
        cp.setHm((HashMap)customerParams.getCustomerParamsHashMap().clone());
        return cp;
    }
}

