/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.task;

import com.kingdee.bos.Context;
import com.kingdee.eas.fm.common.task.IFMTaskRunnerAdapter;
import com.kingdee.eas.tools.datatask.ReturnInfo;
import com.kingdee.eas.tools.datatask.TaskStateEnum;
import com.kingdee.eas.tools.datatask.log.TaskLog;
import com.kingdee.eas.tools.datatask.log.TaskLogUtil;
import com.kingdee.eas.tools.datatask.task.ITask;
import com.kingdee.eas.tools.datatask.task.util.TaskRunnerException;
import com.kingdee.eas.tools.datatask.util.EASServerResource;
import java.util.Locale;

public abstract class FMTaskAbstractRunnerAdapter
implements IFMTaskRunnerAdapter {
    protected Context ctx;
    protected Locale locale;
    protected ITask task;
    protected String runStats;
    protected TaskLog tl = new TaskLog(0);
    protected boolean needInitCountFlag = true;

    public FMTaskAbstractRunnerAdapter(ITask task) {
        this(task, null);
    }

    public FMTaskAbstractRunnerAdapter(ITask task, Context ctx) {
        this.ctx = ctx;
        if (this.ctx != null) {
            this.locale = ctx.getLocale();
        }
        this.task = task;
        this.runStats = "";
    }

    public void setTaskLog(TaskLog log) {
        this.tl = log;
        this.needInitCountFlag = false;
    }

    public TaskLog getTaskLog() {
        return this.tl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReturnInfo run() throws Exception {
        ReturnInfo result = new ReturnInfo();
        try {
            this.onInitResources();
            result = this.onMainRunningProcess();
            this.handSuccess();
        }
        catch (TaskRunnerException ex) {
            if (ex.getExceptionCode() == 4) {
                String errMsg = this.getFatalError();
                this.tl.addException(errMsg, (Throwable)ex, null);
                this.tl.setTaskState(TaskStateEnum.FAILEND);
                TaskLogUtil.putLog((TaskLog)this.tl);
            }
        }
        catch (Exception e) {
            String errMsg = EASServerResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"fatalError", (Locale)this.locale);
            if (e.getMessage() != null) {
                errMsg = errMsg + "\u3002" + e.getMessage();
            }
            this.tl.addException(errMsg, (Throwable)e, null);
            this.tl.setTaskState(TaskStateEnum.FAILEND);
            TaskLogUtil.putLog((TaskLog)this.tl);
        }
        finally {
            this.onFinishingRunning();
        }
        return result;
    }

    protected String getFatalError() {
        return EASServerResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"fatalError", (Locale)this.locale);
    }

    private void handFatelError(Exception ex) throws Exception {
        String msg = EASServerResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"runningTask", (Locale)this.locale) + this.task.getName() + EASServerResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"restart", (Locale)this.locale);
        msg = msg + ex.getMessage();
    }

    private void handSuccess() {
    }

    public void setTask(ITask task) {
        this.task = task;
    }

    public ITask getTask() {
        return this.task;
    }

    protected abstract void onFinishingRunning() throws TaskRunnerException;

    protected abstract ReturnInfo onMainRunningProcess() throws TaskRunnerException;

    protected abstract void onInitResources() throws TaskRunnerException;
}

