/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.task;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.fm.common.task.FMTaskIERunner;
import com.kingdee.eas.fm.nt.ReceivableBillCollection;
import com.kingdee.eas.fm.nt.ReceivableBillFactory;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.DefaultDataTransmission;
import com.kingdee.eas.tools.datatask.ErrorHandleModeEnum;
import com.kingdee.eas.tools.datatask.IDataTransmission;
import com.kingdee.eas.tools.datatask.ReturnInfo;
import com.kingdee.eas.tools.datatask.TaskStateEnum;
import com.kingdee.eas.tools.datatask.log.SysLog;
import com.kingdee.eas.tools.datatask.log.TaskLog;
import com.kingdee.eas.tools.datatask.log.TaskLogUtil;
import com.kingdee.eas.tools.datatask.runtime.AbstractExternalDataReader;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.tools.datatask.runtime.ExcelXErrorDataWriter;
import com.kingdee.eas.tools.datatask.runtime.ExternalExcelXDataReader;
import com.kingdee.eas.tools.datatask.runtime.ExternalStructInfo;
import com.kingdee.eas.tools.datatask.task.BlockDataInfo;
import com.kingdee.eas.tools.datatask.task.FileUtil;
import com.kingdee.eas.tools.datatask.task.ITask;
import com.kingdee.eas.tools.datatask.task.ReaderUtil;
import com.kingdee.eas.tools.datatask.task.TaskExternalCode;
import com.kingdee.eas.tools.datatask.task.TaskExternalCodeRunner;
import com.kingdee.eas.tools.datatask.task.TaskUtil;
import com.kingdee.eas.tools.datatask.task.util.TaskRunnerException;
import com.kingdee.eas.tools.datatask.util.EASServerResource;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class FMTaskExternalCodeRunner
extends FMTaskIERunner {
    private static Logger logger = SysLog.getLogger(TaskExternalCodeRunner.class);
    private AbstractExternalDataReader reader;
    private ExcelXErrorDataWriter errDataWriter;
    private boolean hasErrorFile = false;
    private Map hsData;
    private IDataTransmission iDataTrans;
    private InputStream file;
    private boolean isCodeImplementTrans = true;
    private boolean isUserDefineTrans = false;
    private boolean isScriptTrans = false;
    private DefaultDataTransmission defaultTrans = null;
    private BlockDataInfo bdInfo = null;
    private int submittype = 0;
    private Set<String> numberSet = new HashSet<String>();

    public FMTaskExternalCodeRunner(ITask task) {
        super(task, null);
    }

    public FMTaskExternalCodeRunner(ITask task, Context ctx) {
        super(task, ctx);
    }

    @Override
    protected ReturnInfo onMainRunningProcess() throws TaskRunnerException {
        ReturnInfo result = new ReturnInfo();
        try {
            if (this.continueCondition) {
                this.onBeforeEachRunningLoop();
            }
        }
        catch (TaskRunnerException ex) {
            logger.error((Object)ex);
            this.onDataError(ex);
        }
        this.onRecordProcess4Match();
        if (this.numberSet.size() > 0) {
            result.setData(this.numberSet);
        }
        return result;
    }

    private void onRecordProcess4Match() throws TaskRunnerException {
        while (this.hasMoreRecord() && this.continueCondition) {
            ++this.nCurCount;
            try {
                this.onEachRunningLoop();
                if (this.nSuccessCount % 100 != 0) continue;
                this.tl.setSuccessRecordCount(this.nSuccessCount);
            }
            catch (Throwable ex) {
                ++this.nFailCount;
                this.onDataError(ex);
            }
        }
        if (this.nSuccessCount % 100 != 0) {
            this.tl.setSuccessRecordCount(this.nSuccessCount);
        }
        if (this.nFailCount <= 0) {
            this.tl.setTaskState(TaskStateEnum.SUCCESSEND);
        } else {
            this.tl.setTaskState(TaskStateEnum.FAILEND);
        }
        TaskLogUtil.putLog((TaskLog)this.tl);
    }

    @Override
    protected Object onEachRunningLoop() throws TaskRunnerException {
        Object o = new Object();
        this.hsData = this.reader.getNext();
        if (this.hsData == null || this.hsData.isEmpty()) {
            return null;
        }
        String draftNumber = (String)((DataToken)this.hsData.get((Object)"FDraftNumber")).data;
        if (!EmptyUtil.isEmpty((String)draftNumber)) {
            try {
                EntityViewInfo view = new EntityViewInfo();
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("id");
                view.setSelector(selector);
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("draftNumber", (Object)draftNumber));
                view.setFilter(filter);
                ReceivableBillCollection coll = ReceivableBillFactory.getLocalInstance((Context)this.ctx).getReceivableBillCollection(view);
                if (EmptyUtil.isEmpty((AbstractObjectCollection)coll)) {
                    throw new TaskRunnerException(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"699_DraftSignInControllerBean", (Locale)this.ctx.getLocale()) + draftNumber + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"1088_FMTaskExternalCodeRunner", (Locale)this.ctx.getLocale()));
                }
                if (!this.numberSet.contains(draftNumber)) {
                    o = draftNumber;
                    this.numberSet.add(draftNumber);
                }
            }
            catch (BOSException e) {
                throw new TaskRunnerException(e.getMessage());
            }
        }
        ++this.nSuccessCount;
        return o;
    }

    @Override
    protected void onInitResources() throws TaskRunnerException {
        ErrorHandleModeEnum errorHandleMode;
        super.onInitResources();
        TaskExternalCode taskCode = (TaskExternalCode)this.task;
        DatataskParameter dp = (DatataskParameter)taskCode.getTaskParameter();
        String fileType = dp.getFileType();
        try {
            this.file = FileUtil.getServerTmpFileStream((String)dp.getOpenFileName());
            this.reader = ReaderUtil.buildReader((String)fileType, (String)dp.getOpenFileName(), (Locale)this.ctx.getLocale(), (String)dp.alias, (InputStream)this.file, (ExternalStructInfo)taskCode.getExternalStructInfo());
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            String errorMsg = ex.getMessage();
            if (errorMsg == null || errorMsg.trim().length() == 0) {
                errorMsg = EASServerResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"notstandardtemplate", (Locale)this.locale);
            }
            throw new TaskRunnerException(4, errorMsg, (Throwable)ex);
        }
        if (this.reader instanceof ExternalExcelXDataReader && (errorHandleMode = (ErrorHandleModeEnum)dp.getContextParam().get("errorHandleMode")) == ErrorHandleModeEnum.ReturnWhenFinish) {
            this.hasErrorFile = true;
            this.errDataWriter = new ExcelXErrorDataWriter();
            this.errDataWriter.setLocacle(this.locale);
            this.errDataWriter.setFileName(dp.getErrDataFileName());
            this.errDataWriter.setSheetName(dp.alias);
            this.errDataWriter.openWriter();
            this.errDataWriter.writeStruct(taskCode.getExternalStructInfo());
        }
    }

    protected int getSubmitType() {
        if (this.iDataTrans != null) {
            return this.iDataTrans.getSubmitType();
        }
        if (this.defaultTrans != null) {
            return this.defaultTrans.getSubmitType();
        }
        return 0;
    }

    @Override
    protected void onBeforeEachRunningLoop() throws TaskRunnerException {
        super.onBeforeEachRunningLoop();
        TaskExternalCode taskCode = (TaskExternalCode)this.task;
        this.isCodeImplementTrans = TaskUtil.isCodeImplementTrans((TaskExternalCode)taskCode);
        this.isUserDefineTrans = TaskUtil.isUserDefineTrans((TaskExternalCode)taskCode);
        this.isScriptTrans = TaskUtil.isScriptTrans((TaskExternalCode)taskCode);
        if (this.isCodeImplementTrans) {
            this.iDataTrans = this.createDataTransmissionObject();
        }
        this.defaultTrans = new DefaultDataTransmission(this.ctx);
        this.defaultTrans.setDIETemplateInfo(taskCode.getDIETemplateInfo());
        this.defaultTrans.setContext(this.ctx);
        HashMap<String, Integer> contextParam = new HashMap<String, Integer>();
        DatataskParameter dp = (DatataskParameter)taskCode.getTaskParameter();
        Map myParam = dp.getContextParam();
        if (myParam != null) {
            contextParam.putAll(myParam);
        }
        contextParam.put("DATATASKMODE", new Integer(dp.datataskMode));
        this.defaultTrans.setContextParameter(contextParam);
        this.submittype = this.getSubmitType();
    }

    @Override
    protected void onFinishingRunning() throws TaskRunnerException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
        if (this.hasErrorFile && this.errDataWriter != null) {
            this.errDataWriter.closeWriter();
        }
        if (this.file != null) {
            try {
                this.file.close();
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
            this.file = null;
        }
        TaskExternalCode taskCode = (TaskExternalCode)this.task;
        DatataskParameter dp = (DatataskParameter)taskCode.getTaskParameter();
        if (!this.isMultiSheetImport()) {
            FileUtil.removeFile((String)dp.getOpenFileName());
        }
    }

    protected boolean isMultiSheetImport() {
        TaskExternalCode taskCode = (TaskExternalCode)this.task;
        DatataskParameter dp = (DatataskParameter)taskCode.getTaskParameter();
        Object o = dp.getContextParam().get("isMultiSheetImport");
        if (o != null && o instanceof Boolean) {
            return (Boolean)o;
        }
        return false;
    }

    private IDataTransmission createDataTransmissionObject() throws TaskRunnerException {
        TaskExternalCode taskCode = (TaskExternalCode)this.task;
        IDataTransmission iObject = null;
        try {
            Class<?> classDefinition = Class.forName(taskCode.getDataTransmissionClassName());
            iObject = (IDataTransmission)classDefinition.newInstance();
            HashMap<String, Integer> contextParam = new HashMap<String, Integer>();
            DatataskParameter dp = (DatataskParameter)taskCode.getTaskParameter();
            Map myParam = dp.getContextParam();
            if (myParam != null) {
                contextParam.putAll(myParam);
            }
            contextParam.put("DATATASKMODE", new Integer(dp.datataskMode));
            iObject.setContextParameter(contextParam);
        }
        catch (Exception e) {
            logger.error((Object)e);
            String detail = EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"create") + taskCode.getDataTransmissionClassName() + EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"createException");
            detail = detail + e.getMessage();
            throw new TaskRunnerException(4, detail, (Throwable)e);
        }
        return iObject;
    }

    @Override
    protected String getMsgOnDataErr() {
        String sheetName = "";
        if (this.isMultiSheetImport()) {
            sheetName = this.getSheetName();
        }
        String rowNumber = String.valueOf(this.nCurCount);
        if (this.bdInfo != null) {
            rowNumber = this.bdInfo.getStardRow() != this.bdInfo.getEndRow() ? String.valueOf(this.bdInfo.getStardRow() + "-" + this.bdInfo.getEndRow()) : String.valueOf(this.bdInfo.getStardRow());
        }
        return sheetName + EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"1089_FMTaskExternalCodeRunner") + rowNumber + EASServerResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"lineData", (Locale)this.locale);
    }

    private String getSheetName() {
        TaskExternalCode taskCode = (TaskExternalCode)this.task;
        DatataskParameter dp = (DatataskParameter)taskCode.getTaskParameter();
        return new StringBuffer(EASServerResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"whenimportfile", (Locale)this.locale)).append(dp.alias).append(EASServerResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"somesheet", (Locale)this.locale)).toString();
    }

    @Override
    protected String getFatalError() {
        String sheetName = "";
        if (this.isMultiSheetImport()) {
            sheetName = this.getSheetName();
        }
        return sheetName + EASServerResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"fatalError", (Locale)this.locale);
    }

    @Override
    protected boolean hasMoreRecord() throws TaskRunnerException {
        return this.reader.hasNext();
    }

    @Override
    protected void onDataError(Throwable ex) throws TaskRunnerException {
        if (ex instanceof TaskRunnerException && ((TaskRunnerException)ex).getExceptionCode() == 4) {
            throw (TaskRunnerException)ex;
        }
        String errMsg = this.getMsgOnDataErr();
        if (this.nFailCount > 100) {
            ex = new TaskRunnerException(ex.getMessage());
        }
        if (this.submittype == 1 && this.bdInfo != null) {
            int startRowNum = this.bdInfo.getStardRow();
            int endRowNum = this.bdInfo.getEndRow();
            this.tl.addExceptionForBlock(errMsg, ex, Integer.valueOf(startRowNum), Integer.valueOf(endRowNum));
        } else {
            this.tl.addException(errMsg, ex, Integer.valueOf(this.nCurCount));
        }
        this.tl.setFailRecordCount(this.nFailCount);
        TaskLogUtil.putLog((TaskLog)this.tl);
        this.dataErrorHandle(ex);
    }

    @Override
    protected void onDataErrorStop(Throwable ex) {
        super.onDataErrorStop(ex);
        if (this.reader instanceof ExternalExcelXDataReader) {
            ((ExternalExcelXDataReader)this.reader).interruptExcelXParseThread();
        }
    }

    @Override
    protected void onDataErrorSkip(Throwable ex) {
        super.onDataErrorSkip(ex);
        if (this.reader instanceof ExternalExcelXDataReader && this.hasErrorFile) {
            String errFieldDesc;
            DataToken value = new DataToken();
            value.name = "ErrorReason";
            value.desc = errFieldDesc = EASServerResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"errorReason", (Locale)this.locale);
            try {
                if (this.submittype == 1) {
                    Map hsData = null;
                    for (int i = 0; i < this.bdInfo.getData().size(); ++i) {
                        hsData = (Map)this.bdInfo.getData().get(i);
                        String cellValue = ex.getMessage();
                        value.data = cellValue == null ? "" : cellValue.trim();
                        hsData.put("ErrorReason", value);
                        this.errDataWriter.writeLine(hsData);
                    }
                } else {
                    int lastIndex = this.tl.getErrorDetailCount() - 1;
                    String cellValue = this.tl.getErrorDetail(lastIndex);
                    value.data = cellValue == null ? "" : cellValue.trim();
                    this.hsData.put("ErrorReason", value);
                    this.errDataWriter.writeLine(this.hsData);
                }
            }
            catch (TaskRunnerException e) {
                logger.error((Object)e);
            }
        }
    }
}

