/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.IntRateTypeExpressionEnum;
import com.kingdee.eas.fm.common.IntReceivedBillTypeEnum;
import com.kingdee.eas.fm.common.util.AccrualCalculateInterface;
import com.kingdee.eas.fm.common.util.AccrualCalculate_PayDeposit;
import com.kingdee.eas.fm.common.util.AccrualCalculate_PreDrawing;
import com.kingdee.eas.fm.common.util.AccrualCalculate_ReDeposit;
import com.kingdee.eas.fm.common.util.AccrualCalculate_UnDeposit;
import com.kingdee.eas.fm.common.util.AccrualCalculator;
import com.kingdee.eas.fm.common.util.AccrualCalculatorElementNeededInfo;
import com.kingdee.eas.fm.common.util.AccrualResultInfo;
import com.kingdee.eas.fm.im.IIntRateBase;
import com.kingdee.eas.fm.im.IntRateBaseFactory;
import com.kingdee.eas.fm.im.IntRateBaseInfo;
import com.kingdee.eas.fm.im.IntRateTypeInfo;
import com.kingdee.eas.fm.im.IntTermFactory;
import com.kingdee.eas.fm.im.IntTermInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.List;

public abstract class AccrualCalculateAdapter
implements AccrualCalculateInterface {
    protected AccrualCalculatorElementNeededInfo acen;
    private final int SCALE = 5;
    private boolean isCalByMonth = false;
    protected Context ctx = null;

    protected AccrualCalculateAdapter(AccrualCalculatorElementNeededInfo acen) {
        this.acen = acen;
        this.checkEmtpy();
    }

    protected abstract void checkEmtpy();

    protected abstract String getMsgHeader();

    protected void showError(String msg) {
        String msgStr = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"166_CanNotBeNullValue"), this.getMsgHeader() + msg);
        MsgBox.showError((String)msgStr);
        SysUtil.abort();
    }

    protected static AccrualCalculateAdapter selectBizCalculator(AccrualCalculatorElementNeededInfo acen) throws FMException {
        AccrualCalculateAdapter aca = null;
        if (acen.getIntReceivedBillTypeEnum() == IntReceivedBillTypeEnum.PRE_DRAWING) {
            aca = new AccrualCalculate_PreDrawing(acen);
        } else if (acen.getIntReceivedBillTypeEnum() == IntReceivedBillTypeEnum.INTBILL_UNTIMEDEPOSIT) {
            aca = new AccrualCalculate_UnDeposit(acen);
        } else if (acen.getIntReceivedBillTypeEnum() == IntReceivedBillTypeEnum.INTBILL_REDEPOSIT) {
            aca = new AccrualCalculate_ReDeposit(acen);
        } else if (acen.getIntReceivedBillTypeEnum() == IntReceivedBillTypeEnum.INTBILL_PAYINTEREST) {
            aca = new AccrualCalculate_PayDeposit(acen);
        }
        if (aca == null) {
            throw new FMException(FMException.UNKOWNTYPE);
        }
        return aca;
    }

    public AccrualResultInfo getCalcuResult(Context ctx, Object calculator) throws FMException {
        this.ctx = ctx;
        if (!(calculator instanceof AccrualCalculator)) {
            throw new FMException(FMException.BADCALCULATER);
        }
        this.setValue_TD001(ctx);
        BigDecimal periodicalAccrual = this.calcPeriodicalAccrual(ctx);
        BigDecimal currentAccrual = this.calcCurrentAccrual(ctx);
        BigDecimal yingJiAccrual = this.calcYingJiAccrual(ctx);
        BigDecimal shiJiAccrual = this.calcShiJiAccrual(ctx);
        BigDecimal unVerifyAmt = this.calcUnVerifyAmt();
        BigDecimal strikedAmt = this.calcStrikedAmt();
        BigDecimal days = this.getIntervalDays();
        return new AccrualResultInfo(periodicalAccrual, currentAccrual, yingJiAccrual, shiJiAccrual, unVerifyAmt, strikedAmt, days);
    }

    @Override
    public BigDecimal calcPeriodicalAccrual(Context ctx) {
        BigDecimal result = Constants.ZERO;
        BigDecimal natualAmt = this.getPrincipal();
        BigDecimal rate = this.getPeriodicalRate(ctx);
        BigDecimal yearDays = this.getYearDays();
        BigDecimal intervalDays = this.getIntervalDays();
        BigDecimal base = this.getBaseNumber();
        int precision = this.getPrecision(ctx);
        if (this.doCalcPeriodicalAccrual() && natualAmt != null && rate != null && yearDays != null && intervalDays != null) {
            BigDecimal tmp = Constants.ZERO;
            tmp = yearDays.multiply(base);
            result = natualAmt.multiply(intervalDays).multiply(rate).divide(tmp, precision, 4);
        }
        return result;
    }

    protected int getPrecision(Context ctx) {
        int precision = 2;
        if (this.acen.getCurrency() != null) {
            try {
                ICurrency iCurrency = null;
                iCurrency = ctx == null ? CurrencyFactory.getRemoteInstance() : CurrencyFactory.getLocalInstance((Context)ctx);
                CurrencyInfo info = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.acen.getCurrency().getId().toString()));
                precision = info.getPrecision();
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        return precision;
    }

    @Override
    public BigDecimal calcCurrentAccrual(Context ctx) {
        BigDecimal result = Constants.ZERO;
        BigDecimal natualAmt = this.getPrincipal();
        BigDecimal rate = this.getCurrentRate();
        BigDecimal yearDays = this.getYearDays();
        BigDecimal intervalDays = this.getCurrentIntervalDays();
        BigDecimal base = this.getBaseNumber();
        int precision = this.getPrecision(ctx);
        if (this.doCalcCurrentAccrual() && natualAmt != null && rate != null && yearDays != null && intervalDays != null) {
            BigDecimal tmp = Constants.ZERO;
            tmp = yearDays.multiply(base);
            result = natualAmt.multiply(intervalDays).multiply(rate).divide(tmp, precision, 4);
        }
        return result;
    }

    protected BigDecimal getYearRate(Context ctx, IntRateTypeInfo intType, BigDecimal floating, CurrencyInfo currency, Date date) throws Exception {
        if (floating == null && intType.getId() == null) {
            return null;
        }
        IIntRateBase iirb = null;
        iirb = ctx == null ? IntRateBaseFactory.getRemoteInstance() : IntRateBaseFactory.getLocalInstance((Context)ctx);
        IntRateBaseInfo intratebase = iirb.getCurRateByCond(intType.getId().toString(), currency.getId().toString(), date);
        if (intratebase == null) {
            return Constants.ZERO;
        }
        if (floating == null) {
            return intratebase.getYearRate();
        }
        return intratebase.getYearRate().add(floating.divide(Constants.ONE_HUNDRED, this.SCALE, 4));
    }

    protected Date getMaxDate(List li) {
        Date beginDate = null;
        Date tmp = null;
        try {
            beginDate = DateTimeUtils.parseDate((String)"1900-01-01");
        }
        catch (ParseException e) {
            SysUtil.abort((Throwable)e);
        }
        for (int i = 0; i < li.size(); ++i) {
            tmp = (Date)li.get(i);
            if (tmp == null || tmp.compareTo(beginDate) < 0) continue;
            beginDate = tmp;
        }
        return beginDate;
    }

    protected Date getMinDate(List li) {
        Date beginDate = null;
        Date tmp = null;
        try {
            beginDate = DateTimeUtils.parseDate((String)"2999-01-01");
        }
        catch (ParseException e) {
            SysUtil.abort((Throwable)e);
        }
        for (int i = 0; i < li.size(); ++i) {
            tmp = (Date)li.get(i);
            if (tmp == null || tmp.compareTo(beginDate) > 0) continue;
            beginDate = tmp;
        }
        return beginDate;
    }

    @Override
    public BigDecimal calcYingJiAccrual(Context ctx) {
        return this.sumPeriodicalAndCurrent(ctx);
    }

    @Override
    public BigDecimal calcShiJiAccrual(Context ctx) {
        return this.sumPeriodicalAndCurrent(ctx);
    }

    private BigDecimal sumPeriodicalAndCurrent(Context ctx) {
        return this.calcPeriodicalAccrual(ctx).add(this.calcCurrentAccrual(ctx));
    }

    @Override
    public BigDecimal calcUnVerifyAmt() {
        return Constants.ZERO;
    }

    @Override
    public BigDecimal calcStrikedAmt() {
        return Constants.ZERO;
    }

    protected BigDecimal getIntervalDays() {
        Date startDate = this.getStartDate();
        Date endDate = this.getEndDate();
        int days = DateUtil.getDiffDays((Date)startDate, (Date)endDate);
        return new BigDecimal(String.valueOf(days));
    }

    protected BigDecimal getCurrentIntervalDays() {
        return Constants.ZERO;
    }

    protected BigDecimal getCurrentRate() {
        return Constants.ZERO;
    }

    protected BigDecimal getYearDays() {
        return this.acen.getYearDays();
    }

    protected boolean isCalByMonth() {
        return this.isCalByMonth;
    }

    private void setValue_TD001(Context ctx) {
        boolean param_FT001;
        IContextHelper iContextHelper = null;
        iContextHelper = ctx == null ? ContextHelperFactory.getRemoteInstance() : ContextHelperFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo currencyCompany = iContextHelper.getCurrentCompany();
        this.isCalByMonth = param_FT001 = iContextHelper.getBooleanParam("TD001", (IObjectPK)new ObjectUuidPK(currencyCompany.getId()));
    }

    public BigDecimal getIntervalDaysByIntTerm() {
        if (this.acen.getIntTerm() == null) {
            return Constants.ZERO;
        }
        IntTermInfo intTermInfo = null;
        try {
            intTermInfo = (IntTermInfo)IntTermFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(this.acen.getIntTerm().getId()));
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        int day = 0;
        switch (intTermInfo.getType().getValue()) {
            case 360: {
                day = intTermInfo.getTerm() * 360;
                break;
            }
            case 30: {
                day = intTermInfo.getTerm() * 30;
                break;
            }
            case 1: {
                day = intTermInfo.getTerm();
                break;
            }
        }
        return new BigDecimal(String.valueOf(day));
    }

    protected boolean isOther() {
        if (this.acen.getIntTerm() != null) {
            return this.acen.getIntTerm().getId().toString().equals("jhNyIgEWEADgAAr6wKgSC61eI6Y=");
        }
        return false;
    }

    private BigDecimal getBaseNumber() {
        if (this.acen.getIntRateTypeExpressionEnum() != IntRateTypeExpressionEnum.YEAR) {
            return Constants.ONE_THOUSAND;
        }
        return Constants.ONE_HUNDRED;
    }

    protected abstract BigDecimal getPrincipal();

    protected abstract Date getEndDate();

    protected abstract Date getStartDate();

    protected abstract BigDecimal getPeriodicalRate(Context var1);

    protected abstract boolean doCalcPeriodicalAccrual();

    protected abstract boolean doCalcCurrentAccrual();
}

