/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.util;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.fm.common.TimeDepositTypeEnum;
import com.kingdee.eas.fm.common.UnDepositTypeEnum;
import com.kingdee.eas.fm.common.util.AccrualCalculateAdapter;
import com.kingdee.eas.fm.common.util.AccrualCalculatorElementNeededInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.util.Date;

public class AccrualCalculate_ReDeposit
extends AccrualCalculateAdapter {
    public AccrualCalculate_ReDeposit(AccrualCalculatorElementNeededInfo acen) {
        super(acen);
    }

    @Override
    protected BigDecimal getPrincipal() {
        return this.acen.getDepositBalance().subtract(this.acen.getFloorAmt());
    }

    @Override
    protected Date getEndDate() {
        return DateTimeUtils.truncateDate((Date)DateUtil.getBeforeDay((Date)this.acen.getMaturityDate()));
    }

    @Override
    protected Date getStartDate() {
        return DateTimeUtils.truncateDate((Date)this.acen.getEffectedDate());
    }

    @Override
    protected BigDecimal getIntervalDays() {
        if (!this.isCalByMonth()) {
            return this.getDays();
        }
        if (this.acen.getStartDate() != null && this.acen.getUnDepositTypeEnum() == UnDepositTypeEnum.MATURE_UNDEPOSIT && this.acen.getEffectedDate().after(this.acen.getStartDate())) {
            return this.getDays();
        }
        if (this.acen.getStartDate() != null && this.acen.getEffectedDate().after(this.acen.getStartDate())) {
            return this.getDays();
        }
        if (this.acen.getTimeDepositType() != TimeDepositTypeEnum.CALLDEPOSIT_INNER && this.acen.getTimeDepositType() != TimeDepositTypeEnum.CALLDEPOSIT_OUTER && !this.isOther()) {
            return super.getIntervalDaysByIntTerm();
        }
        return this.getDays();
    }

    private BigDecimal getDays() {
        Date startDate = this.getStartDate();
        Date endDate = this.getEndDate();
        long days = DateUtil.dateDiff((String)"d", (Date)startDate, (Date)endDate);
        return new BigDecimal(String.valueOf(days + 1L));
    }

    @Override
    protected BigDecimal getPeriodicalRate(Context ctx) {
        BigDecimal returnValue = Constants.ZERO;
        if (this.acen.getTimeDepositType() == TimeDepositTypeEnum.TIMEDEPOSIT_INNER || this.acen.getTimeDepositType() == TimeDepositTypeEnum.TIMEDEPOSIT_OUTER) {
            returnValue = this.acen.getYearRate();
        } else if (this.acen.getTimeDepositType() == TimeDepositTypeEnum.CALLDEPOSIT_INNER || this.acen.getTimeDepositType() == TimeDepositTypeEnum.CALLDEPOSIT_OUTER) {
            try {
                returnValue = this.getYearRate(ctx, this.acen.getIntRateType(), this.acen.getFloatting(), this.acen.getCurrency(), this.acen.getBizDate());
            }
            catch (Exception e) {
                SysUtil.abort((Throwable)e);
            }
        }
        return returnValue;
    }

    @Override
    protected boolean doCalcPeriodicalAccrual() {
        return true;
    }

    @Override
    protected boolean doCalcCurrentAccrual() {
        return false;
    }

    public BigDecimal calcCurrentAccrual() {
        return Constants.ZERO;
    }

    @Override
    protected void checkEmtpy() {
        if (this.acen.getDepositBalance() == null) {
            this.showError(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"84_AccrualCalculate_PreDrawing"));
        }
        if (this.acen.getMaturityDate() == null) {
            this.showError(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"89_AccrualCalculate_ReDeposit"));
        }
        if (this.acen.getEffectedDate() == null) {
            this.showError(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"90_AccrualCalculate_ReDeposit"));
        }
        if (this.acen.getFloorAmt() == null) {
            this.showError(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"85_AccrualCalculate_PreDrawing"));
        }
        if ((this.acen.getTimeDepositType() == TimeDepositTypeEnum.CALLDEPOSIT_INNER || this.acen.getTimeDepositType() == TimeDepositTypeEnum.CALLDEPOSIT_OUTER) && this.acen.getIntRateType() == null) {
            this.showError(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"91_AccrualCalculate_ReDeposit"));
        }
        if ((this.acen.getTimeDepositType() == TimeDepositTypeEnum.CALLDEPOSIT_INNER || this.acen.getTimeDepositType() == TimeDepositTypeEnum.CALLDEPOSIT_OUTER) && this.acen.getFloatting() == null) {
            this.showError(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"92_AccrualCalculate_ReDeposit"));
        }
        if (this.acen.getCurrency() == null) {
            this.showError(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"86_AccrualCalculate_PreDrawing"));
        }
        if (this.acen.getBizDate() == null) {
            this.showError(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"87_AccrualCalculate_PreDrawing"));
        }
    }

    @Override
    protected String getMsgHeader() {
        return EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"83_AccrualCalculate_PayDeposit");
    }

    @Override
    protected int getPrecision(Context ctx) {
        return super.getPrecision(ctx);
    }
}

