/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.util;

import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.gl.GlUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class BizUnitControlUtil {
    private boolean isBizUnit;
    private String[] whiteList = new String[0];
    private String[] blackList = new String[0];
    private Object source;

    public BizUnitControlUtil(Object sourceUI) {
        this.isBizUnit = GlUtils.isCompanyUnion((CompanyOrgUnitInfo)ContextHelperFactory.getRemoteInstance().getCurrentCompany());
        this.source = sourceUI;
    }

    private String[] getSystemWhiteList() {
        return new String[]{"actionAttachment", "actionPageSetup", "actionPrint", "actionPrintPreview", "actionExitCurrent", "actionFirst", "actionPre", "actionNext", "actionLast", "actionTraceUp", "actionTraceDown", "actionSendMessage", "actionMsgFormat", "actionCalculator", "actionViewDoProccess", "actionWorkFlowG", "actionWorkflowList", "actionNextPerson", "actionAuditResult", "actionSendingMessage", "actionHelp", "actionRegProduct", "actionPersonalSite", "actionProcductVal", "actionAbout", "actionViewBdgBalance", "actionViewUsed", "actionViewBgBalance", "actionViewRate", "actionFeeView", "actionFeeQuery", "actionModifyLetterSearch", "actionViewLetter"};
    }

    public void resetActionWithBlackWhiteList() {
        if (this.isBizUnit) {
            List lstAllList = this.getAllAction();
            for (Field f : lstAllList) {
                ItemAction action;
                if (this.isExistsByList(this.getBlackList(), f.getName())) {
                    try {
                        f.setAccessible(true);
                        action = (ItemAction)f.get(this.source);
                    }
                    catch (Exception e) {
                        continue;
                    }
                    if (action == null) continue;
                    action.setVisible(false);
                    continue;
                }
                if (this.isExistsByList(this.getSystemWhiteList(), f.getName()) || this.isExistsByList(this.getWhiteList(), f.getName())) {
                    try {
                        f.setAccessible(true);
                        action = (ItemAction)f.get(this.source);
                    }
                    catch (Exception e) {
                        continue;
                    }
                    if (action == null) continue;
                    action.setVisible(true);
                    continue;
                }
                try {
                    f.setAccessible(true);
                    action = (ItemAction)f.get(this.source);
                }
                catch (Exception e) {
                    continue;
                }
                if (action == null) continue;
                action.setVisible(false);
            }
        }
    }

    private boolean isExistsByList(String[] list, String name) {
        for (int i = 0; i < list.length; ++i) {
            String s = list[i];
            if (!s.equals(name)) continue;
            return true;
        }
        return false;
    }

    private List getAllAction() {
        ArrayList lst = new ArrayList();
        Class<?> cls = this.source.getClass();
        this.getAllAction(lst, cls);
        return lst;
    }

    private void getAllAction(List lst, Class cls) {
        if (cls.getName().equals("java.lang.Object")) {
            return;
        }
        Field[] fields = cls.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field f = fields[i];
            try {
                f.setAccessible(true);
                Object obj = f.get(this.source);
                if (!(obj instanceof ItemAction)) continue;
                lst.add(f);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.getAllAction(lst, cls.getSuperclass());
    }

    private String[] getWhiteList() {
        return this.whiteList;
    }

    private String[] getBlackList() {
        return this.blackList;
    }

    public void setWhiteList(String[] whiteList) {
        this.whiteList = whiteList;
    }

    public void setBlackList(String[] blackList) {
        this.blackList = blackList;
    }
}

