/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.util;

import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.swing.KDColorChooser;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.eas.fm.common.util.ColorUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;

public class ColorCellEditor
extends KDTDefaultCellEditor {
    public ColorCellEditor() {
        this.initEditor();
    }

    private void initEditor() {
        this.clickCountToStart = 1;
        final KDPanel panel = new KDPanel();
        String resClassName = "com.kingdee.eas.fm.common.FMCommonClientResource";
        final String title = EASResource.getString((String)resClassName, (String)"colorSelector");
        panel.setBackground(Color.WHITE);
        panel.setLayout((LayoutManager)new BorderLayout());
        KDWorkButton button = new KDWorkButton("...");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color color = KDColorChooser.showDialog((Component)panel, (String)title, (Color)panel.getBackground());
                if (color != null) {
                    panel.setBackground(color);
                }
            }
        });
        panel.add((Component)button, (Object)"East");
        this.comp = panel;
        this.delegate = new KDTDefaultCellEditor.EditorDelegate(){

            public void setValue(Object value) {
                if (value == null) {
                    ColorCellEditor.this.comp.setBackground(Color.WHITE);
                } else {
                    String color = value.toString();
                    color = color.substring(color.indexOf(123) + 1, color.indexOf("}"));
                    String[] rgb = color.split(",");
                    int r = Integer.parseInt(rgb[0].trim());
                    int g = Integer.parseInt(rgb[1].trim());
                    int b = Integer.parseInt(rgb[2].trim());
                    ColorCellEditor.this.comp.setBackground(new Color(r, g, b));
                }
            }

            public Object getValue() {
                Color color = ColorCellEditor.this.comp.getBackground();
                return ColorUtil.getColorDesc(color);
            }

            public void initComponent(Object value, Object expandValue, Style style, EventObject anEvent) {
                super.initComponent(value, expandValue, style, anEvent);
            }
        };
    }
}

