/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.client.EASResource;
import java.util.Date;

public class FMARAPUtil {
    public static ExchangeRateInfo getExchangeRate(Context ctx, CompanyOrgUnitInfo companyOrgUnitInfo, CurrencyInfo sourceCur, Date date) throws EASBizException, BOSException {
        IExchangeRate iexchangRate = null;
        ObjectUuidPK excTablepk = null;
        ObjectUuidPK destCurrpk = null;
        if (companyOrgUnitInfo.getBaseExchangeTable() == null) {
            return null;
        }
        excTablepk = new ObjectUuidPK(companyOrgUnitInfo.getBaseExchangeTable().getId());
        CurrencyInfo baseCur = companyOrgUnitInfo.getBaseCurrency();
        if (baseCur != null) {
            if (baseCur.getId().equals((Object)sourceCur.getId())) {
                return null;
            }
        } else {
            return null;
        }
        destCurrpk = new ObjectUuidPK(baseCur.getId());
        iexchangRate = ExchangeRateFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK sourceCurrpk = new ObjectUuidPK(sourceCur.getId());
        ExchangeRateInfo erInfo = iexchangRate.getExchangeRate((IObjectPK)excTablepk, (IObjectPK)sourceCurrpk, (IObjectPK)destCurrpk, date);
        return erInfo;
    }

    public static String getStrResource(String resKey) {
        return EASResource.getString((String)"com.kingdee.eas.fi.ar.ArApBillResource", (String)resKey);
    }

    public static void setPrecision(ICell cell, int precision) {
        if (cell == null) {
            return;
        }
        String sFormat = FMARAPUtil.getNumberFormat(precision);
        cell.getStyleAttributes().setNumberFormat(sFormat);
    }

    public static void setPrecision(IColumn col, int precision) {
        if (col == null) {
            return;
        }
        String sFormat = FMARAPUtil.getNumberFormat(precision);
        col.getStyleAttributes().setNumberFormat(sFormat);
    }

    public static String getNumberFormat(int precision) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < precision; ++i) {
            buffer.append("0");
        }
        String precisionTag = buffer.toString();
        if (precisionTag.length() > 0) {
            precisionTag = "." + precisionTag;
        }
        String format = "#,##0" + precisionTag;
        return format;
    }
}

