/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountRefContrastCollection;
import com.kingdee.eas.basedata.master.account.AccountRefContrastFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountTools;
import com.kingdee.eas.basedata.master.account.IAccountRefContrast;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CasException;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.util.DateTimeUtils;
import java.sql.Timestamp;
import java.util.Date;

public class FetchParamHelper {
    private Context ctx = null;
    private CompanyOrgUnitInfo currentCompany = null;

    public CompanyOrgUnitInfo getCurrentCompany() {
        return this.currentCompany;
    }

    public void setCurrentCompany(CompanyOrgUnitInfo currentCompany) {
        this.currentCompany = currentCompany;
    }

    public FetchParamHelper(Context ctxParam) {
        this.ctx = ctxParam;
    }

    public CompanyOrgUnitInfo getCurrentComapny() {
        if (this.currentCompany != null) {
            return this.currentCompany;
        }
        return ContextHelperFactory.getLocalInstance((Context)this.ctx).getCurrentCompany();
    }

    public PeriodInfo getCurrentPeriod() throws EASBizException, BOSException {
        return SystemStatusCtrolUtils.getCurrentPeriod((Context)this.ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)this.getCurrentComapny());
    }

    public CurrencyCollection getCurrenyCol() throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)1));
        view.setFilter(filter);
        return this.iCurrency().getCurrencyCollection(view, true);
    }

    public String getParamValue_StringType(String paramName) throws EASBizException, BOSException {
        String strValue = this.iParamControl().getParamValue((IObjectPK)new ObjectUuidPK(this.getCurrentComapny().getId().toString()), paramName);
        return strValue;
    }

    public PeriodInfo getStartPeriod() throws EASBizException, BOSException {
        return SystemStatusCtrolUtils.getStartPeriod((Context)this.ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)this.getCurrentComapny());
    }

    private ICurrency iCurrency() throws BOSException {
        ICurrency iCurrency = null;
        iCurrency = this.ctx != null ? CurrencyFactory.getLocalInstance((Context)this.ctx) : CurrencyFactory.getRemoteInstance();
        return iCurrency;
    }

    private IParamControl iParamControl() throws BOSException {
        IParamControl iParamControl = null;
        iParamControl = this.ctx != null ? ParamControlFactory.getLocalInstance((Context)this.ctx) : ParamControlFactory.getRemoteInstance();
        return iParamControl;
    }

    public String getAcctTableId(Context ctx, Date beginDate, Date endDate) throws BOSException, EASBizException {
        String companyid = this.getCurrentComapny().getId().toString();
        AccountRefContrastCollection coll = this.getStrideAcctRefContrastColl(ctx, companyid, beginDate, endDate);
        if (coll == null || coll.isEmpty()) {
            PeriodInfo period = PeriodUtils.getPeriodInfo((Context)ctx, (Date)endDate, (CompanyOrgUnitInfo)this.getCurrentComapny());
            if (period == null) {
                throw new CasException(CasException.PERIODERROR, new Object[]{DateUtil.DateToString((Date)endDate)});
            }
            int yearNumber = period.getPeriodYear();
            int monthNumber = period.getPeriodNumber();
            try {
                AccountTableInfo tbl = this.getCurrentComapny().getAccountTable();
                if (EmptyUtil.isEmpty((CoreBaseInfo)tbl)) {
                    CompanyOrgUnitInfo companyinfo = this.getCurrentComapny();
                    ICompanyOrgUnit companyOrgUnit = null;
                    companyOrgUnit = ctx != null ? CompanyOrgUnitFactory.getLocalInstance((Context)ctx) : CompanyOrgUnitFactory.getRemoteInstance();
                    companyinfo = companyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyinfo.getId().toString()));
                    tbl = companyinfo.getAccountTable();
                }
                String currTableId = AccountTools.getCurrentAcctTable((Context)ctx, (String)companyid, (String)tbl.getId().toString(), (int)yearNumber, (int)monthNumber);
                return currTableId;
            }
            catch (Exception ex) {
                throw new FMException(FMException.HASCOMPANYADJUSTACCT);
            }
        }
        return null;
    }

    public String getAcctTableId(Context ctx, Date beginDate, Date endDate, String companyid) throws BOSException, EASBizException {
        AccountRefContrastCollection coll;
        if (EmptyUtil.isEmpty((String)companyid)) {
            companyid = this.getCurrentComapny().getId().toString();
        }
        if ((coll = this.getStrideAcctRefContrastColl(ctx, companyid, beginDate, endDate)) == null || coll.isEmpty()) {
            PeriodInfo period = PeriodUtils.getPeriodInfo((Context)ctx, (Date)endDate, (CompanyOrgUnitInfo)this.getCurrentComapny());
            if (period == null) {
                throw new CasException(CasException.PERIODERROR, new Object[]{DateUtil.DateToString((Date)endDate)});
            }
            int yearNumber = period.getPeriodYear();
            int monthNumber = period.getPeriodNumber();
            try {
                AccountTableInfo tbl = this.getCurrentComapny().getAccountTable();
                if (EmptyUtil.isEmpty((CoreBaseInfo)tbl)) {
                    CompanyOrgUnitInfo companyinfo = this.getCurrentComapny();
                    ICompanyOrgUnit companyOrgUnit = null;
                    companyOrgUnit = ctx != null ? CompanyOrgUnitFactory.getLocalInstance((Context)ctx) : CompanyOrgUnitFactory.getRemoteInstance();
                    companyinfo = companyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyinfo.getId().toString()));
                    tbl = companyinfo.getAccountTable();
                }
                String currTableId = AccountTools.getCurrentAcctTable((Context)ctx, (String)companyid, (String)tbl.getId().toString(), (int)yearNumber, (int)monthNumber);
                return currTableId;
            }
            catch (Exception ex) {
                throw new FMException(FMException.HASCOMPANYADJUSTACCT);
            }
        }
        return null;
    }

    private AccountRefContrastCollection getStrideAcctRefContrastColl(Context ctx, String companyId, Date beginDate, Date endDate) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("enabledPeriod.endDate", (Object)DateTimeUtils.truncateDate((Date)beginDate), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("enabledPeriod.endDate", (Object)DateTimeUtils.truncateDate((Date)endDate), CompareType.LESS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        IAccountRefContrast acctContrast = AccountRefContrastFactory.getLocalInstance((Context)ctx);
        AccountRefContrastCollection coll = acctContrast.getAccountRefContrastCollection(evi);
        return coll;
    }

    public String getAcctTableId(Context ctx, int beginYear, int beginMonth, int endYear, int endMonth) throws BOSException, EASBizException {
        PeriodInfo beginPeriod = this.getPeriodInfo(ctx, beginYear, beginMonth, this.getCurrentComapny());
        PeriodInfo endPeriod = this.getPeriodInfo(ctx, endYear, endMonth, this.getCurrentComapny());
        if (beginPeriod == null || endPeriod == null) {
            return "PeriodNULL";
        }
        return this.getActualAcctTable(ctx, this.getCurrentComapny(), beginPeriod.getBeginDate(), endPeriod.getEndDate());
    }

    public String getAcctTableId(Context ctx, int beginYear, int beginMonth, int endYear, int endMonth, String companyid) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = null;
        company = !EmptyUtil.isEmpty((String)companyid) ? CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyid)) : this.getCurrentComapny();
        PeriodInfo beginPeriod = this.getPeriodInfo(ctx, beginYear, beginMonth, company);
        PeriodInfo endPeriod = this.getPeriodInfo(ctx, endYear, endMonth, company);
        if (beginPeriod == null || endPeriod == null) {
            return "PeriodNULL";
        }
        return this.getActualAcctTable(ctx, company, beginPeriod.getBeginDate(), endPeriod.getEndDate());
    }

    private PeriodInfo getPeriodInfo(Context ctx, int periodYear, int periodNumber, CompanyOrgUnitInfo companyInfo) throws BOSException, EASBizException {
        if (companyInfo.getAccountPeriodType() == null) {
            return null;
        }
        PeriodInfo info = null;
        IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodYear), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodNumber", (Object)new Integer(periodNumber), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)companyInfo.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2");
        evi.setFilter(filter);
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        if (periodc.size() > 0) {
            info = periodc.get(0);
        }
        return info;
    }

    private String getActualAcctTable(Context ctx, CompanyOrgUnitInfo currentCompany, Date beginDate, Timestamp endDate) throws BOSException, EASBizException {
        String companyid = "";
        companyid = EmptyUtil.isEmpty((CoreBaseInfo)currentCompany) ? this.getCurrentComapny().getId().toString() : currentCompany.getId().toString();
        AccountRefContrastCollection coll = this.getStrideAcctRefContrastColl(ctx, companyid, beginDate, endDate);
        if (coll == null || coll.isEmpty()) {
            PeriodInfo period = PeriodUtils.getPeriodInfo((Context)ctx, (Date)endDate, (CompanyOrgUnitInfo)currentCompany);
            if (period == null) {
                throw new CasException(CasException.PERIODERROR, new Object[]{DateUtil.DateToString((Date)endDate)});
            }
            int yearNumber = period.getPeriodYear();
            int monthNumber = period.getPeriodNumber();
            try {
                AccountTableInfo tbl = this.getCurrentComapny().getAccountTable();
                if (EmptyUtil.isEmpty((CoreBaseInfo)tbl)) {
                    CompanyOrgUnitInfo companyinfo = this.getCurrentComapny();
                    ICompanyOrgUnit companyOrgUnit = null;
                    companyOrgUnit = ctx != null ? CompanyOrgUnitFactory.getLocalInstance((Context)ctx) : CompanyOrgUnitFactory.getRemoteInstance();
                    companyinfo = companyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyinfo.getId().toString()));
                    tbl = companyinfo.getAccountTable();
                }
                String currTableId = AccountTools.getCurrentAcctTable((Context)ctx, (String)companyid, (String)tbl.getId().toString(), (int)yearNumber, (int)monthNumber);
                return currTableId;
            }
            catch (Exception ex) {
                throw new FMException(FMException.HASCOMPANYADJUSTACCT);
            }
        }
        return null;
    }
}

