/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.BankCollection;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.NewOrgUtils;
import com.kingdee.eas.basedata.org.OUException;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.EJBAccessFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.BankTreeSelectUI;
import com.kingdee.eas.fm.common.client.CompanyTreeSelectUI;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class RptFmClientUtil {
    public static final String ROOT_BANK = "36353433-3663-3321-3783-3902578210331C9A9013";

    private RptFmClientUtil() {
    }

    public static KDDialog selectCompany(SelectCompanyListener sl, IMetaDataPK uiPK, IMetaDataPK actionPK, Component p, String[] companyIds) throws Exception {
        KDDialog companySelectDlg = new KDDialog(FMClientHelper.getFrameAncestor(p), true);
        CompanyTreeSelectUI companySelectUI = new CompanyTreeSelectUI(RptFmClientUtil.getCompanyTreeModel(uiPK, actionPK), companyIds);
        companySelectUI.setDialog((JDialog)companySelectDlg);
        companySelectUI.setPreferredSize(companySelectUI.getBounds().getSize());
        companySelectDlg.getContentPane().setLayout(new BorderLayout());
        companySelectDlg.getContentPane().add((Component)((Object)companySelectUI), "Center");
        companySelectDlg.setSize(640, 480);
        CtrlSwingUtilities.centerWindow((Window)companySelectDlg);
        companySelectDlg.setResizable(false);
        companySelectDlg.setTitle(companySelectUI.getUITitle());
        class MyPropertyChangeListener
        implements PropertyChangeListener {
            private SelectCompanyListener sl;

            MyPropertyChangeListener(SelectCompanyListener sl) {
                this.sl = sl;
            }

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("companyChanged")) {
                    try {
                        this.sl.onCompanySelected(AccessHelper.getIds(e.getNewValue()));
                    }
                    catch (Exception e1) {
                        ExceptionHandler.handle((Throwable)e1);
                    }
                }
            }
        }
        companySelectUI.addPropertyChangeListener(new MyPropertyChangeListener(sl));
        return companySelectDlg;
    }

    public static TreeModel getCompanyTreeModel(IMetaDataPK uiPK, IMetaDataPK actionPK, boolean isPermissionEnabled) throws Exception {
        DefaultKingdeeTreeNode kdroot;
        CompanyOrgUnitInfo cuInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (cuInfo == null) {
            throw new OUException(OUException.PARENT_DATA_NOT_COMPLETE);
        }
        TreeModel orgTreeModel = null;
        orgTreeModel = NewOrgUtils.getTreeModel((OrgViewType)OrgViewType.COMPANY, (String)"", (boolean)false, (boolean)false, (boolean)false, (String)cuInfo.getId().toString(), (boolean)isPermissionEnabled, null, (int)0, (IMetaDataPK)uiPK, (IMetaDataPK)actionPK);
        Object root = orgTreeModel.getRoot();
        if (root != null && root instanceof DefaultKingdeeTreeNode && (kdroot = (DefaultKingdeeTreeNode)root).getUserObject() == null) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"14_FmbiRptBaseFilterUI"));
            SysUtil.abort();
        }
        return orgTreeModel;
    }

    public static KDDialog selectCompany(SelectCompanyListener sl, IMetaDataPK uiPK, IMetaDataPK actionPK, Component p, String[] companyIds, boolean isPermissionEnabled) throws Exception {
        KDDialog companySelectDlg = new KDDialog(FMClientHelper.getFrameAncestor(p), true);
        CompanyTreeSelectUI companySelectUI = new CompanyTreeSelectUI(RptFmClientUtil.getCompanyTreeModel(uiPK, actionPK, isPermissionEnabled), companyIds);
        companySelectUI.setDialog((JDialog)companySelectDlg);
        companySelectUI.setPreferredSize(companySelectUI.getBounds().getSize());
        companySelectDlg.getContentPane().setLayout(new BorderLayout());
        companySelectDlg.getContentPane().add((Component)((Object)companySelectUI), "Center");
        companySelectDlg.setSize(640, 480);
        CtrlSwingUtilities.centerWindow((Window)companySelectDlg);
        companySelectDlg.setResizable(false);
        companySelectDlg.setTitle(companySelectUI.getUITitle());
        class MyPropertyChangeListener
        implements PropertyChangeListener {
            private SelectCompanyListener sl;

            MyPropertyChangeListener(SelectCompanyListener sl) {
                this.sl = sl;
            }

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("companyChanged")) {
                    try {
                        this.sl.onCompanySelected(AccessHelper.getIds(e.getNewValue()));
                    }
                    catch (Exception e1) {
                        ExceptionHandler.handle((Throwable)e1);
                    }
                }
            }
        }
        companySelectUI.addPropertyChangeListener(new MyPropertyChangeListener(sl));
        return companySelectDlg;
    }

    public static TreeModel getCompanyTreeModel(IMetaDataPK uiPK, IMetaDataPK actionPK) throws Exception {
        DefaultKingdeeTreeNode kdroot;
        CtrlUnitInfo cuInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        if (cuInfo == null) {
            throw new OUException(OUException.CU_CAN_NOT_NULL);
        }
        TreeModel orgTreeModel = null;
        orgTreeModel = NewOrgUtils.getTreeModel((OrgViewType)OrgViewType.COMPANY, (String)"", (String)cuInfo.getId().toString(), (IMetaDataPK)uiPK, (IMetaDataPK)actionPK);
        Object root = orgTreeModel.getRoot();
        if (root != null && root instanceof DefaultKingdeeTreeNode && (kdroot = (DefaultKingdeeTreeNode)root).getUserObject() == null) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"14_FmbiRptBaseFilterUI"));
            SysUtil.abort();
        }
        return orgTreeModel;
    }

    public static CoreBaseInfo[] getBaseInfoFromIdSet(Set idSet) throws BOSException {
        if (idSet == null || idSet.size() <= 0) {
            return null;
        }
        ICoreBase bizCtrl = EJBAccessFactory.createRemoteInstance().getEntityBizInterface(idSet.toArray()[0].toString());
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        CoreBaseCollection collection = bizCtrl.getCollection(evi);
        CoreBaseInfo[] ovs = new CoreBaseInfo[collection.size()];
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            ovs[i] = collection.get(i);
        }
        return ovs;
    }

    public static KDDialog selectBank(SelectBankListener sl, Component p) throws Exception {
        KDDialog bankSelectDlg = new KDDialog(FMClientHelper.getFrameAncestor(p), true);
        BankTreeSelectUI bankSelectUI = new BankTreeSelectUI(new DefaultTreeModel((TreeNode)RptFmClientUtil.buildTreeByBankCollection(RptFmClientUtil.getBankCollection())));
        bankSelectUI.setDialog((JDialog)bankSelectDlg);
        bankSelectUI.setPreferredSize(bankSelectUI.getBounds().getSize());
        bankSelectDlg.getContentPane().setLayout(new BorderLayout());
        bankSelectDlg.getContentPane().add((Component)((Object)bankSelectUI), "Center");
        bankSelectDlg.setSize(640, 480);
        CtrlSwingUtilities.centerWindow((Window)bankSelectDlg);
        bankSelectDlg.setResizable(false);
        bankSelectDlg.setTitle(bankSelectUI.getUITitle());
        class MyPropertyChangeListener
        implements PropertyChangeListener {
            private SelectBankListener sl;

            MyPropertyChangeListener(SelectBankListener sl) {
                this.sl = sl;
            }

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("bankChanged")) {
                    try {
                        this.sl.onBankSelected((DefaultKingdeeTreeNode)e.getNewValue());
                    }
                    catch (Exception e1) {
                        ExceptionHandler.handle((Throwable)e1);
                    }
                }
            }
        }
        bankSelectUI.addPropertyChangeListener(new MyPropertyChangeListener(sl));
        return bankSelectDlg;
    }

    public static BankCollection getBankCollection() {
        EntityViewInfo vi = new EntityViewInfo();
        FilterInfo fInfo = new FilterInfo();
        vi.setFilter(fInfo);
        SorterItemInfo sorterInfo = new SorterItemInfo("level");
        sorterInfo.setSortType(SortType.ASCEND);
        SorterItemCollection sorterCol = new SorterItemCollection();
        sorterCol.add(sorterInfo);
        vi.setSorter(sorterCol);
        BankCollection bankCollection = null;
        try {
            bankCollection = BankFactory.getRemoteInstance().getBankCollection(vi);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        if (bankCollection == null || bankCollection.size() == 0) {
            return null;
        }
        return bankCollection;
    }

    public static DefaultKingdeeTreeNode buildTreeByBankCollection(BankCollection bc) throws BOSException {
        if (bc == null) {
            return null;
        }
        if (bc.size() == 0) {
            return new DefaultKingdeeTreeNode();
        }
        BankInfo rootBankInfo = new BankInfo();
        rootBankInfo.setName(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"105_RptFmClientUtil"));
        rootBankInfo.setId(BOSUuid.read((String)ROOT_BANK));
        DefaultKingdeeTreeNode rootTreeNode = new DefaultKingdeeTreeNode((Object)rootBankInfo);
        int n = bc.size();
        for (int i = 0; i < n; ++i) {
            RptFmClientUtil.addChildNode(rootTreeNode, bc.get(i));
        }
        return rootTreeNode;
    }

    private static void addChildNode(DefaultKingdeeTreeNode root, BankInfo info) {
        DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode((Object)info);
        DefaultKingdeeTreeNode parent = null;
        if (info.getParent() != null && info.getLevel() > 0) {
            parent = RptFmClientUtil.searchNodeById(root, info.getParent().getId().toString());
        }
        if (parent != null) {
            parent.add((MutableTreeNode)node);
        } else {
            root.add((MutableTreeNode)node);
        }
    }

    private static DefaultKingdeeTreeNode searchNodeById(DefaultKingdeeTreeNode root, String id) {
        BankInfo info = (BankInfo)root.getUserObject();
        if (info != null && !info.isIsLeaf()) {
            if (id.equals(info.getId().toString())) {
                return root;
            }
            for (int i = 0; i < root.getChildCount(); ++i) {
                DefaultKingdeeTreeNode node = RptFmClientUtil.searchNodeById((DefaultKingdeeTreeNode)root.getChildAt(i), id);
                if (node == null) continue;
                return node;
            }
        }
        return null;
    }

    public static Set getIds(Object value) {
        Object[] data = value instanceof Object[] ? (Object[])value : new Object[]{value};
        if (FMHelper.isEmpty(data)) {
            return null;
        }
        HashSet<String> result = new HashSet<String>();
        for (int i = 0; i < data.length; ++i) {
            CoreBaseInfo info = (CoreBaseInfo)data[i];
            if (info.getId() == null) continue;
            result.add(info.getId().toString());
        }
        return result;
    }

    public static interface SelectBankListener {
        public void onBankSelected(DefaultKingdeeTreeNode var1);
    }

    public static interface SelectCompanyListener {
        public void onCompanySelected(String[] var1);
    }
}

