/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.util.JournalBalanceUtil;
import com.kingdee.eas.framework.bireport.util.SimpleTreeNode;
import com.kingdee.eas.framework.report.util.DBUtilx;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.client.EASResource;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class RptFmOtherItemUtil {
    public static List queryIdList(String table, Set excludeSet, Context ctx) throws BOSException, EASBizException {
        SqlParams sp = new SqlParams();
        StringBuffer sql = new StringBuffer();
        sql.append("select FID from ").append(table);
        if (excludeSet != null && excludeSet.size() > 0) {
            sql.append(" where FID not in(");
            Iterator iter = excludeSet.iterator();
            while (iter.hasNext()) {
                sp.addString((String)iter.next());
                sql.append("?,");
            }
            sql.setLength(sql.length() - 1);
            sql.append(")");
        }
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            RptRowSet rs = DBUtilx.executeQuery((String)sql.toString(), (SqlParams)sp, (Context)ctx);
            list.addAll(Arrays.asList(rs.toArray(0)));
        }
        catch (SQLException e) {
            BOSException be = new BOSException();
            be.setStackTrace(e.getStackTrace());
            throw be;
        }
        return list;
    }

    public static String buildCaseWhenSQL(List caseIdList, String caseValue, String tableField) {
        StringBuffer sql = new StringBuffer();
        sql.append(" case when ");
        int n = caseIdList.size();
        for (int i = 0; i < n; ++i) {
            sql.append(tableField).append("='").append(caseIdList.get(i)).append("' ");
            if (i == n - 1) {
                sql.append(" then '").append(caseValue).append("' else ").append(tableField).append(" end ");
                continue;
            }
            sql.append(" or ");
        }
        return sql.toString();
    }

    public static void appendFactCompanyFilter(SimpleTreeNode companyTree, Set selectCompanyIdSet, StringBuffer sql, SqlParams sp) {
        if (companyTree == null || selectCompanyIdSet == null || selectCompanyIdSet.size() == 0) {
            JournalBalanceUtil.appendFilter("FCompanyID", selectCompanyIdSet, sql, sp, "and");
        } else {
            List list = companyTree.dumpNodeTreeValueList();
            HashSet<String> s = new HashSet<String>();
            FullOrgUnitInfo unit = null;
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                unit = ((OrgStructureInfo)list.get(i)).getUnit();
                s.add(unit.getId().toString());
            }
            JournalBalanceUtil.appendFilter("FCompanyID", s, sql, sp, "and");
        }
    }

    public static String buildSelectCompanyFieldPart(SimpleTreeNode companyTree, Set selectCompanyIdSet, String dyField) throws BOSException, EASBizException {
        List idWhenList = RptFmOtherItemUtil._buildFieldWhenSQLList(companyTree, selectCompanyIdSet, "other_company_id", "FCompanyID", false);
        int n = idWhenList.size();
        if (n == 0) {
            return dyField;
        }
        StringBuffer sql = new StringBuffer(" case ");
        for (int i = 0; i < n; ++i) {
            sql.append(idWhenList.get(i));
        }
        sql.append(" else ").append(dyField).append(" end ");
        return sql.toString();
    }

    public static String buildSelectCompanyUnionPart(SimpleTreeNode companyTree, Set selectCompanyIdSet) throws BOSException, EASBizException {
        List idWhenList = RptFmOtherItemUtil._buildFieldWhenSQLList(companyTree, selectCompanyIdSet, "other_company_id", "FID", false);
        int n = idWhenList.size();
        if (n == 0) {
            return "";
        }
        List parentIdWhenList = RptFmOtherItemUtil._buildFieldWhenSQLList(companyTree, selectCompanyIdSet, "other_company_id", "FID", true);
        StringBuffer sql = new StringBuffer();
        String line = null;
        for (int i = 0; i < n; ++i) {
            line = "\n select distinct case " + idWhenList.get(i) + EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"106_RptFmOtherItemUtil") + parentIdWhenList.get(i) + " end FParentId";
            if (i > 0) {
                sql.append("\n union all \n");
            }
            sql.append(line);
            sql.append("\n from t_org_company \n ");
        }
        String tab = "\n union all \n select * from (" + sql.toString() + ") M where M.FID is not null";
        return tab;
    }

    private static List _buildFieldWhenSQLList(SimpleTreeNode root, Set selectedSet, String idKey, String caseFeild, boolean isParentField) {
        String part;
        ArrayList<String> caseWhenList = new ArrayList<String>();
        if (selectedSet == null || selectedSet.size() == 0) {
            return caseWhenList;
        }
        FullOrgUnitInfo unit = ((OrgStructureInfo)root.getValue()).getUnit();
        String parentId = idKey;
        if (isParentField && (parentId = unit.getString("myID")) == null) {
            parentId = unit.getId().toString();
        }
        if ((part = RptFmOtherItemUtil._buildFieldPartCaseSQL(root.childIterator(), selectedSet, parentId, caseFeild)) != null) {
            caseWhenList.add(part);
        }
        int i = 0;
        Iterator iter = root.childIterator();
        while (iter.hasNext()) {
            SimpleTreeNode stn = (SimpleTreeNode)iter.next();
            if (isParentField) {
                caseWhenList.addAll(RptFmOtherItemUtil._buildFieldWhenSQLList(stn, selectedSet, parentId, caseFeild, isParentField));
                continue;
            }
            if (part != null) {
                FullOrgUnitInfo subUnit = ((OrgStructureInfo)stn.getValue()).getUnit();
                boolean withBrotherSelected = false;
                for (int j = 0; j < stn.getChildCount(); ++j) {
                    FullOrgUnitInfo brotherUnit = ((OrgStructureInfo)stn.getChildAt(j).getValue()).getUnit();
                    if (!selectedSet.contains(brotherUnit.getId().toString())) continue;
                    withBrotherSelected = true;
                    break;
                }
                if (!withBrotherSelected) {
                    subUnit.setString("myID", parentId);
                }
            }
            caseWhenList.addAll(RptFmOtherItemUtil._buildFieldWhenSQLList(stn, selectedSet, idKey + "_" + i, caseFeild, isParentField));
            ++i;
        }
        return caseWhenList;
    }

    private static String _buildFieldPartCaseSQL(Iterator nodeIter, Set selectedSet, String idKey, String caseFeild) {
        StringBuffer s = new StringBuffer();
        ArrayList<String> otherIdList = new ArrayList<String>();
        while (nodeIter.hasNext()) {
            OrgStructureInfo org = (OrgStructureInfo)((SimpleTreeNode)nodeIter.next()).getValue();
            String id = org.getUnit().getId().toString();
            if (selectedSet.contains(id)) continue;
            otherIdList.add(id);
        }
        int n = otherIdList.size();
        if (n > 0) {
            s.append(" when ");
            for (int i = 0; i < n; ++i) {
                s.append(caseFeild).append("='").append(otherIdList.get(i)).append("'");
                if (i == n - 1) {
                    s.append(" then '").append(idKey).append("' ");
                    continue;
                }
                s.append(" or ");
            }
            return s.toString();
        }
        return null;
    }

    public static String buildSelectBank(SimpleTreeNode allNode, SimpleTreeNode selectedNode, String tempTable, boolean isDimension, String FID) {
        if (selectedNode == null) {
            return null;
        }
        ArrayList<String> whenList = new ArrayList<String>();
        ArrayList<String> parentWhenList = new ArrayList<String>();
        ArrayList overedList = new ArrayList();
        ArrayList overedListParent = new ArrayList();
        String idKey = "other_bank_id";
        int k = 0;
        selectedNode = selectedNode.getChildAt(0);
        Iterator e = allNode.breadthFirstIterator();
        while (e.hasNext()) {
            SimpleTreeNode node = (SimpleTreeNode)e.next();
            String s = RptFmOtherItemUtil.buildSelectBankWhenSqlList(node, selectedNode, overedList, idKey + "_" + k, FID);
            String ps = RptFmOtherItemUtil.buildSelectBankWhenSqlList(node, selectedNode, overedListParent, ((BankInfo)node.getValue()).getId().toString(), "FID");
            ++k;
            if (s == null) continue;
            whenList.add(s);
            parentWhenList.add(ps);
        }
        int n = whenList.size();
        if (n <= 0) {
            return null;
        }
        StringBuffer line = new StringBuffer();
        StringBuffer sql = new StringBuffer();
        if (isDimension) {
            sql.setLength(0);
            for (int i = 0; i < n; ++i) {
                line.setLength(0);
                line.append("\n select distinct case ").append(whenList.get(i)).append(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"107_RptFmOtherItemUtil")).append(parentWhenList.get(i)).append(" end FParentId");
                if (i > 0) {
                    sql.append("\n union all \n");
                }
                sql.append(line);
                sql.append("\n from ").append(tempTable);
            }
            if (sql.length() <= 0) {
                return null;
            }
            String tab = "\n union all \n select * from (" + sql.toString() + ") M where M.FID is not null";
            return tab;
        }
        sql.setLength(0);
        sql.append(" case ");
        for (int i = 0; i < n; ++i) {
            sql.append(whenList.get(i));
        }
        sql.append(" else ").append(FID).append(" end ");
        return sql.toString();
    }

    private static String buildSelectBankWhenSqlList(SimpleTreeNode allNode, SimpleTreeNode selectedNode, List overedList, String idKey, String FID) {
        ArrayList caseWhenList = new ArrayList();
        StringBuffer part = new StringBuffer();
        if (selectedNode == null) {
            return null;
        }
        for (int i = 0; i < allNode.getChildCount(); ++i) {
            SimpleTreeNode childSelectedNode;
            List idList;
            SimpleTreeNode childAllNode = allNode.getChildAt(i);
            if (overedList.contains(childAllNode) || (idList = RptFmOtherItemUtil.buildList(childAllNode, childSelectedNode = RptFmOtherItemUtil.findNode(childAllNode, selectedNode), overedList)) == null) continue;
            caseWhenList.addAll(idList);
        }
        int n = caseWhenList.size();
        if (n > 0) {
            part.append(" when ");
            for (int i = 0; i < n; ++i) {
                part.append(FID).append("='").append(caseWhenList.get(i)).append("'");
                if (i == n - 1) {
                    part.append(" then '").append(idKey).append("' ");
                    continue;
                }
                part.append(" or ");
            }
            return part.toString();
        }
        return null;
    }

    private static List buildList(SimpleTreeNode childAllNode, SimpleTreeNode childSelectedNode, List overedList) {
        ArrayList<String> whenList = new ArrayList<String>();
        if (childSelectedNode != null) {
            return null;
        }
        Iterator e = childAllNode.breadthFirstIterator();
        while (e.hasNext()) {
            SimpleTreeNode node = (SimpleTreeNode)e.next();
            overedList.add(node);
            BankInfo bankInfo = (BankInfo)node.getValue();
            whenList.add(bankInfo.getId().toString());
        }
        return whenList;
    }

    private static SimpleTreeNode findNode(SimpleTreeNode source, SimpleTreeNode dest) {
        if (source == null || dest == null) {
            return null;
        }
        if (source.getValue() != null && dest.getValue() != null) {
            BankInfo sourceInfo = (BankInfo)source.getValue();
            BankInfo destInfo = (BankInfo)dest.getValue();
            if (sourceInfo.getId().toString().equals(destInfo.getId().toString())) {
                return dest;
            }
        }
        for (int i = 0; i < dest.getChildCount(); ++i) {
            SimpleTreeNode child = dest.getChildAt(i);
            if ((child = RptFmOtherItemUtil.findNode(source, child)) == null) continue;
            return child;
        }
        return null;
    }
}

