/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.util;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.lang.reflect.Method;
import java.math.BigDecimal;

public class TransPrecisionUtil {
    private static String SET_PREFIX = "set";
    private static String GET_PREFIX = "get";
    private static Class[] getterTypes = new Class[0];
    private static Class[] setterTypes = new Class[]{BigDecimal.class};

    public static void trancatePrecision(Context ctx, CoreBaseInfo bill, String[] amtProperties, CurrencyInfo currencyOfBill, String[] localAmtProperties) {
        TransPrecisionUtil.trancatePrecisionForAmt(ctx, bill, amtProperties, TransPrecisionUtil.getBillCurrencyID(currencyOfBill));
        TransPrecisionUtil.trancatePrecisionForLocalAmt(ctx, bill, localAmtProperties);
    }

    private static String getBillCurrencyID(CurrencyInfo currencyOfBill) {
        return currencyOfBill.getId().toString();
    }

    private static void trancatePrecisionForLocalAmt(Context ctx, CoreBaseInfo coreBaseInfo, String[] localAmtProperties) {
        if (localAmtProperties != null && localAmtProperties.length > 0) {
            String localCurrencyID = TransPrecisionUtil.getlocalCurrencyID(ctx);
            TransPrecisionUtil.doTrancatePrecision(ctx, coreBaseInfo, localAmtProperties, localCurrencyID);
        }
    }

    private static String getlocalCurrencyID(Context ctx) {
        IContextHelper iCtxHelper = null;
        iCtxHelper = ctx == null ? ContextHelperFactory.getRemoteInstance() : ContextHelperFactory.getLocalInstance((Context)ctx);
        return iCtxHelper.getCurrentCompany().getBaseCurrency().getId().toString();
    }

    private static void trancatePrecisionForAmt(Context ctx, CoreBaseInfo coreBaseInfo, String[] amtProperties, String billCurrencyID) {
        if (amtProperties != null && amtProperties.length > 0) {
            TransPrecisionUtil.doTrancatePrecision(ctx, coreBaseInfo, amtProperties, billCurrencyID);
        }
    }

    private static void doTrancatePrecision(Context ctx, CoreBaseInfo coreBaseInfo, String[] amtProperties, String billCurrencyID) {
        int precision = FMHelper.getPrecOfCurrency(ctx, billCurrencyID);
        Class<?> coreBaseInfoClz = coreBaseInfo.getClass();
        Method getterTmp = null;
        Method setterTmp = null;
        Object propertyValue = null;
        BigDecimal tmpValue = Constants.ZERO;
        for (int i = 0; i < amtProperties.length; ++i) {
            try {
                getterTmp = coreBaseInfoClz.getMethod(TransPrecisionUtil.getGetterMethodName(amtProperties[i]), getterTypes);
                propertyValue = getterTmp.invoke((Object)coreBaseInfo, (Object[])getterTypes);
                if (!(propertyValue instanceof BigDecimal)) continue;
                tmpValue = (BigDecimal)propertyValue;
                setterTmp = coreBaseInfoClz.getMethod(TransPrecisionUtil.getSetterMethodName(amtProperties[i]), setterTypes);
                setterTmp.invoke((Object)coreBaseInfo, (Object[])new BigDecimal[]{tmpValue.setScale(precision, 4)});
                continue;
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
    }

    private static String getSetterMethodName(String property) {
        return SET_PREFIX + property.substring(0, 1).toUpperCase() + property.substring(1);
    }

    private static String getGetterMethodName(String property) {
        return GET_PREFIX + property.substring(0, 1).toUpperCase() + property.substring(1);
    }
}

